/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.util.ValueObjectUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Record
extends SQLUtil.DBHashtable {
    private String[] fields;
    private Map sameCols = null;
    private int rowid;
    private boolean isnull = true;
    private static Logger log = LoggerFactory.getLogger(Record.class);

    public Record(int i) {
        super(i, false);
    }

    public Record(boolean columnLableUpperCase, int i, String[] fields, Map sameCols) {
        super(i, columnLableUpperCase);
        this.fields = fields;
        if (sameCols != null && sameCols.size() > 0) {
            this.sameCols = sameCols;
        }
    }

    public Record(String[] fields, Map sameCols) {
        this.fields = fields;
        if (sameCols != null && sameCols.size() > 0) {
            this.sameCols = sameCols;
        }
    }

    public Record() {
    }

    public void setRowid(int rowid) {
        this.rowid = rowid;
    }

    public int getRowid() {
        return this.rowid;
    }

    public Record(int initialCapacity, float loadFactor, String[] fields, Map sameCols) {
        super(initialCapacity, loadFactor);
        this.fields = fields;
        if (sameCols != null && sameCols.size() > 0) {
            this.sameCols = sameCols;
        }
    }

    public Record(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public Record(Map t) {
        super(t);
        if (t != null) {
            this.isnull = false;
        }
    }

    public Record(Map t, String[] fields) {
        super(t);
        if (t != null) {
            this.isnull = false;
        }
        this.fields = fields;
    }

    public boolean wasNull() throws SQLException {
        return this.isnull;
    }

    public String getString(int parameterIndex) throws SQLException {
        Object object = this.getObject(parameterIndex);
        return ValueExchange.getStringFromObject(object);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        Boolean value = (Boolean)this.getObject(parameterIndex);
        if (value != null) {
            return value;
        }
        throw new SQLException("getBoolean(" + parameterIndex + ") failed:value=null.");
    }

    public byte getByte(int parameterIndex) throws SQLException {
        Byte byte_ = (Byte)this.getObject(parameterIndex);
        if (byte_ != null) {
            return byte_;
        }
        throw new SQLException("getByte(" + parameterIndex + ") failed:value=null.");
    }

    public short getShort(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        return this.getShortFromObject(value);
    }

    public short getShortFromObject(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s;
        }
        if (value instanceof Integer) {
            Integer data = (Integer)value;
            return data.shortValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)value;
            return b.shortValue();
        }
        if (value instanceof Double) {
            Double b = (Double)value;
            return b.shortValue();
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.shortValue();
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l.shortValue();
        }
        String i = String.valueOf(value);
        try {
            return Short.parseShort(i);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public int getIntFromObject(Object value) throws SQLException {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            Integer data = (Integer)value;
            return data;
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s.intValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)value;
            return b.intValue();
        }
        if (value instanceof Double) {
            Double b = (Double)value;
            return b.intValue();
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.intValue();
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l.intValue();
        }
        String i = String.valueOf(value);
        try {
            return Integer.parseInt(i);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public float getFloatFromObject(Object value) throws SQLException {
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.floatValue();
        }
        if (value instanceof Integer) {
            Integer data = (Integer)value;
            return data.floatValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)value;
            return b.floatValue();
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s.floatValue();
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l.floatValue();
        }
        if (value instanceof Double) {
            Double l = (Double)value;
            return l.floatValue();
        }
        String i = String.valueOf(value);
        try {
            return Float.parseFloat(i);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public double getDoubleFromObject(Object value) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            Double l = (Double)value;
            return l;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.doubleValue();
        }
        if (value instanceof Integer) {
            Integer data = (Integer)value;
            return data.doubleValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)value;
            return b.doubleValue();
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s.doubleValue();
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l.doubleValue();
        }
        String i = String.valueOf(value);
        try {
            return Double.parseDouble(i);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public int getInt(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        return this.getIntFromObject(value);
    }

    public long getLong(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        return this.getLongFromObject(value);
    }

    public long getLongFromObject(Object value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            Long l = (Long)value;
            return l;
        }
        if (value instanceof Double) {
            Double l = (Double)value;
            return l.longValue();
        }
        if (value instanceof Integer) {
            Integer data = (Integer)value;
            return data.longValue();
        }
        if (value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)value;
            return b.longValue();
        }
        if (value instanceof Short) {
            Short s = (Short)value;
            return s.longValue();
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.longValue();
        }
        String i = String.valueOf(value);
        try {
            return Long.parseLong(i);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public float getFloat(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        return this.getFloatFromObject(value);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        return this.getDoubleFromObject(value);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal big = this.getBigDecimal(parameterIndex);
        if (big != null) {
            return big.setScale(scale);
        }
        return null;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        Object bytes = this.getObject(parameterIndex);
        if (bytes instanceof byte[]) {
            return (byte[])bytes;
        }
        return ValueExchange.convertObjectToBytes(bytes);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        Object date = this.getObject(parameterIndex);
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof java.util.Date) {
            return new Date(((java.util.Date)date).getTime());
        }
        throw new SQLException("Record.getDate(" + parameterIndex + ") failed: error data type[" + date.getClass().getName() + "," + date + "]");
    }

    public Time getTime(int parameterIndex) throws SQLException {
        Object object = this.getObject(parameterIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            return new Time(((java.util.Date)object).getTime());
        }
        throw new SQLException("Record.getTime(" + parameterIndex + ") failed: error data type[" + object.getClass().getName() + "," + object + "]");
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        Object object = this.getObject(parameterIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        throw new SQLException("Record.getTimestamp(" + parameterIndex + ") failed: error data type[" + object.getClass().getName() + "," + object + "]");
    }

    private String seekField(int column) throws SQLException {
        if (column > this.fields.length || column < 0) {
            throw new SQLException("column out of range:column=" + column + ",fields.length=" + this.fields.length);
        }
        if (this.sameCols == null || column == 0) {
            return this.fields[column];
        }
        String temp = this.fields[column];
        PoolManResultSetMetaData.WrapInteger wi = (PoolManResultSetMetaData.WrapInteger)this.sameCols.get(temp);
        if (wi == null) {
            return temp;
        }
        return wi.getColumnName(column);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.fields != null) {
            return this.get(this.seekField(parameterIndex));
        }
        return this.get(new Integer(parameterIndex));
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return (BigDecimal)this.getObject(parameterIndex);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getObject(i);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object object = this.getObject(columnIndex);
        if (object == null) {
            return null;
        }
        if (object instanceof Reader) {
            return (Reader)object;
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getCharacterStream();
        }
        throw new SQLException("Error type cast column index[" + columnIndex + "]:From [" + object.getClass().getName() + "] to [" + Reader.class.getName() + "]");
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return clob.getAsciiStream();
        }
        if (value instanceof Blob) {
            Blob clob = (Blob)value;
            return clob.getBinaryStream();
        }
        throw new SQLException("Error type cast column index[" + columnIndex + "]:From [" + value.getClass().getName() + "] to [" + InputStream.class.getName() + "]");
    }

    public InputStream getAsciiStream(String colName) throws SQLException {
        Object value = this.getObject(colName);
        if (value == null) {
            return null;
        }
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return clob.getAsciiStream();
        }
        if (value instanceof Blob) {
            Blob clob = (Blob)value;
            return clob.getBinaryStream();
        }
        throw new SQLException("Error type cast column[" + colName + "]:From [" + value.getClass().getName() + "] to [" + InputStream.class.getName() + "]");
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        Object object = this.getObject(columnName);
        if (object == null) {
            return null;
        }
        if (object instanceof Reader) {
            return (Reader)object;
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getCharacterStream();
        }
        throw new SQLException("Error type cast column[" + columnName + "]:From [" + object.getClass().getName() + "] to [" + Reader.class.getName() + "]");
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return blob.getBinaryStream();
        }
        if (value instanceof Clob) {
            Clob blob = (Clob)value;
            return blob.getAsciiStream();
        }
        throw new SQLException("Error type cast column index[" + columnIndex + "]:From [" + value.getClass().getName() + "] to [" + InputStream.class.getName() + "]");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return blob.getBinaryStream();
        }
        if (value instanceof Clob) {
            Clob blob = (Clob)value;
            return blob.getAsciiStream();
        }
        throw new SQLException("Error type cast column index[" + columnIndex + "]:From [" + value.getClass().getName() + "] to [" + InputStream.class.getName() + "]");
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return blob.getBinaryStream();
        }
        if (value instanceof Clob) {
            Clob blob = (Clob)value;
            return blob.getAsciiStream();
        }
        throw new SQLException("Error type cast column[" + columnName + "]:From [" + value.getClass().getName() + "] to [" + InputStream.class.getName() + "]");
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        Object value = this.getObject(columnName);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            return blob.getBinaryStream();
        }
        if (value instanceof Clob) {
            Clob blob = (Clob)value;
            return blob.getAsciiStream();
        }
        throw new SQLException("Error type cast column[" + columnName + "]:From [" + value.getClass().getName() + "] to [" + InputStream.class.getName() + "]");
    }

    public Ref getRef(int i) throws SQLException {
        return (Ref)this.getObject(i);
    }

    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.getObject(i);
    }

    public Clob getClob(int i) throws SQLException {
        return (Clob)this.getObject(i);
    }

    public Array getArray(int i) throws SQLException {
        return (Array)this.getObject(i);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(parameterIndex);
        if (date != null) {
            cal.setTime(date);
            return new Date(cal.getTimeInMillis());
        }
        return null;
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(parameterIndex);
        if (time != null) {
            cal.setTimeInMillis(time.getTime());
            return new Time(cal.getTimeInMillis());
        }
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp date = this.getTimestamp(parameterIndex);
        if (date != null) {
            cal.setTimeInMillis(date.getTime());
            return new Timestamp(cal.getTimeInMillis());
        }
        return null;
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return (URL)this.getObject(parameterIndex);
    }

    public String getString(String parameterName) throws SQLException {
        Object object = this.getObject(parameterName);
        return ValueExchange.getStringFromObject(object);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        Boolean value = (Boolean)this.getObject(parameterName);
        if (value != null) {
            return value;
        }
        throw new SQLException("getBoolean(" + parameterName + ") failed:value=null.");
    }

    public byte getByte(String parameterName) throws SQLException {
        Byte byte_ = (Byte)this.getObject(parameterName);
        if (byte_ != null) {
            return byte_;
        }
        throw new SQLException("getByte(" + parameterName + ") failed:value=null.");
    }

    public short getShort(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        return this.getShortFromObject(value);
    }

    public int getInt(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        return this.getIntFromObject(value);
    }

    public long getLong(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        return this.getLongFromObject(value);
    }

    public float getFloat(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        return this.getFloatFromObject(value);
    }

    public double getDouble(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        return this.getDoubleFromObject(value);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        Object bytes = this.getObject(parameterName);
        if (bytes instanceof byte[]) {
            return (byte[])bytes;
        }
        return ValueExchange.convertObjectToBytes(bytes);
    }

    public Date getDate(String parameterName) throws SQLException {
        Object date = this.getObject(parameterName);
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof java.util.Date) {
            return new Date(((java.util.Date)date).getTime());
        }
        throw new SQLException("Record.getDate(" + parameterName + ") failed: error data type[" + date.getClass().getName() + "," + date + "]");
    }

    public Time getTime(String parameterName) throws SQLException {
        Object object = this.getObject(parameterName);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            return new Time(((java.util.Date)object).getTime());
        }
        throw new SQLException("Record.getTime(" + parameterName + ") failed: error data type[" + object.getClass().getName() + "," + object + "]");
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Object object = this.getObject(parameterName);
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        throw new SQLException("Record.getTimestamp(" + parameterName + ") failed: error data type[" + object.getClass().getName() + "," + object + "]");
    }

    public Object getObject(String parameterName) throws SQLException {
        if (this.columnLableUpperCase) {
            return this.get(parameterName.toUpperCase());
        }
        return this.get(parameterName);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return (BigDecimal)this.getObject(parameterName);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.get(parameterName.toLowerCase());
    }

    public Ref getRef(String parameterName) throws SQLException {
        return (Ref)this.getObject(parameterName);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return (Blob)this.getObject(parameterName);
    }

    public Clob getClob(String parameterName) throws SQLException {
        return (Clob)this.getObject(parameterName);
    }

    public Array getArray(String parameterName) throws SQLException {
        return (Array)this.getObject(parameterName);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        Date date = this.getDate(parameterName);
        if (date != null) {
            cal.setTime(date);
            return new Date(cal.getTimeInMillis());
        }
        return null;
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        Time time = this.getTime(parameterName);
        if (time != null) {
            cal.setTimeInMillis(time.getTime());
            return new Time(cal.getTimeInMillis());
        }
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        Timestamp date = this.getTimestamp(parameterName);
        if (date != null) {
            cal.setTimeInMillis(date.getTime());
            return new Timestamp(cal.getTimeInMillis());
        }
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        return (URL)this.getObject(parameterName);
    }

    public void getFile(int index, File file) throws SQLException, IOException {
        Object value = this.getObject(index);
        this.getFile(value, file);
    }

    public void getFile(Object value, File file) throws SQLException {
        if (value == null) {
            return;
        }
        if (value instanceof Blob) {
            ValueObjectUtil.getFileFromBlob((Blob)((Blob)value), (File)file);
        } else if (value instanceof Clob) {
            ValueObjectUtil.getFileFromClob((Clob)((Clob)value), (File)file);
        } else if (value instanceof byte[]) {
            ValueObjectUtil.getFileFromBytes((byte[])((byte[])value), (File)file);
        } else if (value instanceof String) {
            ValueObjectUtil.getFileFromString((String)((String)value), (File)file);
        } else {
            ValueObjectUtil.getFileFromString((String)value.toString(), (File)file);
        }
    }

    public void getFile(String parameterName, File file) throws SQLException, IOException {
        Object value = this.getObject(parameterName);
        this.getFile(value, file);
    }

    public Serializable getSerializable(String field) throws SQLException {
        Blob blog = this.getBlob(field);
        if (blog == null) {
            return null;
        }
        Serializable object = null;
        InputStream in = null;
        ObjectInputStream objectin = null;
        try {
            in = blog.getBinaryStream();
            objectin = new ObjectInputStream(in);
            object = (Serializable)objectin.readObject();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (objectin != null) {
                try {
                    objectin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public Serializable getSerializable(int parameterIndex) throws SQLException {
        Blob blog = this.getBlob(parameterIndex);
        if (blog == null) {
            return null;
        }
        Serializable object = null;
        InputStream in = null;
        ObjectInputStream objectin = null;
        try {
            in = blog.getBinaryStream();
            objectin = new ObjectInputStream(in);
            object = (Serializable)objectin.readObject();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (objectin != null) {
                try {
                    objectin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }
}

