/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.management;

import com.frameworkset.common.poolman.management.BaseTableManager;
import com.frameworkset.common.poolman.management.PoolManConfiguration;
import com.frameworkset.common.poolman.management.PoolManDeployer;
import com.frameworkset.common.poolman.util.DBStartResult;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.common.poolman.util.SQLManager;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPoolDeployer
extends BaseTableManager
implements PoolManDeployer,
Serializable {
    public static boolean addShutdownHook = false;
    private static Logger logger = LoggerFactory.getLogger(LocalPoolDeployer.class);

    public static void shutdownHandle() {
        if (addShutdownHook) {
            return;
        }
        try {
            ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        BaseTableManager.updateTableInfo();
                        SQLManager.destroy(false);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to properly shutdown: ", (Throwable)e);
                    }
                }
            }, (int)0x7FFFFFF6);
            addShutdownHook = true;
        }
        catch (Exception e) {
            addShutdownHook = true;
        }
    }

    @Override
    public DBStartResult deployConfiguration(PoolManConfiguration config) throws Exception {
        DBStartResult dbStartResult = this.startDataSources(config.getDataSources(), config.getConnectionProperties());
        LocalPoolDeployer.shutdownHandle();
        return dbStartResult;
    }

    @Override
    public DBStartResult deployConfiguration(PoolManConfiguration config, String dbname) throws Exception {
        DBStartResult dbStartResult = this.startDataSources(config.getDataSources(), config.getConnectionProperties());
        LocalPoolDeployer.shutdownHandle();
        return dbStartResult;
    }

    public DBStartResult deployConfiguration(PoolManConfiguration config, Map values) throws Exception {
        DBStartResult dbStartResult = this.startDataSource(config.getDataSources(), values, config.getConnectionProperties(), config);
        LocalPoolDeployer.shutdownHandle();
        return dbStartResult;
    }

    private DBStartResult startDataSources(ArrayList datasources, Properties connectionProperties) throws Exception {
        if (datasources == null) {
            return null;
        }
        DBStartResult dbStartResult = new DBStartResult();
        for (Properties dbprops : datasources) {
            JDBCPool jdbcPool;
            JDBCPoolMetaData metadata = new JDBCPoolMetaData();
            metadata.setConnectionProperties(connectionProperties);
            BeanInfo beanInfo = Introspector.getBeanInfo(metadata.getClass());
            PropertyDescriptor[] attributes = beanInfo.getPropertyDescriptors();
            for (int n = 0; n < attributes.length; ++n) {
                String attrName = attributes[n].getName();
                if (!dbprops.containsKey(attrName.toLowerCase())) continue;
                String propsVal = dbprops.getProperty(attrName.toLowerCase());
                Class<Object> type = attributes[n].getPropertyType();
                if (type == Boolean.class) {
                    type = Boolean.TYPE;
                }
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                editor.setAsText(propsVal);
                Object value = editor.getValue();
                attributes[n].getWriteMethod().invoke((Object)metadata, value);
            }
            metadata.initDatasourceParameters();
            if (logger.isInfoEnabled()) {
                logger.info(" Created JDBC Connection Pool named {},config:{}", (Object)metadata.getName(), (Object)metadata.toString());
            }
            if ((jdbcPool = SQLManager.getInstance().createPool(metadata, null)) == null) continue;
            dbStartResult.addDBStartResult(jdbcPool.getDBName());
        }
        return dbStartResult;
    }

    private DBStartResult startDataSource(ArrayList datasources, Map<String, String> values, Properties connectionProperties, PoolManConfiguration config) throws Exception {
        if (datasources == null) {
            return null;
        }
        DBStartResult dbStartResult = new DBStartResult();
        Properties dbprops2 = null;
        for (Properties dbprops2 : datasources) {
            JDBCPool jpool;
            boolean useTemplate = false;
            if (values != null && values.size() > 0) {
                String dbname = values.get("dbname");
                String temp = (String)dbprops2.get("dbname");
                if (temp != null && dbname != null && (temp.equals(dbname) || temp.equals("${dbname}"))) {
                    useTemplate = true;
                }
            }
            JDBCPoolMetaData metadata = new JDBCPoolMetaData();
            metadata.setConnectionProperties(connectionProperties);
            BeanInfo beanInfo = Introspector.getBeanInfo(metadata.getClass());
            PropertyDescriptor[] attributes = beanInfo.getPropertyDescriptors();
            for (int n = 0; n < attributes.length; ++n) {
                String attrName = attributes[n].getName();
                if (!dbprops2.containsKey(attrName.toLowerCase())) continue;
                String propsVal = null;
                if (!useTemplate) {
                    propsVal = dbprops2.getProperty(attrName.toLowerCase());
                } else {
                    propsVal = values.get(attrName.toLowerCase());
                    if (propsVal == null) {
                        propsVal = dbprops2.getProperty(attrName.toLowerCase());
                    }
                }
                Class<Boolean> type = attributes[n].getPropertyType();
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                Object value = null;
                if (type.isAssignableFrom(Boolean.class)) {
                    if (propsVal != null && !propsVal.trim().equals("")) {
                        editor.setAsText(propsVal);
                        value = editor.getValue();
                    }
                } else {
                    editor.setAsText(propsVal);
                    value = editor.getValue();
                }
                attributes[n].getWriteMethod().invoke((Object)metadata, value);
            }
            metadata.initDatasourceParameters();
            if (logger.isInfoEnabled()) {
                logger.info(" Created JDBC Connection Pool named {},config:{}", (Object)metadata.getName(), (Object)metadata.toString());
            }
            if ((jpool = SQLManager.getInstance().createPool(metadata, config != null ? config.getDatasourceConfig() : null)) == null) continue;
            dbStartResult.addDBStartResult(jpool.getDBName());
        }
        return dbStartResult;
    }
}

