/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.sql;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.sql.ColumnMetaData;
import com.frameworkset.common.poolman.sql.PrimaryKeyMetaData;
import com.frameworkset.common.poolman.sql.Sequence;
import com.frameworkset.common.poolman.sql.TableMetaData;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.transaction.JDBCTransaction;
import com.frameworkset.orm.transaction.TransactionException;
import com.frameworkset.orm.transaction.TransactionManager;
import com.frameworkset.util.UUID;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKey {
    private static Logger log = LoggerFactory.getLogger(PrimaryKey.class);
    private Map primaryKeys;
    private int increment = 1;
    private String primaryKeyName;
    private String tableName;
    private long curValue;
    private String type = "int";
    private String metaType = "int";
    private String dbname = null;
    private String prefix = "";
    private DB dbAdapter = null;
    private String maxSql = "";
    private int keygenerator_mode = 0;
    private Object customKey = null;
    private boolean hasTableinfo = true;
    boolean synsequece = false;
    private String seqfunction;
    private String generator;
    private String select;

    public PrimaryKey(String dbname, String tableName, String primaryKeyName, Object customKey, Connection con) {
        this.dbname = dbname;
        this.dbAdapter = SQLManager.getInstance().getDBAdapter(dbname);
        this.tableName = tableName;
        this.primaryKeyName = primaryKeyName;
        JDBCPool pool = SQLManager.getInstance().getPool(dbname);
        SQLManager.assertPool(pool, dbname);
        this.synsequece = pool.getJDBCPoolMetadata().synsequence();
        this.seqfunction = pool.getJDBCPoolMetadata().getSeqfunction();
        try {
            TableMetaData table = pool.getTableMetaData(con, tableName);
            if (table != null) {
                if (primaryKeyName != null) {
                    ColumnMetaData cd = pool.getColumnMetaData(con, tableName, primaryKeyName);
                    int type_ = cd.getDataType();
                    this.setType_(type_);
                } else {
                    Iterator<ColumnMetaData> keyitrs;
                    Set<ColumnMetaData> keys = table.getPrimaryKeys();
                    if (keys != null && (keyitrs = keys.iterator()).hasNext()) {
                        PrimaryKeyMetaData key = (PrimaryKeyMetaData)keyitrs.next();
                        this.primaryKeyName = key.getColumnName().toLowerCase();
                        this.setType_(key.getColumn().getDataType());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String mode = pool.getKeygenerate();
        if (mode.trim().equalsIgnoreCase("auto")) {
            this.keygenerator_mode = 0;
        } else if (mode.trim().equalsIgnoreCase("composite")) {
            this.keygenerator_mode = 1;
        }
        this.customKey = customKey;
    }

    private void setType_(int type_) {
        this.metaType = this.type = PrimaryKey.getJavaType(type_);
    }

    public static String getJavaType(int sqltype_) {
        String javatype = "int";
        switch (sqltype_) {
            case 4: {
                javatype = "int";
                break;
            }
            case 2: {
                javatype = "long";
                break;
            }
            case 5: {
                javatype = "int";
                break;
            }
            case 3: {
                javatype = "int";
                break;
            }
            case 8: {
                javatype = "long";
                break;
            }
            case 6: {
                javatype = "long";
                break;
            }
            case 12: {
                javatype = "string";
            }
        }
        return javatype;
    }

    public PrimaryKey(String dbname, String tableName, String primaryKeyName, int increment, long curValue, String type, String prefix, String maxSql, Connection con) {
        this.dbname = dbname;
        this.dbAdapter = SQLManager.getInstance().getDBAdapter(dbname);
        this.tableName = tableName;
        this.primaryKeyName = primaryKeyName;
        this.increment = increment;
        this.curValue = curValue;
        JDBCPool pool = SQLManager.getInstance().getPool(dbname);
        SQLManager.assertPool(pool, dbname);
        this.synsequece = pool.getJDBCPoolMetadata().synsequence();
        this.seqfunction = pool.getJDBCPoolMetadata().getSeqfunction();
        String mode = pool.getKeygenerate();
        if (mode.trim().equalsIgnoreCase("auto")) {
            this.keygenerator_mode = 0;
        } else if (mode.trim().equalsIgnoreCase("composite")) {
            this.keygenerator_mode = 1;
        }
        if (type != null && !type.trim().equals("")) {
            this.type = type;
        }
        if (prefix != null && !prefix.trim().equals("")) {
            this.prefix = prefix;
        }
        this.maxSql = maxSql;
        if (type.equals("sequence")) {
            ColumnMetaData cd = pool.getColumnMetaData(con, tableName, primaryKeyName);
            if (cd != null) {
                int type_ = cd.getDataType();
                this.metaType = PrimaryKey.getJavaType(type_);
            } else {
                this.metaType = "int";
            }
        } else if (type.equals("uuid")) {
            ColumnMetaData cd = pool.getColumnMetaData(con, tableName, primaryKeyName);
            if (cd != null) {
                int type_ = cd.getDataType();
                this.metaType = PrimaryKey.getJavaType(type_);
            } else {
                this.metaType = "string";
            }
        } else {
            this.metaType = type;
        }
    }

    public PrimaryKey(String dbname, String tableName, String primaryKeyName, int increment, long curValue, String type, String prefix, String maxSql, String generator, Connection con) {
        this.dbname = dbname;
        this.generator = generator;
        this.dbAdapter = SQLManager.getInstance().getDBAdapter(dbname);
        this.tableName = tableName;
        this.primaryKeyName = primaryKeyName;
        this.increment = increment;
        this.curValue = curValue;
        JDBCPool pool = SQLManager.getInstance().getPool(dbname);
        SQLManager.assertPool(pool, dbname);
        this.synsequece = pool.getJDBCPoolMetadata().synsequence();
        this.seqfunction = pool.getJDBCPoolMetadata().getSeqfunction();
        String mode = pool.getKeygenerate();
        if (mode.trim().equalsIgnoreCase("auto")) {
            this.keygenerator_mode = 0;
        } else if (mode.trim().equalsIgnoreCase("composite")) {
            this.keygenerator_mode = 1;
        }
        if (type != null && !type.trim().equals("")) {
            this.type = type;
        }
        if (prefix != null && !prefix.trim().equals("")) {
            this.prefix = prefix;
        }
        this.maxSql = maxSql;
        if (type.equals("sequence")) {
            ColumnMetaData cd = pool.getColumnMetaData(con, tableName, primaryKeyName);
            if (cd != null) {
                int type_ = cd.getDataType();
                this.metaType = PrimaryKey.getJavaType(type_);
            } else {
                this.metaType = "int";
            }
        } else if (type.equals("uuid")) {
            ColumnMetaData cd = pool.getColumnMetaData(con, tableName, primaryKeyName);
            if (cd != null) {
                int type_ = cd.getDataType();
                this.metaType = PrimaryKey.getJavaType(type_);
            } else {
                this.metaType = "string";
            }
        } else {
            this.metaType = type;
        }
    }

    public PrimaryKey() {
    }

    private boolean exist(Connection con, long curValue) throws SQLException {
        String select = "select count(1) from " + this.tableName + " where " + this.primaryKeyName + "=?";
        PreparedDBUtil dbUtil = new PreparedDBUtil();
        try {
            dbUtil.preparedSelect(this.dbname, select);
            if (this.metaType.equals("int") || this.metaType.equals("java.lang.Integer") || this.metaType.equals("java.lang.integer") || this.metaType.equalsIgnoreCase("integer")) {
                dbUtil.setInt(1, (int)curValue);
            } else if (this.metaType.equals("java.lang.Long") || this.metaType.equals("java.lang.long") || this.metaType.equalsIgnoreCase("long")) {
                dbUtil.setLong(1, curValue);
            } else if (this.metaType.equals("java.lang.String") || this.metaType.equalsIgnoreCase("string")) {
                dbUtil.setString(1, this.prefix + curValue + "");
            } else {
                dbUtil.setString(1, this.prefix + curValue + "");
            }
            dbUtil.executePrepared(con);
            if (dbUtil.getInt(0, 0) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            throw e1;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new SQLException(e1.getMessage());
        }
        finally {
            dbUtil.resetPrepare();
        }
        return false;
    }

    public Sequence generateObjectKey() throws SQLException {
        return this.generateObjectKey(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence generateObjectKey(Connection con) throws SQLException {
        Sequence sequence = new Sequence();
        if (this.type.equals("sequence")) {
            long curValue = this.curValue;
            while (true) {
                curValue = this.dbAdapter.getNextValue(this.seqfunction, this.generator, con, this.dbname);
                if (this.synsequece && this.exist(con, curValue)) {
                    continue;
                }
                break;
            }
            this.curValue = curValue;
            if (this.metaType.equals("int") || this.metaType.equals("java.lang.Integer") || this.metaType.equals("java.lang.integer") || this.metaType.equalsIgnoreCase("integer")) {
                sequence.setPrimaryKey(new Long(curValue));
                sequence.setSequence(curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.Long") || this.metaType.equals("java.lang.long") || this.metaType.equalsIgnoreCase("long")) {
                sequence.setPrimaryKey(new Long(curValue));
                sequence.setSequence(curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.String") || this.metaType.equalsIgnoreCase("string")) {
                sequence.setPrimaryKey((Serializable)((Object)(this.prefix + curValue + "")));
                sequence.setSequence(curValue);
                return sequence;
            }
            sequence.setPrimaryKey((Serializable)((Object)(this.prefix + curValue + "")));
            sequence.setSequence(curValue);
            return sequence;
        }
        if (this.type.equals("uuid")) {
            sequence.setPrimaryKey((Serializable)((Object)UUID.randomUUID().toString()));
            sequence.setSequence(this.curValue);
            return sequence;
        }
        PrimaryKey primaryKey = this;
        synchronized (primaryKey) {
            switch (this.keygenerator_mode) {
                case 0: {
                    this.curValue += (long)this.increment;
                    break;
                }
                case 1: {
                    this.curValue += (long)this.increment;
                    this.synchroDB(con);
                }
            }
            if (this.metaType.equals("int") || this.metaType.equals("java.lang.Integer") || this.metaType.equals("java.lang.integer") || this.metaType.equalsIgnoreCase("integer")) {
                sequence.setPrimaryKey(new Long(this.curValue));
                sequence.setSequence(this.curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.Long") || this.metaType.equals("java.lang.long") || this.metaType.equalsIgnoreCase("long")) {
                sequence.setPrimaryKey(new Long(this.curValue));
                sequence.setSequence(this.curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.String") || this.metaType.equalsIgnoreCase("string")) {
                sequence.setPrimaryKey((Serializable)((Object)(this.prefix + this.curValue + "")));
                sequence.setSequence(this.curValue);
                return sequence;
            }
            sequence.setPrimaryKey((Serializable)((Object)(this.prefix + this.curValue + "")));
            sequence.setSequence(this.curValue);
            return sequence;
        }
    }

    public Sequence generateObjectKey(String type, String prefix) throws SQLException {
        return this.generateObjectKey(type, prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence generateObjectKey(String type, String prefix, Connection con) throws SQLException {
        Sequence sequence = new Sequence();
        if (type.equals("sequence")) {
            long curValue = this.curValue;
            try {
                while (true) {
                    curValue = this.dbAdapter.getNextValue(this.seqfunction, this.generator, con, this.dbname);
                    if (this.synsequece && this.exist(con, curValue)) {
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw e;
            }
            this.curValue = curValue;
            if (this.metaType.equals("int") || this.metaType.equals("java.lang.Integer") || this.metaType.equals("java.lang.integer") || this.metaType.equalsIgnoreCase("integer")) {
                sequence.setPrimaryKey(new Long(curValue));
                sequence.setSequence(curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.Long") || this.metaType.equals("java.lang.long") || this.metaType.equalsIgnoreCase("long")) {
                sequence.setPrimaryKey(new Long(curValue));
                sequence.setSequence(curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.String") || this.metaType.equalsIgnoreCase("string")) {
                sequence.setPrimaryKey((Serializable)((Object)(this.prefix + curValue + "")));
                sequence.setSequence(curValue);
                return sequence;
            }
            sequence.setPrimaryKey((Serializable)((Object)(this.prefix + curValue + "")));
            sequence.setSequence(curValue);
            return sequence;
        }
        if (type.equals("uuid")) {
            sequence.setPrimaryKey((Serializable)((Object)UUID.randomUUID().toString()));
            sequence.setSequence(this.curValue);
            return sequence;
        }
        PrimaryKey primaryKey = this;
        synchronized (primaryKey) {
            switch (this.keygenerator_mode) {
                case 0: {
                    this.curValue += (long)this.increment;
                    break;
                }
                case 1: {
                    this.curValue += (long)this.increment;
                    this.synchroDB(con);
                }
            }
            if (this.metaType.equals("int") || this.metaType.equals("java.lang.Integer") || this.metaType.equals("java.lang.integer") || this.metaType.equalsIgnoreCase("integer")) {
                sequence.setPrimaryKey(new Long(this.curValue));
                sequence.setSequence(this.curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.Long") || this.metaType.equals("java.lang.long") || this.metaType.equalsIgnoreCase("long")) {
                sequence.setPrimaryKey(new Long(this.curValue));
                sequence.setSequence(this.curValue);
                return sequence;
            }
            if (this.metaType.equals("java.lang.String") || this.metaType.equalsIgnoreCase("string")) {
                sequence.setPrimaryKey((Serializable)((Object)(this.prefix + this.curValue + "")));
                sequence.setSequence(this.curValue);
                return sequence;
            }
            sequence.setPrimaryKey((Serializable)((Object)(this.prefix + this.curValue + "")));
            sequence.setSequence(this.curValue);
            return sequence;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void synchroDB(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        JDBCTransaction tx = null;
        boolean outcon = true;
        try {
            if (con == null) {
                tx = TransactionManager.getTransaction();
                con = tx == null ? SQLManager.getInstance().requestConnection(this.dbname) : tx.getConnection(this.dbname);
                outcon = false;
            }
            stmt = con.createStatement();
            rs = stmt.executeQuery(this.maxSql);
            long temp = 0L;
            if (rs.next()) {
                temp = rs.getLong(1);
            }
            if (temp >= this.curValue) {
                this.curValue = temp + 1L;
            }
            if (con == null) return;
        }
        catch (SQLException e) {
            try {
                throw new NestedSQLException("\u540c\u6b65\u5f53\u524d\u7f13\u51b2\u4e2d\u8868[" + this.tableName + "]\u7684\u4e3b\u952e[" + this.primaryKeyName + "]\u6700\u5927\u503c\u4e0e\u6570\u636e\u5e93\u8be5\u8868\u4e3b\u952e\u6700\u5927\u503c\u5931\u8d25\uff0c\u7cfb\u7edf\u91c7\u7528\u81ea\u52a8\u4ea7\u751f\u7684\u4e3b\u952e\uff1a", (Throwable)e);
                catch (TransactionException e2) {
                    throw new NestedSQLException("\u540c\u6b65\u5f53\u524d\u7f13\u51b2\u4e2d\u8868[" + this.tableName + "]\u7684\u4e3b\u952e[" + this.primaryKeyName + "]\u6700\u5927\u503c\u4e0e\u6570\u636e\u5e93\u8be5\u8868\u4e3b\u952e\u6700\u5927\u503c\u5931\u8d25\uff0c\u7cfb\u7edf\u91c7\u7528\u81ea\u52a8\u4ea7\u751f\u7684\u4e3b\u952e\uff1a", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (con != null) {
                    JDBCPool.closeResources(stmt, rs);
                    if (!outcon && tx == null) {
                        JDBCPool.closeConnection(con);
                    }
                }
                con = null;
                throw throwable;
            }
        }
        JDBCPool.closeResources(stmt, rs);
        if (outcon) return;
        if (tx != null) return;
        JDBCPool.closeConnection(con);
    }

    public static String changeID(Serializable id, String dbName, String type) {
        if (type.equals("int") || type.equals("java.lang.Integer") || type.equals("java.lang.integer") || type.equalsIgnoreCase("integer")) {
            return id.toString();
        }
        if (type.equals("java.lang.Long") || type.equals("java.lang.long") || type.equalsIgnoreCase("long")) {
            return id.toString();
        }
        if (type.equals("java.lang.String") || type.equalsIgnoreCase("string")) {
            char stringDelimiter = SQLManager.getInstance().getDBAdapter(dbName).getStringDelimiter();
            return "" + stringDelimiter + id + stringDelimiter;
        }
        char stringDelimiter = SQLManager.getInstance().getDBAdapter(dbName).getStringDelimiter();
        return "" + stringDelimiter + id + stringDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long restoreKey(Object oldValue) {
        PrimaryKey primaryKey = this;
        synchronized (primaryKey) {
            long temp = this.getKeyID(oldValue);
            if (this.curValue == temp) {
                this.curValue -= (long)this.increment;
            }
        }
        return this.curValue;
    }

    public long getKeyID(Object key) {
        long temp = 0L;
        if (key instanceof Long) {
            temp = (Long)key;
        } else {
            String t_ = key.toString();
            t_ = t_.substring(this.prefix.length());
            try {
                temp = Long.parseLong(t_);
            }
            catch (Exception e) {
                temp = 0L;
            }
        }
        return temp;
    }

    public synchronized void setCurValue(long newValue, Statement stmt, String updateSql) throws SQLException {
        if (this.curValue < newValue) {
            this.curValue = newValue;
        }
    }

    public void updateTableinfo(Connection con) throws SQLException {
    }

    public long getCurValue() {
        return this.curValue;
    }

    public int getIncrement() {
        return this.increment;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDbname() {
        return this.dbname;
    }

    public void setHasTableinfo(boolean hasTableinfo) {
        this.hasTableinfo = hasTableinfo;
    }

    public boolean hasTableinfo() {
        return this.hasTableinfo;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("table=").append(this.tableName).append(",primaryKey=").append(this.primaryKeyName).append(",type=").append(this.type);
        return buffer.toString();
    }

    public String getMetaType() {
        return this.metaType;
    }

    public void setMetaType(String metaType) {
        this.metaType = metaType;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            System.out.println(UUID.randomUUID().toString().length());
        }
    }
}

