/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.sql.PrimaryKey;
import com.frameworkset.common.poolman.sql.PrimaryKeyCacheManager;
import com.frameworkset.common.poolman.sql.Sequence;
import com.frameworkset.common.poolman.sql.UpdateSQL;
import com.frameworkset.util.RegexUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementParser {
    private static Logger log = LoggerFactory.getLogger(StatementParser.class);

    public static String[] parserInsert(String insert) {
        String patternStr = "\\s*(insert)\\s+(into)\\s+([^\\(^\\s]+)\\s*(\\([^\\)]+\\))\\s*(values)\\s*(\\(.*(.*\n*)*.*)";
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        boolean match = matcher.matches(insert, pattern);
        if (match) {
            result = matcher.getMatch();
            tokens = new String[6];
            for (int i = 0; i < 6; ++i) {
                tokens[i] = result.group(i + 1).trim();
            }
        }
        return tokens;
    }

    public static String[] parseField(String fieldStr) {
        String regx = "([^\\,^\\(^\\)]+)\\s*\\,?\\s*";
        return RegexUtil.containWithPatternMatcherInput((String)fieldStr, (String)regx);
    }

    public static String[] parserValues(String values) {
        String patternStr = "([^\\,]*)[\\,]?";
        String patternStr1 = "('?[^\\,]*'?)[\\,]?";
        String[] ret = RegexUtil.containWithPatternMatcherInput((String)values, (String)patternStr1);
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern = null;
        try {
            pattern = compiler.compile(patternStr, 1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult result = null;
        String[] tokens = null;
        boolean match = matcher.matches(values.trim(), pattern);
        System.out.println(match);
        if (match) {
            result = matcher.getMatch();
            tokens = new String[6];
            for (int i = 0; i < 6; ++i) {
                tokens[i] = result.group(i + 1).trim();
                System.out.println(tokens[i]);
            }
        }
        return tokens;
    }

    public static void main(String[] args) {
        String insert = "insert into td_cms_channel(NAME, DISPLAY_NAME, PARENT_ID,CHNL_PATH, CREATEUSER, CREATETIME, ORDER_NO,SITE_ID, STATUS, OUTLINE_TPL_ID, DETAIL_TPL_ID,CHNL_OUTLINE_DYNAMIC, DOC_DYNAMIC,CHNL_OUTLINE_PROTECT, DOC_PROTECT,WORKFLOW,PARENT_WORKFLOW) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        StatementParser.parserInsert(insert);
    }

    public static Object[] refactorInsertStatement(Connection con, String insertStmt, String dbname) throws SQLException {
        return StatementParser.refactorInsertStatement(con, insertStmt, dbname, false);
    }

    public static Object[] refactorInsertStatement(StatementInfo stmtInfo) throws SQLException {
        return StatementParser.refactorInsertStatement(stmtInfo.getCon(), stmtInfo.getSql(), stmtInfo.getDbname(), stmtInfo.isPrepared());
    }

    public static Object[] refactorInsertStatement(Connection con, String insertStmt, String dbname, boolean prepared) throws SQLException {
        Object[] ret = new Object[6];
        String[] tableInfos = StatementParser.parserInsert(insertStmt);
        if (tableInfos == null) {
            ret[0] = insertStmt;
            return ret;
        }
        String insert = tableInfos[0];
        String into = tableInfos[1];
        String tableName = tableInfos[2];
        String fields = tableInfos[3];
        String values_key = tableInfos[4];
        String values = tableInfos[5];
        PrimaryKey primaryKey = null;
        try {
            primaryKey = PrimaryKeyCacheManager.getInstance().getPrimaryKeyCache(dbname).getIDTable(con, tableName.toLowerCase());
        }
        catch (Exception e) {
            log.info("[db:" + dbname + "] tableinfo not initialed or initial failed or check the table [tableinfo has been created] or table[" + tableName + "'s information has been inserted into tableinfo]\r\n please check log to view detail.");
            ret[0] = insertStmt;
            return ret;
        }
        if (primaryKey == null) {
            ret[0] = insertStmt;
            PrimaryKey t_p = new PrimaryKey(dbname, tableName, null, null, con);
            ret[3] = t_p;
            return ret;
        }
        String idName = primaryKey.getPrimaryKeyName();
        boolean contain = StatementParser.containKey(fields, idName);
        ret[4] = new Integer(0);
        ret[5] = StatementParser.parseField(fields);
        if (contain) {
            String s_temp = values.trim();
            s_temp = s_temp.substring(1, s_temp.length() - 1);
            String keyValue = StatementParser.getKeyValue(s_temp);
            ret[0] = insertStmt;
            ret[1] = keyValue;
            PrimaryKey t_p = new PrimaryKey(primaryKey.getDbname(), primaryKey.getTableName(), primaryKey.getPrimaryKeyName(), keyValue, con);
            ret[3] = t_p;
            ret[4] = new Integer(1);
            return ret;
        }
        StringBuilder temp = new StringBuilder(fields);
        temp.insert(1, idName + ",");
        fields = temp.toString();
        temp = new StringBuilder(values);
        Sequence idValue = primaryKey.generateObjectKey(con);
        temp.insert(1, PrimaryKey.changeID(idValue.getPrimaryKey(), dbname, primaryKey.getType()) + ",");
        values = temp.toString();
        temp = new StringBuilder(insert);
        temp.append(" ").append(into).append(" ").append(tableName).append(fields).append(" ").append(values_key).append(values);
        ret[0] = temp.toString();
        ret[1] = idValue.getPrimaryKey();
        ArrayList<Object> datas = new ArrayList<Object>();
        datas.add(new Long(idValue.getSequence()));
        datas.add(tableName.toLowerCase());
        datas.add(new Long(idValue.getSequence()));
        UpdateSQL preparedUpdate = new UpdateSQL(dbname, tableName, "update tableinfo set table_id_value=? where LOWER(table_name)=? and table_id_value <?", datas);
        ret[2] = preparedUpdate;
        ret[3] = primaryKey;
        return ret;
    }

    private static String getKeyValue(String values) {
        String regx = "";
        return "";
    }

    private static boolean containKey(String fields, String idName) {
        String temp = fields.trim();
        temp = temp.substring(1, temp.length() - 1);
        String[] field = SimpleStringUtil.split((String)temp, (String)",");
        for (int i = 0; field != null && i < field.length; ++i) {
            if (!field[i].trim().equalsIgnoreCase(idName.trim())) continue;
            return true;
        }
        return false;
    }

    class ParserValues {
        Stack operations = new Stack();

        ParserValues() {
        }
    }
}

