/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.listener;

import com.frameworkset.orm.transaction.TransactionManager;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSServletRequestListener
implements ServletRequestListener {
    private static final Logger log = LoggerFactory.getLogger(BSServletRequestListener.class);
    private static final ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        if (requestEvent.getServletRequest() instanceof HttpServletRequest) {
            requestThreadLocal.set(null);
            HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
            boolean state = TransactionManager.destroyTransaction();
            if (state && log.isWarnEnabled()) {
                String uri = request.getRequestURI();
                log.warn("A DB transaction leaked in Page [{}] has been forcibly destoried. ", (Object)uri);
            }
        }
    }

    public static HttpServletRequest getHttpServletRequest() {
        return requestThreadLocal.get();
    }

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (requestEvent.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
            requestThreadLocal.set(request);
            boolean state = TransactionManager.destroyTransaction();
            if (state && log.isWarnEnabled()) {
                String uri = request.getRequestURI();
                log.warn("A DB transaction leaked before Page [{}] has been forcibly destoried. ", (Object)uri);
            }
        }
    }

    public static void requestReset(HttpServletRequest request) {
        if (request != null && BSServletRequestListener.getHttpServletRequest() != null) {
            requestThreadLocal.set(request);
            if (log.isDebugEnabled()) {
                log.debug("reset request[{}] completed.", (Object)request.getClass().getCanonicalName());
            }
        }
    }
}

