/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.adapter;

import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.util.DBOptions;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.platform.PlatformPostgresqlImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBPostgres
extends DB {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DBPostgres() {
        this.platform = new PlatformPostgresqlImpl();
    }

    @Override
    public String toUpperCase(String in) {
        String s = "UPPER(" + in + ")";
        return s;
    }

    @Override
    public String ignoreCase(String in) {
        String s = "UPPER(" + in + ")";
        return s;
    }

    @Override
    public String getIDMethodType() {
        return "sequence";
    }

    @Override
    public String getIDMethodSQL(Object name) {
        return "select nextval('" + name + "')";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
    }

    @Override
    public boolean supportsNativeLimit() {
        return true;
    }

    @Override
    public boolean supportsNativeOffset() {
        return true;
    }

    @Override
    public int getLimitStyle() {
        return 1;
    }

    @Override
    public String getBooleanString(Boolean b) {
        return b == null ? "FALSE" : (Boolean.TRUE.equals(b) ? "TRUE" : "FALSE");
    }

    @Override
    public String getDateString(Date date) {
        StringBuilder dateBuf = new StringBuilder();
        char delim = this.getStringDelimiter();
        dateBuf.append(delim);
        dateBuf.append(this.sdf.format(date));
        dateBuf.append(delim);
        return dateBuf.toString();
    }

    @Override
    public DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared) {
        StringBuilder newsql = null;
        newsql = prepared ? new StringBuilder().append(sql).append(" limit ?,?") : new StringBuilder().append(sql).append(" limit ").append(offset).append(",").append(maxsize);
        return new DB.PagineSql(newsql.toString(), offset, maxsize, offset, maxsize, prepared).setRebuilded(true);
    }

    @Override
    public String getStringPagineSql(String sql) {
        StringBuilder newsql = new StringBuilder().append(sql).append(" limit ?,?");
        return newsql.toString();
    }

    @Override
    public String getStringPagineSql(String schema, String tablename, String pkname, String columns) {
        StringBuilder sqlbuilder = new StringBuilder();
        sqlbuilder.append("SELECT ");
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(columns);
        } else {
            sqlbuilder.append("* ");
        }
        sqlbuilder.append(" from   ");
        if (schema != null && !schema.equals("")) {
            sqlbuilder.append(schema).append(".");
        }
        sqlbuilder.append(tablename);
        sqlbuilder.append(" limit ?,?");
        return sqlbuilder.toString();
    }

    @Override
    public DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared, String orderBy) {
        StringBuilder newsql = null;
        newsql = prepared ? new StringBuilder().append(sql).append(" ").append(orderBy).append(" limit ?,?") : new StringBuilder().append(sql).append(" ").append(orderBy).append(" limit ").append(offset).append(",").append(maxsize);
        return new DB.PagineSql(newsql.toString(), offset, maxsize, offset, maxsize, prepared).setRebuilded(true);
    }

    @Override
    public String getStringPagineSql(String sql, String orderBy) {
        StringBuilder newsql = new StringBuilder().append(sql).append(" ").append(orderBy).append(" limit ?,?");
        return newsql.toString();
    }

    @Override
    public String getStringPagineSql(String schema, String tablename, String pkname, String columns, String orderBy) {
        StringBuilder sqlbuilder = new StringBuilder();
        sqlbuilder.append("SELECT ");
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(columns);
        } else {
            sqlbuilder.append("* ");
        }
        sqlbuilder.append(" from   ");
        if (schema != null && !schema.equals("")) {
            sqlbuilder.append(schema).append(".");
        }
        sqlbuilder.append(tablename);
        sqlbuilder.append(" ").append(orderBy).append(" limit ?,?");
        return sqlbuilder.toString();
    }

    @Override
    public void handleConnection(Integer fetchSize, Connection con) throws SQLException {
        if (fetchSize != null && fetchSize > 0 && con.getAutoCommit()) {
            con.setAutoCommit(false);
        }
    }

    @Override
    public void recoverConnection(Integer fetchSize, Connection con, boolean oldautocommit) throws SQLException {
        if (fetchSize != null && fetchSize > 0) {
            con.setAutoCommit(oldautocommit);
        }
    }

    @Override
    public void setObject(PreparedStatement statement, PreparedStatement statement_count, int parameterIndex, Object x) throws SQLException {
        if (x != null) {
            if (x instanceof Date) {
                Timestamp timestamp = new Timestamp(((Date)x).getTime());
                statement.setTimestamp(parameterIndex, timestamp);
                if (statement_count != null) {
                    statement_count.setTimestamp(parameterIndex, timestamp);
                }
            } else if (x instanceof java.sql.Date) {
                statement.setDate(parameterIndex, (java.sql.Date)x);
                if (statement_count != null) {
                    statement_count.setDate(parameterIndex, (java.sql.Date)x);
                }
            } else if (x instanceof Timestamp) {
                statement.setTimestamp(parameterIndex, (Timestamp)x);
                if (statement_count != null) {
                    statement_count.setTimestamp(parameterIndex, (Timestamp)x);
                }
            } else if (x instanceof Short) {
                statement.setShort(parameterIndex, (Short)x);
                if (statement_count != null) {
                    statement_count.setShort(parameterIndex, (Short)x);
                }
            } else if (x instanceof Double) {
                statement.setDouble(parameterIndex, (Double)x);
                if (statement_count != null) {
                    statement_count.setDouble(parameterIndex, (Double)x);
                }
            } else if (x instanceof Float) {
                statement.setFloat(parameterIndex, ((Float)x).floatValue());
                if (statement_count != null) {
                    statement_count.setFloat(parameterIndex, ((Float)x).floatValue());
                }
            } else {
                statement.setObject(parameterIndex, x);
                if (statement_count != null) {
                    statement_count.setObject(parameterIndex, x);
                }
            }
        } else {
            statement.setNull(parameterIndex, 0);
            if (statement_count != null) {
                statement_count.setNull(parameterIndex, 0);
            }
        }
    }

    @Override
    public void setObject(PreparedDBUtil dbutil, int parameterIndex, Object x) throws SQLException {
        if (x != null) {
            if (x instanceof String) {
                dbutil.setString(parameterIndex, (String)x);
            } else if (x instanceof Date) {
                Timestamp timestamp = new Timestamp(((Date)x).getTime());
                dbutil.setTimestamp(parameterIndex, timestamp);
            } else if (x instanceof java.sql.Date) {
                dbutil.setDate(parameterIndex, (java.sql.Date)x);
            } else if (x instanceof Timestamp) {
                dbutil.setTimestamp(parameterIndex, (Timestamp)x);
            } else if (x instanceof Short) {
                dbutil.setShort(parameterIndex, (Short)x);
            } else if (x instanceof Double) {
                dbutil.setDouble(parameterIndex, (Double)x);
            } else if (x instanceof Float) {
                dbutil.setFloat(parameterIndex, ((Float)x).floatValue());
            } else {
                dbutil._setObject(parameterIndex, x);
            }
        } else {
            dbutil.setNull(parameterIndex, 0);
        }
    }

    @Override
    public Integer getFetchSize(DBOptions dbOptions, JDBCPoolMetaData jdbcPoolMetaData) {
        Integer fetchsize = null;
        if (dbOptions != null && dbOptions.getFetchSize() != null && dbOptions.getFetchSize() != 0) {
            fetchsize = dbOptions.getFetchSize();
        }
        return fetchsize;
    }

    @Override
    public String getSchemaTableTableName(JDBCPoolMetaData info, String tablename) {
        return tablename;
    }

    @Override
    public String getSchema(JDBCPoolMetaData info, Connection con) {
        if (con == null) {
            return "NULL_SCHEMA";
        }
        try {
            return con.getSchema();
        }
        catch (SQLException e) {
            return "NULL_SCHEMA";
        }
    }
}

