/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.datasource;

import com.frameworkset.common.poolman.util.DatasourceUtil;
import com.frameworkset.commons.dbcp.BasicDataSourceFactory;
import com.frameworkset.orm.adapter.DB;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BalanceDatasource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(BalanceDatasource.class);
    protected Map<String, DataSource> balanceDatasources = new LinkedHashMap<String, DataSource>();
    protected String url;
    protected DB db;
    protected DataSource currentDatasource;
    protected Properties properties;
    protected boolean balance = false;
    protected List<String> nodes;
    private boolean closed;
    private Object closeLock = new Object();

    public BalanceDatasource(String url, DB db, Properties properties) {
        this.url = url;
        this.db = db;
        this.properties = properties;
    }

    protected abstract void buildAddress() throws Exception;

    public void init() throws Exception {
        List<String> nodes = this.db.getBalanceUrls(this.url);
        this.nodes = nodes;
        if (nodes == null || nodes.size() == 1) {
            DataSource currentDatasource;
            this.currentDatasource = currentDatasource = BasicDataSourceFactory.createDBCP2DataSource(this.url, this.properties);
        } else {
            this.balance = true;
            this.buildAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        Iterator<String> iterator = this.closeLock;
        synchronized (iterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.balanceDatasources.size() > 0) {
            for (String node : this.nodes) {
                DataSource dataSource = this.balanceDatasources.remove(node);
                if (dataSource == null) continue;
                DatasourceUtil.closeDS(dataSource);
            }
        }
    }

    protected abstract String getAnyUrl() throws SQLException;

    private DataSource switchBalanceDatasource() throws SQLException {
        if (!this.balance) {
            return this.currentDatasource;
        }
        String node = this.getAnyUrl();
        if (logger.isDebugEnabled()) {
            logger.debug("SwitchBalanceDatasource to {}", (Object)node);
        }
        return this.balanceDatasources.get(node);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.switchBalanceDatasource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.switchBalanceDatasource().getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.switchBalanceDatasource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.switchBalanceDatasource().isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.switchBalanceDatasource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.switchBalanceDatasource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.switchBalanceDatasource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.switchBalanceDatasource().getLoginTimeout();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            return this.switchBalanceDatasource().getParentLogger();
        }
        catch (SQLException e) {
            throw new SQLFeatureNotSupportedException(e);
        }
    }
}

