/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.adapter;

import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.ValueExchange;
import com.frameworkset.common.poolman.util.DBOptions;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.orm.adapter.IDMethod;
import com.frameworkset.orm.engine.model.Domain;
import com.frameworkset.orm.engine.model.SchemaType;
import com.frameworkset.orm.platform.Platform;
import com.frameworkset.orm.platform.PlatformDefaultImpl;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.annotations.DateFormateMeta;

public abstract class DB
implements IDMethod,
Platform {
    public static final String NULL_SCHEMA = "NULL_SCHEMA";
    public static final int LIMIT_STYLE_NONE = 0;
    public static final int LIMIT_STYLE_POSTGRES = 1;
    public static final int LIMIT_STYLE_MYSQL = 2;
    public static final int LIMIT_STYLE_SYBASE = 3;
    public static final int LIMIT_STYLE_ORACLE = 4;
    public static final int LIMIT_STYLE_DB2 = 5;
    private static String java_date_format = "yyyy-MM-dd HH:mm:ss";
    protected String date_format = "yyyy-MM-dd HH:mm:ss";
    protected String FORMART_YEAR = "yyyy";
    protected String FORMART_MONTH = "MM";
    protected String FORMART_DAY = "dd";
    protected String FORMART_HOUR = "HH";
    protected String FORMART_MINUTE = "mm";
    protected String FORMART_SECOND = "ss";
    protected String FORMART_ALL = "yyyy-MM-dd HH:mm:ss";
    protected String FORMART_YEAR_MM_DD = "yyyy-MM-dd";
    protected String FORMART_HH_MM_SS = "HH:mm:ss";
    protected Platform platform = new PlatformDefaultImpl();
    protected String dbtype = null;

    protected DB() {
    }

    public static int countZHWord(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            ++count;
        }
        return count / 3;
    }

    public boolean columnLableUpperCase(JDBCPoolMetaData jdbcPoolMetaData) {
        return jdbcPoolMetaData.isColumnLableUpperCase();
    }

    public abstract String toUpperCase(String var1);

    public char getStringDelimiter() {
        return '\'';
    }

    public boolean isWritebable(ResultSetMetaData other, int idx) throws SQLException {
        return other.isWritable(idx);
    }

    public String sysdate() {
        return "sysdate";
    }

    public long getNextValue(String sequence, Connection con, String dbname) throws SQLException {
        long curValue = 0L;
        PreparedDBUtil dbutil = new PreparedDBUtil();
        String sql = "select " + sequence + ".nextval from dual";
        dbutil.preparedSelect(dbname, sql);
        dbutil.executePrepared(con);
        if (dbutil.size() <= 0) {
            throw new SQLException("[select " + sequence + ".nextval from dual] from [" + dbname + "] failed:retrun records is 0.");
        }
        curValue = dbutil.getInt(0, 0);
        return curValue;
    }

    public long getNextValue(String seqfunctionname, String sequence, Connection con, String dbname) throws SQLException {
        long curValue = 0L;
        PreparedDBUtil dbutil = new PreparedDBUtil();
        String sql = "select " + sequence + ".nextval from dual";
        dbutil.preparedSelect(dbname, sql);
        dbutil.executePrepared(con);
        if (dbutil.size() <= 0) {
            throw new SQLException("[select " + sequence + ".nextval from dual] from [" + dbname + "] failed:retrun records is 0.");
        }
        curValue = dbutil.getInt(0, 0);
        return curValue;
    }

    public abstract String getIDMethodType();

    public abstract String getIDMethodSQL(Object var1);

    public abstract void lockTable(Connection var1, String var2) throws SQLException;

    public abstract void unlockTable(Connection var1, String var2) throws SQLException;

    public abstract String ignoreCase(String var1);

    public String ignoreCaseInOrderBy(String in) {
        return this.ignoreCase(in);
    }

    public boolean supportsNativeLimit() {
        return false;
    }

    public boolean supportsNativeOffset() {
        return false;
    }

    public boolean escapeText() {
        return true;
    }

    public int getLimitStyle() {
        return 0;
    }

    public String to_date(java.util.Date date) {
        Timestamp ts = null;
        ts = date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime());
        return "{ts '" + ts + "'}";
    }

    public String filedToDateFunction(String date) {
        return "{ts '" + date + "'}";
    }

    public String filedToDateFunction(String date, String format) {
        return "{ts '" + date + "'}";
    }

    public String to_date(String date) {
        return "{ts '" + date + "'}";
    }

    public String to_date(String date, String format) {
        return "{ts '" + date + "'}";
    }

    public String to_date(java.util.Date date, String format) {
        Timestamp ts = null;
        ts = date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime());
        return "{ts '" + ts + "'}";
    }

    public String getDateString(java.util.Date date) {
        return this.to_date(date);
    }

    public String getDateString(String date) {
        return this.to_date(date);
    }

    public String getDateString(java.util.Date date, String format) {
        return this.to_date(date, format);
    }

    public String getDateString(String date, String format) {
        return this.to_date(date, format);
    }

    public String getBooleanString(Boolean b) {
        return Boolean.TRUE.equals(b) ? "1" : "0";
    }

    public String getLimitSelect(String selectSql, int limit) {
        selectSql = selectSql + " LIMIT " + limit;
        return selectSql;
    }

    public Object getCharValue(ResultSet res, int i, String value) {
        return value;
    }

    public Object getCharValue(CallableStatement cstmt, int i, String value) {
        return value;
    }

    public Object getCharValue(CallableStatement cstmt, String paramName, String value) {
        return value;
    }

    public String getOROPR() {
        return "|";
    }

    public String getSchema(JDBCPoolMetaData info, Connection con) throws SQLException {
        return con.getSchema();
    }

    public String getDBCatalog(Connection con) throws SQLException {
        return this._getDBCatalog(con);
    }

    public String _getDBCatalog(Connection con) throws SQLException {
        return con.getCatalog();
    }

    public String getSchemaTableTableName(JDBCPoolMetaData info, String tablename) {
        if (tablename == null) {
            return null;
        }
        return tablename.toUpperCase();
    }

    public String getIDMAXSql(String tableName, String table_id_name, String table_id_prefix, String type) {
        String maxSql = "select max(" + table_id_name + ") from " + tableName;
        return maxSql;
    }

    @Override
    public String getNativeIdMethod() {
        return this.platform.getNativeIdMethod();
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.platform.getMaxColumnNameLength();
    }

    @Override
    public Domain getDomainForSchemaType(SchemaType jdbcType) {
        return this.platform.getDomainForSchemaType(jdbcType);
    }

    @Override
    public Domain getDomainForSchemaType(int jdbcType, String datatypeName) {
        return this.platform.getDomainForSchemaType(jdbcType, datatypeName);
    }

    @Override
    public String getNullString(boolean notNull) {
        return this.platform.getNullString(notNull);
    }

    @Override
    public String getAutoIncrement() {
        return this.platform.getAutoIncrement();
    }

    @Override
    public boolean hasSize(String sqlType) {
        return this.platform.hasSize(sqlType);
    }

    @Override
    public boolean hasScale(String sqlType) {
        return this.platform.hasScale(sqlType);
    }

    @Override
    public boolean hasSize(int sqlType) {
        return this.platform.hasSize(sqlType);
    }

    @Override
    public boolean hasScale(int sqlType) {
        return this.platform.hasScale(sqlType);
    }

    @Override
    public String getDBTYPE() {
        return this.dbtype;
    }

    public PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared) {
        return new PagineSql(sql, -1L, -1L, offset, maxsize, prepared);
    }

    public void resetPostion(PreparedStatement statement, int startidx, int endidx, long offset, int maxsize) throws SQLException {
    }

    public String getOracleLimitSelect(String selectSql, int limit, String rownum) {
        StringBuilder ret = new StringBuilder();
        ret.append("select * from (").append(selectSql).append(") where ").append(rownum).append(" <=").append(limit);
        return ret.toString();
    }

    public PagineSql getOracleDBPagineSql(String sql, long offset, int maxsize, String rownum, boolean prepared) {
        StringBuilder ret = null;
        ret = prepared ? new StringBuilder().append("select * from (").append(sql).append(") where ").append(rownum).append(" between ? and ?") : new StringBuilder("select * from (").append(sql).append(") where ").append(rownum).append(" between ").append(offset + 1L + "").append(" and ").append(offset + (long)maxsize + "");
        return new PagineSql(ret.toString(), offset + 1L, offset + (long)maxsize, offset, maxsize, prepared);
    }

    public String getTableRemarks(Connection con, String tableName, String tableRemark) {
        return tableRemark;
    }

    public String getColumnRemarks(Connection con, String tableName, String columnName, String remarks_c) {
        return remarks_c;
    }

    @Override
    public SchemaType getSchemaTypeFromSqlType(int sqltype, String typeName) {
        return this.platform.getSchemaTypeFromSqlType(sqltype, typeName);
    }

    public int getSCROLLType(String dbdriver) {
        return 1003;
    }

    public int getCusorType(String dbdriver) {
        return 1007;
    }

    public String getDateFormat() {
        return this.date_format;
    }

    public String getJavaDateFormat() {
        return java_date_format;
    }

    public String to_char(String date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(SimpleStringUtil.stringToDate((String)date, (String)format));
    }

    public String to_char(String date) {
        return this.to_char(date, this.FORMART_ALL);
    }

    public Date getDate(String date, DateFormateMeta dateFormateMeta) throws ParseException {
        String format = null;
        DateFormat f = null;
        if (dateFormateMeta == null) {
            format = this.getJavaDateFormat();
            dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)format);
        }
        f = dateFormateMeta.toDateFormat();
        java.util.Date _date = f.parse(date);
        Date ret = new Date(_date.getTime());
        return ret;
    }

    public Timestamp getTimestamp(String timestamp, DateFormateMeta dateFormateMeta) throws ParseException {
        String format = null;
        DateFormat f = null;
        if (dateFormateMeta == null) {
            format = this.getJavaDateFormat();
            dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)format);
        }
        f = dateFormateMeta.toDateFormat();
        java.util.Date date = f.parse(timestamp);
        Timestamp timestamp_ = new Timestamp(date.getTime());
        return timestamp_;
    }

    public Object getLONGVARBINARY(CallableStatement cstmt, int parameterIndex) throws SQLException {
        return cstmt.getObject(parameterIndex);
    }

    public Object getLONGVARCHAR(CallableStatement cstmt, int parameterIndex) throws SQLException {
        return cstmt.getObject(parameterIndex);
    }

    public Object getLONGVARCHAR(ResultSet res, int parameterIndex) throws SQLException {
        return res.getObject(parameterIndex);
    }

    public Object getLONGVARCHAR(ResultSet res, String colName) throws SQLException {
        return res.getObject(colName);
    }

    public Object getLONGVARBINARY(ResultSet res, int parameterIndex) throws SQLException {
        return res.getObject(parameterIndex);
    }

    public Object getLONGVARBINARY(ResultSet res, String colName) throws SQLException {
        return res.getObject(colName);
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getFORMART_DAY() {
        return this.FORMART_DAY;
    }

    public void setFORMART_DAY(String fORMARTDAY) {
        this.FORMART_DAY = fORMARTDAY;
    }

    public String getFORMART_YEAR() {
        return this.FORMART_YEAR;
    }

    public String getFORMART_MONTH() {
        return this.FORMART_MONTH;
    }

    public String getFORMART_HOUR() {
        return this.FORMART_HOUR;
    }

    public String getFORMART_MINUTE() {
        return this.FORMART_MINUTE;
    }

    public String getFORMART_SECOND() {
        return this.FORMART_SECOND;
    }

    public String getFORMART_ALL() {
        return this.FORMART_ALL;
    }

    public String getFORMART_HH_MM_SS() {
        return this.FORMART_HH_MM_SS;
    }

    public String getFORMART_YEAR_MM_DD() {
        return this.FORMART_YEAR_MM_DD;
    }

    public String concat(String ... concatString) {
        if (concatString == null || concatString.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        boolean i = false;
        for (String token : concatString) {
            if (!i) {
                ret.append(token);
                i = true;
                continue;
            }
            ret.append(" || ").append(token);
        }
        return ret.toString();
    }

    public String disableFK(String table, String FKName) {
        StringBuilder ret = new StringBuilder();
        ret.append("alter table ").append(table).append(" disable constraint ").append(FKName);
        return ret.toString();
    }

    public String enableFK(String table, String FKName, String column, String FKTable, String FKColumn) {
        StringBuilder ret = new StringBuilder();
        ret.append("alter table ").append(table).append(" enable constraint ").append(FKName);
        return ret.toString();
    }

    public void updateClob(Object content, Connection conn, String table, String clobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
    }

    public void updateBlob(InputStream instream, Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
    }

    public void updateBlob(byte[] value, Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
    }

    public void updateBLOB(Blob blob, File file) throws SQLException {
    }

    public void updateBLOB(Blob blob, InputStream instream) throws SQLException {
    }

    public void updateCLOB(Clob clob, Object content) throws SQLException {
    }

    public byte[] getBytesFromResultset(ResultSet res, String columnName) throws SQLException {
        return res.getBytes(columnName);
    }

    public byte[] getBytesFromBlob(Blob blob) throws SQLException {
        byte[] content = new byte[(int)blob.length()];
        content = blob.getBytes(1L, (int)blob.length());
        return content;
    }

    public byte[] getBytesFromClob(Clob clob) {
        try {
            return ValueExchange.getByteArrayFromClob(clob);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getStringFromClob(Clob clob) {
        try {
            return ValueExchange.getStringFromClob(clob);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean neadGetGenerateKeys() {
        return false;
    }

    public String getStringPagineSql(String sql) {
        return sql;
    }

    public void queryByNullRowHandler(NullRowHandler handler, String dbname, String pageinestatement, long offset, int pagesize) throws SQLException {
        SQLExecutor.queryWithDBNameByNullRowHandler(handler, dbname, pageinestatement, offset + (long)pagesize, offset + 1L);
    }

    public String getStringPagineSql(String schema, String tablename, String pkname, String columns) {
        StringBuilder sqlbuilder = new StringBuilder();
        sqlbuilder.append("select * from (SELECT ");
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(columns);
        } else {
            sqlbuilder.append("t.* ");
        }
        sqlbuilder.append(",ROW_NUMBER() OVER ( ORDER BY ").append(pkname).append(") rownum__  from   ");
        if (schema != null && !schema.equals("")) {
            sqlbuilder.append(schema).append(".");
        }
        sqlbuilder.append(tablename);
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(" ) bb where bb.rownum__ <=? and bb.rownum__ >=?");
        } else {
            sqlbuilder.append(" t) bb where bb.rownum__ <=? and bb.rownum__ >=?");
        }
        return sqlbuilder.toString();
    }

    public void setObject(PreparedDBUtil dbutil, int i, Object o) throws SQLException {
        dbutil._setObject(i, o);
    }

    public PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared, String orderby) {
        return new PagineSql(sql, -1L, -1L, offset, maxsize, prepared);
    }

    public String getStringPagineSql(String sql, String orderby) {
        return sql;
    }

    public String getStringPagineSql(String schema, String tablename, String pkname, String columns, String orderby) {
        StringBuilder newsql = new StringBuilder();
        newsql.append("SELECT ");
        if (columns != null && !columns.equals("")) {
            newsql.append(columns);
        } else {
            newsql.append("* ");
        }
        newsql.append(" from   ");
        if (schema != null && !schema.equals("")) {
            newsql.append(schema).append(".");
        }
        newsql.append(tablename);
        return newsql.toString();
    }

    public boolean isSearchable(ResultSetMetaData other, int i) throws SQLException {
        return other.isSearchable(i);
    }

    public boolean isSigned(ResultSetMetaData other, int rc) throws SQLException {
        return other.isSigned(rc);
    }

    public boolean isDefinitelyWritable(ResultSetMetaData other, int rc) throws SQLException {
        return other.isDefinitelyWritable(rc);
    }

    public void setObject(PreparedStatement statement, PreparedStatement statement_count, int parameterIndex, Object x) throws SQLException {
        statement.setObject(parameterIndex, x);
        if (statement_count != null) {
            statement_count.setObject(parameterIndex, x);
        }
    }

    public boolean isOracleTimestamp(int sqlType) {
        return false;
    }

    public void handleConnection(Integer fetchSize, Connection con) throws SQLException {
    }

    public void recoverConnection(Integer fetchSize, Connection con, boolean oldautocommit) throws SQLException {
    }

    public void putFetchsize(PreparedStatement pstmt, Integer fetchSize) throws SQLException {
        if (fetchSize != null && fetchSize > 0) {
            pstmt.setFetchSize(fetchSize);
        }
    }

    public Integer getFetchSize(DBOptions dbOptions, JDBCPoolMetaData jdbcPoolMetaData) {
        Integer fetchsize = null;
        fetchsize = dbOptions != null && dbOptions.getFetchSize() != null && dbOptions.getFetchSize() != 0 ? dbOptions.getFetchSize() : jdbcPoolMetaData.getQueryfetchsize();
        return fetchsize;
    }

    public void setRowId(Record record, ResultSet rs) throws SQLException {
        record.setRowid(rs.getRow());
    }

    public Statement createStatement(Connection con, int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = con.createStatement(resultSetType, resultSetConcurrency);
        return stmt;
    }

    public List<String> getBalanceUrls(String url) throws SQLException {
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(url);
        return nodes;
    }

    public Map<String, Object> getUrlParams(String url) throws SQLException {
        return null;
    }

    public static class PagineSql {
        private long offset;
        private int maxsize;
        private String sql;
        private long start = -1L;
        private long end = -1L;
        private boolean prepared = true;
        private boolean rebuilded = false;

        public PagineSql(String sql, long start, long end, long offset, int maxsize, boolean prepared) {
            this.sql = sql;
            this.start = start;
            this.end = end;
            this.offset = offset;
            this.maxsize = maxsize;
            this.prepared = prepared;
        }

        public PagineSql(String sql, boolean prepared) {
            this.sql = sql;
            this.prepared = prepared;
        }

        public boolean isRebuilded() {
            return this.rebuilded;
        }

        public PagineSql setRebuilded(boolean rebuilded) {
            this.rebuilded = rebuilded;
            return this;
        }

        public String getSql() {
            return this.sql;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getMaxsize() {
            return this.maxsize;
        }

        public boolean isPrepared() {
            return this.prepared;
        }
    }
}

