/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.datasource;

import com.frameworkset.commons.dbcp.BasicDataSourceFactory;
import com.frameworkset.orm.adapter.DB;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.frameworkset.balance.RoundRobinList;
import org.frameworkset.persitent.datasource.BalanceDatasource;
import org.frameworkset.persitent.datasource.DBNode;

public class RoundbinBalanceDatasource
extends BalanceDatasource {
    private RoundRobinList<DBNode> roundRobinList;

    public RoundbinBalanceDatasource(String url, DB db, Properties properties) {
        super(url, db, properties);
    }

    @Override
    protected void buildAddress() throws Exception {
        ArrayList<DBNode> dbNodes = new ArrayList<DBNode>(this.nodes.size());
        DataSource currentDatasource = null;
        for (String node : this.nodes) {
            dbNodes.add(new DBNode(node));
            currentDatasource = BasicDataSourceFactory.createDBCP2DataSource(node, this.properties);
            this.balanceDatasources.put(node, currentDatasource);
            if (this.currentDatasource != null) continue;
            this.currentDatasource = currentDatasource;
        }
        this.roundRobinList = new RoundRobinList(dbNodes);
    }

    @Override
    protected String getAnyUrl() throws SQLException {
        DBNode dbNode = (DBNode)this.roundRobinList.get(true);
        return dbNode.getNode();
    }
}

