/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.http;

import com.frameworkset.util.StringUtil;
import java.nio.charset.Charset;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.frameworkset.http.HttpHeaders;
import org.frameworkset.http.MediaType;
import org.frameworkset.util.LinkedCaseInsensitiveMap;

public class RequestHeaderUtil {
    public static HttpHeaders getHeaders(HttpServletRequest servletRequest) {
        int requestContentLength;
        String requestEncoding;
        String requestContentType;
        HttpHeaders headers = (HttpHeaders)servletRequest.getAttribute("org_frameworkset_http_HttpHeaders__");
        if (headers != null) {
            return headers;
        }
        headers = new HttpHeaders();
        Enumeration headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = servletRequest.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                headers.add(headerName, headerValue);
            }
        }
        MediaType contentType = headers.getContentType();
        if (contentType == null && StringUtil.hasLength(requestContentType = servletRequest.getContentType())) {
            contentType = MediaType.parseMediaType(requestContentType);
            headers.setContentType(contentType);
        }
        if (contentType != null && contentType.getCharSet() == null && StringUtil.hasLength(requestEncoding = servletRequest.getCharacterEncoding())) {
            Charset charSet = Charset.forName(requestEncoding);
            LinkedCaseInsensitiveMap<String> params = new LinkedCaseInsensitiveMap<String>();
            params.putAll(contentType.getParameters());
            params.put("charset", charSet.toString());
            MediaType newContentType = new MediaType(contentType.getType(), contentType.getSubtype(), params);
            headers.setContentType(newContentType);
        }
        if (headers.getContentLength() == -1L && (requestContentLength = servletRequest.getContentLength()) != -1) {
            headers.setContentLength(requestContentLength);
        }
        servletRequest.setAttribute("org_frameworkset_http_HttpHeaders__", (Object)headers);
        return headers;
    }
}

