/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.io;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.frameworkset.util.Assert;
import org.frameworkset.util.ResourceUtils;
import org.frameworkset.util.io.AbstractResource;
import org.frameworkset.util.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlResource
extends AbstractResource {
    private static Logger log = LoggerFactory.getLogger(UrlResource.class);
    private URLConnection con;
    private long totalsize;
    private String filename;
    private final URL url;
    private final URL cleanedUrl;
    private final URI uri;

    public UrlResource(URL url) {
        Assert.notNull(url, "URL must not be null");
        this.url = url;
        this.cleanedUrl = this.getCleanedUrl(this.url, url.toString());
        this.uri = null;
    }

    public UrlResource(URI uri) throws MalformedURLException {
        Assert.notNull(uri, "URI must not be null");
        this.url = uri.toURL();
        this.cleanedUrl = this.getCleanedUrl(this.url, uri.toString());
        this.uri = uri;
    }

    public UrlResource(String path) throws MalformedURLException {
        Assert.notNull(path, "Path must not be null");
        this.url = new URL(path);
        this.cleanedUrl = this.getCleanedUrl(this.url, path);
        this.uri = null;
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(SimpleStringUtil.cleanPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    public void open() throws IOException {
        this.open(false);
    }

    public void open(boolean reopen) throws IOException {
        if (this.con == null || reopen) {
            this.con = this.url.openConnection();
            this.con.setUseCaches(false);
            String Content_Disposition = this.con.getHeaderField("Content-Disposition");
            if (Content_Disposition != null && Content_Disposition.startsWith("attachment;")) {
                String[] ps;
                for (String p : ps = Content_Disposition.split(";")) {
                    if (!(p = p.trim()).startsWith("filename=")) continue;
                    this.filename = p.substring("filename=".length());
                    if (this.filename.startsWith("\"")) {
                        this.filename = this.filename.substring(1);
                    }
                    if (!this.filename.endsWith("\"")) continue;
                    this.filename = this.filename.substring(0, this.filename.length() - 1);
                }
            }
            this.totalsize = this.getHeaderFieldLong("content-length", -1L);
        }
    }

    public long getHeaderFieldLong(String name, long Default) {
        String value = this.con.getHeaderField(name);
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return Default;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.open(true);
        return this.con.getInputStream();
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    @Override
    public File getFile() throws IOException {
        if (this.uri != null) {
            return ResourceUtils.getFile(this.uri, this.getDescription());
        }
        return ResourceUtils.getFile(this.url, this.getDescription());
    }

    @Override
    protected File getFileForLastModifiedCheck() throws IOException {
        if (ResourceUtils.isJarURL(this.url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(this.url);
            return ResourceUtils.getFile(actualUrl);
        }
        return this.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return new UrlResource(new URL(this.url, relativePath));
    }

    @Override
    public String getFilename() {
        if (this.filename != null) {
            return this.filename;
        }
        try {
            this.open();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            this.filename = SimpleStringUtil.getFilename(this.url.getFile());
            return this.filename;
        }
        this.filename = SimpleStringUtil.getFilename(this.url.getFile());
        return this.filename;
    }

    @Override
    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof UrlResource && this.cleanedUrl.equals(((UrlResource)obj).cleanedUrl);
    }

    @Override
    public int hashCode() {
        return this.cleanedUrl.hashCode();
    }

    @Override
    public void release() {
        this.con = null;
        this.filename = null;
        this.totalsize = 0L;
    }

    @Override
    public long contentLength() throws IOException {
        if (this.con != null) {
            return this.totalsize;
        }
        return super.contentLength();
    }

    public long getTotalsize() {
        return this.totalsize;
    }
}

