/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import com.frameworkset.util.BeanUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.frameworkset.json.JacksonObjectMapper;
import org.frameworkset.json.JsonTypeReference;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2ObjectMapper
implements JacksonObjectMapper {
    private static final Logger logger = LoggerFactory.getLogger(Jackson2ObjectMapper.class);
    static ClassLoader moduleClassLoader = Jackson2ObjectMapper.class.getClassLoader();
    protected ObjectMapper mapper = new ObjectMapper();
    protected ObjectMapper ALLOW_SINGLE_QUOTES_mapper = null;
    protected ObjectMapper NOT_ALLOW_SINGLE_QUOTES_mapper = null;
    private String dateFormat;
    private String locale;
    private String timeZone;
    private boolean disableTimestamp = false;
    boolean failedOnUnknownProperties = false;

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public boolean isDisableTimestamp() {
        return this.disableTimestamp;
    }

    @Override
    public void setDisableTimestamp(boolean disableTimestamp) {
        this.disableTimestamp = disableTimestamp;
    }

    public boolean isFailedOnUnknownProperties() {
        return this.failedOnUnknownProperties;
    }

    @Override
    public void setFailedOnUnknownProperties(boolean failedOnUnknownProperties) {
        this.failedOnUnknownProperties = failedOnUnknownProperties;
    }

    public Jackson2ObjectMapper() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Jackson2ObjectMapper.registerWellKnownModulesIfAvailable(this.mapper);
        this.ALLOW_SINGLE_QUOTES_mapper = new ObjectMapper();
        this.ALLOW_SINGLE_QUOTES_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.ALLOW_SINGLE_QUOTES_mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        Jackson2ObjectMapper.registerWellKnownModulesIfAvailable(this.ALLOW_SINGLE_QUOTES_mapper);
        this.NOT_ALLOW_SINGLE_QUOTES_mapper = new ObjectMapper();
        this.NOT_ALLOW_SINGLE_QUOTES_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.NOT_ALLOW_SINGLE_QUOTES_mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, false);
        Jackson2ObjectMapper.registerWellKnownModulesIfAvailable(this.NOT_ALLOW_SINGLE_QUOTES_mapper);
    }

    public static void registerWellKnownModulesIfAvailable(ObjectMapper objectMapper) {
        if (ClassUtils.isPresent((String)"java.nio.file.Path", (ClassLoader)moduleClassLoader)) {
            try {
                Class jdk7Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jdk7.Jdk7Module", (ClassLoader)moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiate((Class)jdk7Module));
            }
            catch (ClassNotFoundException jdk7Module) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"java.util.Optional", (ClassLoader)moduleClassLoader)) {
            try {
                Class jdk8Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jdk8.Jdk8Module", (ClassLoader)moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiate((Class)jdk8Module));
            }
            catch (ClassNotFoundException jdk8Module) {
                // empty catch block
            }
        }
        try {
            Class javaTimeModuleRegistClass = ClassUtils.forName((String)"org.frameworkset.json.JavaTimeModuleRegist");
            Method javaTimeModuleRegist = javaTimeModuleRegistClass.getMethod("javaTimeModuleRegist", ObjectMapper.class);
            if (javaTimeModuleRegist != null) {
                javaTimeModuleRegist.invoke(null, objectMapper);
            }
        }
        catch (Exception javaTimeModuleRegistClass) {
        }
        catch (Throwable javaTimeModuleRegistClass) {
            // empty catch block
        }
        if (ClassUtils.isPresent((String)"org.joda.time.LocalDate", (ClassLoader)moduleClassLoader)) {
            try {
                Class jodaModule = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.joda.JodaModule", (ClassLoader)moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiate((Class)jodaModule));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> T json2Object(String jsonString, Class<T> toclass) {
        return this.json2Object(jsonString, toclass, false);
    }

    @Override
    public JavaType getJavaType(Class containerType, Class ... beanClass) {
        JavaType javaType = this.mapper.getTypeFactory().constructParametricType(containerType, beanClass);
        return javaType;
    }

    @Override
    public JavaType getJavaMapType(Class containerType, Class keyClass, Class valueClass) {
        MapType javaType = this.mapper.getTypeFactory().constructMapType(containerType, keyClass, valueClass);
        return javaType;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    @Override
    public <T> T json2Object(String jsonString, Class<T> toclass, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                Object value = this.ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, toclass);
                return (T)value;
            }
            Object value = this.NOT_ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, toclass);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(jsonString, e);
        }
    }

    @Override
    public <T> T json2Object(InputStream jsonString, Class<T> toclass, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                Object value = this.ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, toclass);
                return (T)value;
            }
            Object value = this.NOT_ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, toclass);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("", e);
        }
    }

    @Override
    public <T> T json2ObjectWithType(InputStream jsonString, final JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        TypeReference ref_ = new TypeReference<T>(){

            public Type getType() {
                return ref.getType();
            }
        };
        try {
            if (ALLOW_SINGLE_QUOTES) {
                Object value = this.ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, ref_);
                return (T)value;
            }
            Object value = this.NOT_ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, ref_);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T> T json2ObjectWithType(String jsonString, final JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        TypeReference ref_ = new TypeReference<T>(){

            public Type getType() {
                return ref.getType();
            }
        };
        try {
            if (ALLOW_SINGLE_QUOTES) {
                Object value = this.ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, ref_);
                return (T)value;
            }
            Object value = this.NOT_ALLOW_SINGLE_QUOTES_mapper.readValue(jsonString, ref_);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(jsonString, e);
        }
    }

    @Override
    public String object2json(Object object) {
        return this.object2json(object, false);
    }

    @Override
    public String object2json(Object object, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                String value = this.ALLOW_SINGLE_QUOTES_mapper.writeValueAsString(object);
                return value;
            }
            String value = this.NOT_ALLOW_SINGLE_QUOTES_mapper.writeValueAsString(object);
            return value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void object2json(Object object, File writer) {
        this.object2json(object, writer, false);
    }

    @Override
    public void object2json(Object object, File writer, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                this.ALLOW_SINGLE_QUOTES_mapper.writeValue(writer, object);
            } else {
                this.NOT_ALLOW_SINGLE_QUOTES_mapper.writeValue(writer, object);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void object2json(Object object, OutputStream writer) {
        this.object2json(object, writer, false);
    }

    @Override
    public void object2json(Object object, OutputStream writer, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                this.ALLOW_SINGLE_QUOTES_mapper.writeValue(writer, object);
            } else {
                this.NOT_ALLOW_SINGLE_QUOTES_mapper.writeValue(writer, object);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void object2json(Object object, Writer writer) {
        this.object2json(object, writer, false);
    }

    @Override
    public void object2json(Object object, Writer writer, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                this.ALLOW_SINGLE_QUOTES_mapper.writeValue(writer, object);
            } else {
                this.NOT_ALLOW_SINGLE_QUOTES_mapper.writeValue(writer, object);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public byte[] object2jsonAsbyte(Object object) {
        return this.object2jsonAsbyte(object, false);
    }

    @Override
    public byte[] object2jsonAsbyte(Object object, boolean ALLOW_SINGLE_QUOTES) {
        try {
            if (ALLOW_SINGLE_QUOTES) {
                return this.ALLOW_SINGLE_QUOTES_mapper.writeValueAsBytes(object);
            }
            return this.NOT_ALLOW_SINGLE_QUOTES_mapper.writeValueAsBytes(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void init() {
        if (this.dateFormat != null && !this.dateFormat.equals("")) {
            DateFormateMeta dateFormateMeta = DateFormateMeta.buildDateFormateMeta((String)this.dateFormat, (String)this.locale, (String)this.timeZone);
            this.mapper.setDateFormat(dateFormateMeta.toDateFormat());
            this.ALLOW_SINGLE_QUOTES_mapper.setDateFormat(dateFormateMeta.toDateFormat());
            this.NOT_ALLOW_SINGLE_QUOTES_mapper.setDateFormat(dateFormateMeta.toDateFormat());
        }
        if (this.disableTimestamp) {
            this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.ALLOW_SINGLE_QUOTES_mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.NOT_ALLOW_SINGLE_QUOTES_mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failedOnUnknownProperties);
        this.ALLOW_SINGLE_QUOTES_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failedOnUnknownProperties);
        this.NOT_ALLOW_SINGLE_QUOTES_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.failedOnUnknownProperties);
    }
}

