/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util;

import com.frameworkset.util.SimpleStringUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.frameworkset.util.SystemPropertyUtils;

public class TimeUtil {
    public static boolean enablePersistentLocalDate = false;
    private static DateTimeFormatter dateTimeFormatter;
    private static DateTimeFormatter dateTimeFormatterDefault;
    private static Map<String, DateTimeFormatter> dateTimeFormatterMap;
    private static Object lock;

    public static TimeUnit getTimeUnitByName(String timeUnit, TimeUnit defaultTimeUnit) {
        TimeUnit timeUnit_ = TimeUnit.SECONDS;
        if (timeUnit.equals("TimeUnit.SECONDS")) {
            timeUnit_ = TimeUnit.SECONDS;
        } else if (timeUnit.equals("TimeUnit.DAYS")) {
            try {
                timeUnit_ = TimeUnit.valueOf("DAYS");
            }
            catch (Exception e) {
                timeUnit_ = defaultTimeUnit;
            }
        }
        if (timeUnit.equals("TimeUnit.HOURS")) {
            try {
                timeUnit_ = TimeUnit.valueOf("HOURS");
            }
            catch (Exception e) {
                timeUnit_ = defaultTimeUnit;
            }
        } else if (timeUnit.equals("TimeUnit.MICROSECONDS")) {
            timeUnit_ = TimeUnit.MICROSECONDS;
        } else if (timeUnit.equals("TimeUnit.MILLISECONDS")) {
            timeUnit_ = TimeUnit.MILLISECONDS;
        } else if (timeUnit.equals("TimeUnit.MINUTES")) {
            try {
                timeUnit_ = TimeUnit.valueOf("MINUTES");
            }
            catch (Exception e) {
                timeUnit_ = defaultTimeUnit;
            }
        } else if (timeUnit.equals("TimeUnit.NANOSECONDS")) {
            timeUnit_ = TimeUnit.NANOSECONDS;
        }
        return timeUnit_;
    }

    public static Object convertLocalDatetime(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        if (enablePersistentLocalDate) {
            return localDateTime;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        Instant instant = zonedDateTime.toInstant();
        Date date = Date.from(instant);
        return date;
    }

    public static Object convertLocalDate(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        if (enablePersistentLocalDate) {
            return localDate;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Object convertLocalDate(Object localDate) {
        if (null == localDate) {
            return null;
        }
        if (localDate instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)localDate);
        }
        if (localDate instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)localDate);
        }
        return localDate;
    }

    public static LocalDateTime localDateTime(String localDateTime) {
        DateTimeFormatter dateTimeFormatter = TimeUtil.getDateTimeFormatter();
        LocalDateTime date = LocalDateTime.parse(localDateTime, dateTimeFormatter);
        return date;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeFormatter getDateTimeFormatter() {
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Object object = lock;
        synchronized (object) {
            DateTimeFormatter dateTimeFormatter_;
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            DateTimeFormatter ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendValue(ChronoField.MONTH_OF_YEAR, 2).optionalStart().appendLiteral('/').optionalEnd().optionalStart().appendLiteral('-').optionalEnd().optionalStart().appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
            DateTimeFormatter ISO_LOCAL_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalStart().appendZoneId().toFormatter();
            dateTimeFormatter = dateTimeFormatter_ = new DateTimeFormatterBuilder().append(ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().optionalStart().appendOptional(ISO_LOCAL_TIME).optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.SIMPLIFIED_CHINESE);
            return dateTimeFormatter;
        }
    }

    public static String changeLocalDateTime2String(LocalDateTime localDateTime) {
        return localDateTime.format(dateTimeFormatterDefault);
    }

    public static String changeLocalDate2String(LocalDate localDateTime) {
        return localDateTime.format(dateTimeFormatterDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeFormatter getDateTimeFormatter(String dateFormat) {
        DateTimeFormatter dateTimeFormatter = dateTimeFormatterMap.get(dateFormat);
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        Map<String, DateTimeFormatter> map = dateTimeFormatterMap;
        synchronized (map) {
            dateTimeFormatter = dateTimeFormatterMap.get(dateFormat);
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
            dateTimeFormatterMap.put(dateFormat, dateTimeFormatter);
            return dateTimeFormatter;
        }
    }

    public static String changeLocalDateTime2String(LocalDateTime localDateTime, String dateFormat) {
        if (SimpleStringUtil.isNotEmpty((String)dateFormat)) {
            return localDateTime.format(TimeUtil.getDateTimeFormatter(dateFormat));
        }
        return localDateTime.format(dateTimeFormatterDefault);
    }

    public static TimeUnit getTimeUnit(String timeUnit, TimeUnit defaultUnit) {
        TimeUnit timeUnit_ = TimeUnit.SECONDS;
        try {
            timeUnit_ = TimeUnit.valueOf(timeUnit);
        }
        catch (Exception e) {
            timeUnit_ = defaultUnit;
        }
        return timeUnit_;
    }

    public static Date addDates(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date addDateSeconds(Date date, int seconds) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, seconds);
        return c.getTime();
    }

    public static Date addDateMonths(Date date, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, months);
        return c.getTime();
    }

    public static Date addDateHours(Date date, int hours) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(10, hours);
        return c.getTime();
    }

    public static Date addDateMinitues(Date date, int Minitues) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, Minitues);
        return c.getTime();
    }

    public static Date addDateYears(Date date, int years) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        return c.getTime();
    }

    static {
        String _enablePersistentLocalDate = SystemPropertyUtils.getEnvironmentVariableValue("enablePersistentLocalDate");
        if (_enablePersistentLocalDate != null && _enablePersistentLocalDate.equalsIgnoreCase("true")) {
            enablePersistentLocalDate = true;
        }
        dateTimeFormatterDefault = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'");
        dateTimeFormatterMap = new LinkedHashMap<String, DateTimeFormatter>();
        lock = new Object();
    }
}

