/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.ip2region;

public class Util {
    public static void write(byte[] b, int offset, long v, int bytes) {
        for (int i = 0; i < bytes; ++i) {
            b[offset++] = (byte)(v >>> 8 * i & 0xFFL);
        }
    }

    public static void writeIntLong(byte[] b, int offset, long v) {
        b[offset++] = (byte)(v >> 0 & 0xFFL);
        b[offset++] = (byte)(v >> 8 & 0xFFL);
        b[offset++] = (byte)(v >> 16 & 0xFFL);
        b[offset] = (byte)(v >> 24 & 0xFFL);
    }

    public static long getIntLong(byte[] b, int offset) {
        return (long)b[offset++] & 0xFFL | (long)(b[offset++] << 8) & 0xFF00L | (long)(b[offset++] << 16) & 0xFF0000L | (long)(b[offset] << 24) & 0xFF000000L;
    }

    public static int getInt3(byte[] b, int offset) {
        return b[offset++] & 0xFF | b[offset++] & 0xFF00 | b[offset] & 0xFF0000;
    }

    public static int getInt2(byte[] b, int offset) {
        return b[offset++] & 0xFF | b[offset] & 0xFF00;
    }

    public static int getInt1(byte[] b, int offset) {
        return b[offset] & 0xFF;
    }

    public static long ip2long(String ip) {
        String[] p = ip.split("\\.");
        if (p.length != 4) {
            return 0L;
        }
        int p1 = Integer.valueOf(p[0]) << 24 & 0xFF000000;
        int p2 = Integer.valueOf(p[1]) << 16 & 0xFF0000;
        int p3 = Integer.valueOf(p[2]) << 8 & 0xFF00;
        int p4 = Integer.valueOf(p[3]) << 0 & 0xFF;
        return (long)(p1 | p2 | p3 | p4) & 0xFFFFFFFFL;
    }

    public static String long2ip(long ip) {
        StringBuilder sb = new StringBuilder();
        sb.append(ip >> 24 & 0xFFL).append('.').append(ip >> 16 & 0xFFL).append('.').append(ip >> 8 & 0xFFL).append('.').append(ip >> 0 & 0xFFL);
        return sb.toString();
    }

    public static boolean isIpAddress(String ip) {
        String[] p = ip.split("\\.");
        if (p.length != 4) {
            return false;
        }
        for (String pp : p) {
            if (pp.length() > 3) {
                return false;
            }
            int val = Integer.valueOf(pp);
            if (val <= 255) continue;
            return false;
        }
        return true;
    }
}

