/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.frameworkset.tran.jobflow.CompositionJobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowNodeStatus;
import org.frameworkset.tran.jobflow.JobFlowNodeType;
import org.frameworkset.tran.jobflow.context.AssertResult;
import org.frameworkset.tran.jobflow.context.DefaultJobFlowNodeExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowContext;
import org.frameworkset.tran.jobflow.context.ParrelJobFlowNodeContext;
import org.frameworkset.tran.jobflow.listener.JobFlowNodeListener;
import org.frameworkset.util.concurrent.ThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParrelJobFlowNode
extends CompositionJobFlowNode {
    private static Logger logger = LoggerFactory.getLogger(ParrelJobFlowNode.class);
    private ExecutorService blockedExecutor;
    private Object blockedExecutorLock = new Object();
    private ParrelJobFlowNodeContext parrelJobFlowNodeContext;
    private Object jobFlowNodeExecuteContextLock = new Object();

    public ParrelJobFlowNode() {
        this.jobFlowNodeType = JobFlowNodeType.PARREL;
        this.parrelJobFlowNodeContext = new ParrelJobFlowNodeContext(this);
        this.jobFlowNodeContext = this.parrelJobFlowNodeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService buildThreadPool() {
        if (this.blockedExecutor != null) {
            return this.blockedExecutor;
        }
        Object object = this.blockedExecutorLock;
        synchronized (object) {
            if (this.blockedExecutor == null) {
                this.blockedExecutor = ThreadPoolFactory.buildThreadPool((String)("ParrelJobFlowNode[" + this.nodeName + "]"), (String)("ParrelJobFlowNode[" + this.nodeName + "]"), (int)this.jobFlowNodes.size(), (int)10, (long)-1L, (int)1000);
            }
        }
        return this.blockedExecutor;
    }

    public void addJobFlowNode(JobFlowNode jobFlowNode) {
        if (this.jobFlowNodes == null) {
            this.jobFlowNodes = new ArrayList();
        }
        jobFlowNode.setCompositionJobFlowNode(this);
        jobFlowNode.setContainerParrelJobFlowNodeContext(this.parrelJobFlowNodeContext);
        this.jobFlowNodes.add(jobFlowNode);
    }

    @Override
    public void reset() {
        for (int i = 0; this.jobFlowNodes != null && i < this.jobFlowNodes.size(); ++i) {
            JobFlowNode jobFlowNode = (JobFlowNode)this.jobFlowNodes.get(i);
            jobFlowNode.reset();
        }
        super.reset();
    }

    @Override
    public boolean start(CyclicBarrier barrier) {
        this.parrelJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STARTED);
        this.nodeStart();
        if (barrier != null) {
            try {
                barrier.await();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
        this.jobFlow.getJobFlowContext().pauseAwait(this);
        JobFlowContext jobFlowContext = this.jobFlow.getJobFlowContext();
        AssertResult assertResult = jobFlowContext.assertStopped();
        if (assertResult.isTrue()) {
            logger.info("AssertStopped: true,ignore execute {}.", (Object)this.getJobFlowNodeInfo());
            return false;
        }
        if (this.assertTrigger()) {
            if (this.jobFlowNodes == null || this.jobFlowNodes.size() == 0) {
                throw new JobFlowException(this.getJobFlowNodeInfo() + " must set jobFlowNodes,please set jobFlowNodes first.");
            }
            this.jobFlowNodeExecuteContext = new DefaultJobFlowNodeExecuteContext(this);
            logger.info("Start {} begin.", (Object)this.getJobFlowNodeInfo());
            if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
                for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                    jobFlowNodeListener.beforeExecute(this.jobFlowNodeExecuteContext);
                }
            }
            ExecutorService blockedExecutor = this.buildThreadPool();
            ArrayList futureList = new ArrayList();
            CyclicBarrier thisBarrier = new CyclicBarrier(this.jobFlowNodes.size(), () -> logger.info("All Parrel jobFlowNodes[{}] of {} ready to running.", (Object)this.jobFlowNodes.size(), (Object)this.getJobFlowNodeInfo()));
            for (int i = 0; i < this.jobFlowNodes.size(); ++i) {
                JobFlowNode jobFlowNode = (JobFlowNode)this.jobFlowNodes.get(i);
                futureList.add(blockedExecutor.submit(() -> jobFlowNode.start(thisBarrier)));
            }
            ArrayList<Throwable> exceptions = null;
            for (Future future : futureList) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    if (exceptions == null) {
                        exceptions = new ArrayList<Throwable>();
                    }
                    exceptions.add(e.getCause());
                }
            }
            return true;
        }
        logger.info("AssertTrigger: false,ignore execute {}.", (Object)this.getJobFlowNodeInfo());
        this.jobFlowNodeExecuteContext = new DefaultJobFlowNodeExecuteContext(this);
        if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.beforeExecute(this.jobFlowNodeExecuteContext);
            }
        }
        this.nodeComplete(null, true);
        return false;
    }

    @Override
    protected void release() {
        if (this.blockedExecutor != null) {
            this.blockedExecutor.shutdown();
        }
        super.release();
    }

    @Override
    public void stop() {
        if (this.parrelJobFlowNodeContext.assertStoped()) {
            return;
        }
        logger.info("Stop {} begin.", (Object)this.getJobFlowNodeInfo());
        this.parrelJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STOPPING);
        for (int i = 0; this.jobFlowNodes != null && i < this.jobFlowNodes.size(); ++i) {
            JobFlowNode jobFlowNode = (JobFlowNode)this.jobFlowNodes.get(i);
            jobFlowNode.stop();
        }
        this.release();
        this.parrelJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STOPED);
        logger.info("Stop {} complete.", (Object)this.getJobFlowNodeInfo());
        if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.afterEnd(this);
            }
        }
        if (this.nextJobFlowNode != null) {
            this.nextJobFlowNode.stop();
        }
    }

    @Override
    public void brachComplete(JobFlowNode jobFlowNode, Throwable e) {
        if (this.parrelJobFlowNodeContext.allNodeComplete()) {
            this.nodeComplete(e, false);
        }
    }

    @Override
    public void pause() {
        for (int i = 0; this.jobFlowNodes != null && i < this.jobFlowNodes.size(); ++i) {
            JobFlowNode jobFlowNode = (JobFlowNode)this.jobFlowNodes.get(i);
            jobFlowNode.pause();
        }
        this.parrelJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.PAUSE);
    }

    @Override
    public void consume() {
        this.parrelJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.RUNNING);
        for (int i = 0; this.jobFlowNodes != null && i < this.jobFlowNodes.size(); ++i) {
            JobFlowNode jobFlowNode = (JobFlowNode)this.jobFlowNodes.get(i);
            jobFlowNode.consume();
        }
    }
}

