/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow;

import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.collections.CollectionUtils;
import org.frameworkset.tran.jobflow.CompositionJobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowNodeStatus;
import org.frameworkset.tran.jobflow.JobFlowNodeType;
import org.frameworkset.tran.jobflow.context.AssertResult;
import org.frameworkset.tran.jobflow.context.DefaultJobFlowNodeExecuteContext;
import org.frameworkset.tran.jobflow.context.JobFlowContext;
import org.frameworkset.tran.jobflow.context.SequenceJobFlowNodeContext;
import org.frameworkset.tran.jobflow.listener.JobFlowNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceJobFlowNode
extends CompositionJobFlowNode {
    private static Logger logger = LoggerFactory.getLogger(SequenceJobFlowNode.class);
    private JobFlowNode headerJobFlowNode;
    private SequenceJobFlowNodeContext sequenceJobFlowNodeContext;

    public SequenceJobFlowNode() {
        this.jobFlowNodeType = JobFlowNodeType.SEQUENCE;
        this.sequenceJobFlowNodeContext = new SequenceJobFlowNodeContext(this);
        this.jobFlowNodeContext = this.sequenceJobFlowNodeContext;
    }

    public SequenceJobFlowNodeContext getSequenceJobFlowNodeContext() {
        return this.sequenceJobFlowNodeContext;
    }

    public void setHeaderJobFlowNode(JobFlowNode headerJobFlowNode) {
        this.headerJobFlowNode = headerJobFlowNode;
        headerJobFlowNode.setCompositionJobFlowNode(this);
        headerJobFlowNode.setContainerSequenceJobFlowNodeContext(this.sequenceJobFlowNodeContext);
    }

    @Override
    public void reset() {
        this.headerJobFlowNode.reset();
        super.reset();
    }

    @Override
    public boolean start(CyclicBarrier barrier) {
        this.sequenceJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STARTED);
        this.nodeStart();
        if (barrier != null) {
            try {
                barrier.await();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
        this.jobFlow.getJobFlowContext().pauseAwait(this);
        JobFlowContext jobFlowContext = this.jobFlow.getJobFlowContext();
        AssertResult assertResult = jobFlowContext.assertStopped();
        if (assertResult.isTrue()) {
            logger.info("AssertStopped: true,ignore execute {}.", (Object)this.getJobFlowNodeInfo());
            return false;
        }
        if (this.assertTrigger()) {
            this.jobFlowNodeExecuteContext = new DefaultJobFlowNodeExecuteContext(this);
            if (this.headerJobFlowNode == null) {
                throw new JobFlowException(this.getJobFlowNodeInfo() + ":headerJobFlowNode is null.");
            }
            logger.info("Start {} begin.", (Object)this.getJobFlowNodeInfo());
            if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
                for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                    jobFlowNodeListener.beforeExecute(this.jobFlowNodeExecuteContext);
                }
            }
            this.headerJobFlowNode.start();
            return true;
        }
        this.jobFlowNodeExecuteContext = new DefaultJobFlowNodeExecuteContext(this);
        if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.beforeExecute(this.jobFlowNodeExecuteContext);
            }
        }
        logger.info("AssertTrigger: false,ignore execute {}.", (Object)this.getJobFlowNodeInfo());
        this.nodeComplete(null, true);
        return false;
    }

    @Override
    public void stop() {
        if (this.sequenceJobFlowNodeContext.assertStoped()) {
            return;
        }
        logger.info("Stop {} begin.", (Object)this.getJobFlowNodeInfo());
        this.sequenceJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STOPPING);
        try {
            this.sequenceJobFlowNodeContext.stop();
            if (this.headerJobFlowNode != null) {
                this.headerJobFlowNode.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Stop " + this.getJobFlowNodeInfo() + " failed:", (Throwable)e);
        }
        this.sequenceJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.STOPED);
        logger.info("Stop {} complete.", (Object)this.getJobFlowNodeInfo());
        if (CollectionUtils.isNotEmpty((Collection)this.jobFlowNodeListeners)) {
            for (JobFlowNodeListener jobFlowNodeListener : this.jobFlowNodeListeners) {
                jobFlowNodeListener.afterEnd(this);
            }
        }
        if (this.nextJobFlowNode != null) {
            this.nextJobFlowNode.stop();
        }
    }

    @Override
    public void brachComplete(JobFlowNode jobFlowNode, Throwable e) {
        this.nodeComplete(e, false);
    }

    @Override
    public void pause() {
        this.sequenceJobFlowNodeContext.pause();
        this.sequenceJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.PAUSE);
    }

    @Override
    public void consume() {
        this.sequenceJobFlowNodeContext.updateJobFlowNodeStatus(JobFlowNodeStatus.RUNNING);
        this.sequenceJobFlowNodeContext.consume();
    }
}

