/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.context;

import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.JobFlowNode;
import org.frameworkset.tran.jobflow.JobFlowStatus;
import org.frameworkset.tran.jobflow.context.AssertResult;
import org.frameworkset.tran.jobflow.context.StaticContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFlowContext
extends StaticContext {
    private static Logger logger = LoggerFactory.getLogger(JobFlowContext.class);
    private JobFlow jobFlow;
    protected JobFlowStatus jobFlowStatus = JobFlowStatus.INIT;
    private JobFlowNode runningJobFlowNode;
    private Object runningJobFlowNodeLock = new Object();
    private Object updateJobFlowStatusLock = new Object();
    private CountDownLatch pauseCountDownLatch = null;
    private Object pauseCountDownLatchLock = new Object();

    public JobFlowContext(JobFlow jobFlow) {
        this.jobFlow = jobFlow;
    }

    public JobFlow getJobFlow() {
        return this.jobFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobFlowStatus updateJobFlowStatus(JobFlowStatus jobFlowStatus) {
        Object object = this.updateJobFlowStatusLock;
        synchronized (object) {
            this.jobFlowStatus = jobFlowStatus;
            return jobFlowStatus;
        }
    }

    public Object getUpdateJobFlowStatusLock() {
        return this.updateJobFlowStatusLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssertResult assertStarted() {
        Object object = this.updateJobFlowStatusLock;
        synchronized (object) {
            return new AssertResult(this.jobFlowStatus, this.jobFlowStatus != JobFlowStatus.INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssertResult assertStopped() {
        Object object = this.updateJobFlowStatusLock;
        synchronized (object) {
            return new AssertResult(this.jobFlowStatus, this.jobFlowStatus == JobFlowStatus.STOPED || this.jobFlowStatus == JobFlowStatus.STOPPING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssertResult assertStatus(JobFlowStatus ... jobFlowStatus) {
        Object object = this.updateJobFlowStatusLock;
        synchronized (object) {
            boolean result = false;
            for (JobFlowStatus tmp : jobFlowStatus) {
                if (this.jobFlowStatus != tmp) continue;
                result = true;
                break;
            }
            return new AssertResult(this.jobFlowStatus, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobFlowStatus initJob() {
        Object object = this.updateJobFlowStatusLock;
        synchronized (object) {
            if (this.jobFlowStatus == JobFlowStatus.INIT) {
                this.jobFlowStatus = JobFlowStatus.STARTED;
            }
            return this.jobFlowStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobFlowStatus getJobFlowStatus() {
        Object object = this.updateJobFlowStatusLock;
        synchronized (object) {
            return this.jobFlowStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunningJobFlowNode(JobFlowNode runningJobFlowNode) {
        Object object = this.runningJobFlowNodeLock;
        synchronized (object) {
            this.runningJobFlowNode = runningJobFlowNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobFlowNode getRunningJobFlowNode() {
        Object object = this.runningJobFlowNodeLock;
        synchronized (object) {
            return this.runningJobFlowNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(Function callback, boolean fromScheduled) {
        boolean result = false;
        Object object = this.runningJobFlowNodeLock;
        synchronized (object) {
            AssertResult assertResult = this.assertStatus(JobFlowStatus.COMPLETE, JobFlowStatus.RUNNING, JobFlowStatus.STARTED, JobFlowStatus.PAUSE);
            if (assertResult.isFalse()) {
                logger.info("Stop {} [fromScheduled={}] \u5904\u4e8e\u975e\u8fd0\u884c\u72b6\u6001:{}\uff0c\u5ffd\u7565\u505c\u6b62\u64cd\u4f5c.", new Object[]{this.jobFlow.getJobInfo(), fromScheduled, assertResult.getJobFlowStatus().name()});
                return result;
            }
            logger.info("Stop {} [fromScheduled={}] start.", (Object)this.jobFlow.getJobInfo(), (Object)fromScheduled);
            this.updateJobFlowStatus(JobFlowStatus.STOPPING);
        }
        this.stopAndInteruptPause();
        if (this.runningJobFlowNode != null) {
            this.runningJobFlowNode.stop();
        } else {
            logger.info("Stop {} [fromScheduled={}] :ignore stop runningJobFlowNode,runningJobFlowNode is null.", (Object)this.jobFlow.getJobInfo(), (Object)fromScheduled);
        }
        callback.apply(null);
        object = this.runningJobFlowNodeLock;
        synchronized (object) {
            this.updateJobFlowStatus(JobFlowStatus.STOPED);
            result = true;
        }
        logger.info("Stop {} [fromScheduled={}] complete.", (Object)this.jobFlow.getJobInfo(), (Object)fromScheduled);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause() {
        boolean result = false;
        Object object = this.runningJobFlowNodeLock;
        synchronized (object) {
            AssertResult assertResult = this.assertStatus(JobFlowStatus.COMPLETE, JobFlowStatus.RUNNING, JobFlowStatus.STARTED);
            if (assertResult.isFalse()) {
                logger.warn("{} \u5904\u4e8e\u72b6\u6001:{},\u5ffd\u7565\u6682\u505c\u64cd\u4f5c.", (Object)this.jobFlow.getJobInfo(), (Object)assertResult.getJobFlowStatus().name());
            } else {
                logger.warn("Pause {} start.", (Object)this.jobFlow.getJobInfo(), (Object)assertResult.getJobFlowStatus().name());
                if (this.runningJobFlowNode != null) {
                    this.runningJobFlowNode.pause();
                } else {
                    logger.info("Pause {} :ignore pause runningJobFlowNode,runningJobFlowNode is null,", (Object)this.jobFlow.getJobInfo());
                }
                Object object2 = this.pauseCountDownLatchLock;
                synchronized (object2) {
                    this.pauseCountDownLatch = new CountDownLatch(1);
                }
                this.updateJobFlowStatus(JobFlowStatus.PAUSE);
                result = true;
                logger.warn("Pause {} complete.", (Object)this.jobFlow.getJobInfo(), (Object)assertResult.getJobFlowStatus().name());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAwait(JobFlowNode jobFlowNode) {
        if (this.assertStatus(JobFlowStatus.PAUSE).isTrue()) {
            try {
                CountDownLatch countDownLatch = null;
                Object object = this.pauseCountDownLatchLock;
                synchronized (object) {
                    countDownLatch = this.pauseCountDownLatch;
                }
                if (countDownLatch != null) {
                    logger.info("Pause {} begin.", (Object)jobFlowNode.getJobFlowNodeInfo());
                    countDownLatch.await();
                    logger.info("Consume {} complete.", (Object)jobFlowNode.getJobFlowNodeInfo());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stopAndInteruptPause() {
        this.pauseLatchCountDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseLatchCountDown() {
        Object object = this.pauseCountDownLatchLock;
        synchronized (object) {
            if (this.pauseCountDownLatch != null) {
                this.pauseCountDownLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consume() {
        boolean result = false;
        Object object = this.runningJobFlowNodeLock;
        synchronized (object) {
            AssertResult assertResult = this.assertStatus(JobFlowStatus.PAUSE);
            if (assertResult.isFalse()) {
                logger.warn("{} \u5de5\u4f5c\u6d41\u5904\u4e8e\u975e\u6682\u505c\u72b6\u6001\uff1a{}\uff0c\u5ffd\u7565Consume\u64cd\u4f5c", (Object)this.jobFlow.getJobInfo(), (Object)assertResult.getJobFlowStatus().name());
            } else {
                this.pauseLatchCountDown();
                if (this.runningJobFlowNode != null) {
                    this.runningJobFlowNode.consume();
                } else {
                    logger.info("Consume {} :ignore consume runningJobFlowNode,runningJobFlowNode is null,", (Object)this.jobFlow.getJobInfo());
                }
                this.updateJobFlowStatus(JobFlowStatus.RUNNING);
                result = true;
            }
        }
        return result;
    }

    @Override
    public int nodeComplete(Throwable throwable, JobFlowNode jobFlowNode) {
        this.runningJobFlowNode = null;
        return super.nodeComplete(throwable, jobFlowNode);
    }
}

