/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.context;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.tran.jobflow.JobFlowNode;

public class StaticContext {
    private int runningNodes;
    private int startNodes;
    private List<String> startNodeIds;
    private int completeNodes;
    private int completeSuccessNodes;
    private int completeWithExceptionNodes;
    private List<String> completeNodeIds;
    private List<String> completeSuccessNodeIds;
    private List<String> completeWithExceptionNodeIds;
    protected Throwable executeException;
    private Object updateLock = new Object();

    public void setExecuteException(Throwable executeException) {
        this.executeException = executeException;
    }

    public Throwable getExecuteException() {
        return this.executeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticContext copy() {
        Object object = this.updateLock;
        synchronized (object) {
            StaticContext staticContext = new StaticContext();
            staticContext.startNodes = this.startNodes;
            staticContext.completeNodes = this.completeNodes;
            staticContext.runningNodes = this.runningNodes;
            staticContext.completeWithExceptionNodes = this.completeWithExceptionNodes;
            staticContext.completeSuccessNodes = this.completeSuccessNodes;
            staticContext.completeNodeIds = this.completeNodeIds;
            staticContext.startNodeIds = this.startNodeIds;
            staticContext.completeSuccessNodeIds = this.completeSuccessNodeIds;
            staticContext.completeWithExceptionNodeIds = this.completeWithExceptionNodeIds;
            staticContext.executeException = this.executeException;
            return staticContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.updateLock;
        synchronized (object) {
            this.startNodes = 0;
            this.completeNodes = 0;
            this.runningNodes = 0;
            this.completeWithExceptionNodes = 0;
            this.completeSuccessNodes = 0;
            this.completeNodeIds = null;
            this.startNodeIds = null;
            this.completeSuccessNodeIds = null;
            this.completeWithExceptionNodeIds = null;
        }
        this.executeException = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartNodes() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.startNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nodeStart(JobFlowNode jobFlowNode) {
        Object object = this.updateLock;
        synchronized (object) {
            ++this.startNodes;
            if (this.startNodeIds == null) {
                this.startNodeIds = new ArrayList<String>();
            }
            this.startNodeIds.add(jobFlowNode.getNodeId());
            ++this.runningNodes;
            return this.startNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nodeComplete(Throwable throwable, JobFlowNode jobFlowNode) {
        Object object = this.updateLock;
        synchronized (object) {
            --this.runningNodes;
            ++this.completeNodes;
            if (this.completeNodeIds == null) {
                this.completeNodeIds = new ArrayList<String>();
            }
            this.completeNodeIds.add(jobFlowNode.getNodeId());
            if (throwable == null) {
                ++this.completeSuccessNodes;
                if (this.completeSuccessNodeIds == null) {
                    this.completeSuccessNodeIds = new ArrayList<String>();
                }
                this.completeSuccessNodeIds.add(jobFlowNode.getNodeId());
            } else {
                if (this.completeWithExceptionNodeIds == null) {
                    this.completeWithExceptionNodeIds = new ArrayList<String>();
                }
                this.completeWithExceptionNodeIds.add(jobFlowNode.getNodeId());
                ++this.completeWithExceptionNodes;
            }
            return this.completeNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningNodes() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.runningNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompleteNodes() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompleteWithExceptionNodes() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeWithExceptionNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompleteSuccessNodes() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeSuccessNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allNodeComplete() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeNodes == this.startNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCompleteWithExceptionNodeIds() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeWithExceptionNodeIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCompleteNodeIds() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeNodeIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCompleteSuccessNodeIds() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.completeSuccessNodeIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStartNodeIds() {
        Object object = this.updateLock;
        synchronized (object) {
            return this.startNodeIds;
        }
    }
}

