/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.schedule;

import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.JobFlowException;
import org.frameworkset.tran.jobflow.builder.JobFlowBuilder;
import org.frameworkset.tran.jobflow.schedule.JobFlowBuilderFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalJobFlowScheduler {
    private JobFlowBuilderFunction jobFlowBuilderFunction;
    private JobFlow jobFlow;
    private static Logger logger = LoggerFactory.getLogger(ExternalJobFlowScheduler.class);

    public void setJobFlowBuilderFunction(JobFlowBuilderFunction jobFlowBuilderFunction) {
        this.jobFlowBuilderFunction = jobFlowBuilderFunction;
    }

    private void initJobFlow(Object params) {
        if (this.jobFlow == null) {
            if (this.jobFlowBuilderFunction == null) {
                throw new JobFlowException("initJobFlow failed:JobFlowBuilderFunction is null");
            }
            try {
                if (this.jobFlow == null) {
                    JobFlowBuilder jobFlowBuilder = this.jobFlowBuilderFunction.build(params);
                    if (!jobFlowBuilder.isExternalTimer()) {
                        jobFlowBuilder.setExternalTimer(true);
                    }
                    this.jobFlow = jobFlowBuilder.build();
                }
            }
            catch (JobFlowException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ExternalJobScheduler execute failed:", (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ExternalJobScheduler execute failed:", (Throwable)e);
                }
                throw new JobFlowException("ExternalJobScheduler execute failed:", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ExternalJobScheduler execute failed:", e);
                }
                throw new JobFlowException("ExternalJobScheduler execute failed:", e);
            }
            if (this.jobFlow == null) {
                throw new JobFlowException("ExternalJobScheduler failed: jobFlow build failed");
            }
            this.jobFlow.initJob();
        }
    }

    public void execute(Object params) {
        this.initJobFlow(params);
        this.jobFlow.execute();
    }

    public void destroy() {
        if (this.jobFlow != null) {
            this.jobFlow.stop();
            this.jobFlow = null;
        }
        this.jobFlowBuilderFunction = null;
    }
}

