/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.entity;

import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.job.MetricsLogAPI;

public abstract class KeyMetric {
    protected MetricsLogAPI metricsLogAPI;
    protected String metric;
    protected Date dataTime;
    protected Date slotTime;
    protected ReentrantLock incrementLock = new ReentrantLock();
    protected long count;
    protected Object min;
    protected Object max;
    protected Object avg;
    protected long success;
    protected long failed;

    public abstract void init(MapData var1);

    public abstract void incr(MapData var1);

    public String getMetric() {
        return this.metric;
    }

    public void increment(MapData data) {
        this.incrementLock.lock();
        try {
            this.incr(data);
        }
        finally {
            this.incrementLock.unlock();
        }
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Date getDataTime() {
        return this.dataTime;
    }

    public void setDataTime(Date dataTime) {
        this.dataTime = dataTime;
    }

    public Date getSlotTime() {
        return this.slotTime;
    }

    public void setSlotTime(Date slotTime) {
        this.slotTime = slotTime;
    }

    public Object getMin() {
        return this.min;
    }

    public void setMin(Object min) {
        this.min = min;
    }

    public Object getMax() {
        return this.max;
    }

    public void setMax(Object max) {
        this.max = max;
    }

    public Object getAvg() {
        return this.avg;
    }

    public void setAvg(Object avg) {
        this.avg = avg;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getSuccess() {
        return this.success;
    }

    public void setSuccess(long success) {
        this.success = success;
    }

    public long getFailed() {
        return this.failed;
    }

    public void setFailed(long failed) {
        this.failed = failed;
    }

    public void setMetricsLogAPI(MetricsLogAPI metricsLogAPI) {
        this.metricsLogAPI = metricsLogAPI;
    }

    public MetricsLogAPI getMetricsLogAPI() {
        return this.metricsLogAPI;
    }
}

