/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.client.Context;
import org.frameworkset.elasticsearch.client.DB2ESImportBuilder;
import org.frameworkset.elasticsearch.client.ESJDBC;
import org.frameworkset.elasticsearch.client.FieldMeta;
import org.frameworkset.elasticsearch.client.ResultUtil;

public class ContextImpl
implements Context {
    private List<FieldMeta> fieldValues;
    private Map<String, FieldMeta> fieldMetaMap;
    private ESJDBC esjdbc;
    private boolean drop;

    public ContextImpl(ESJDBC esjdbc) {
        this.esjdbc = esjdbc;
    }

    @Override
    public List<FieldMeta> getFieldValues() {
        return this.fieldValues;
    }

    @Override
    public Map<String, FieldMeta> getFieldMetaMap() {
        return this.fieldMetaMap;
    }

    @Override
    public Context addFieldValue(String fieldName, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, value);
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, this.esjdbc.getLocale(), this.esjdbc.getTimeZone());
        return this;
    }

    @Override
    public Context addFieldValue(String fieldName, String dateFormat, Object value, String locale, String timeZone) {
        if (this.fieldValues == null) {
            this.fieldValues = new ArrayList<FieldMeta>();
        }
        DB2ESImportBuilder.addFieldValue(this.fieldValues, fieldName, dateFormat, value, locale, timeZone);
        return this;
    }

    @Override
    public Context addIgnoreFieldMapping(String dbColumnName) {
        if (this.fieldMetaMap == null) {
            this.fieldMetaMap = new HashMap<String, FieldMeta>();
        }
        DB2ESImportBuilder.addIgnoreFieldMapping(this.fieldMetaMap, dbColumnName);
        return this;
    }

    @Override
    public ESJDBC getEsjdbc() {
        return this.esjdbc;
    }

    @Override
    public String getDBName() {
        return this.esjdbc.getDbConfig().getDbName();
    }

    @Override
    public long getLongValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.longValue((Object)value, (Long)0L);
    }

    @Override
    public double getDoubleValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.doubleValue((Object)value, (Double)0.0);
    }

    @Override
    public float getFloatValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.floatValue((Object)value, (Float)Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getIntegerValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        return ResultUtil.intValue((Object)value, (Integer)0);
    }

    @Override
    public Date getDateValue(String fieldName) throws Exception {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    @Override
    public Object getValue(String fieldName) throws Exception {
        return this.esjdbc.getValue(fieldName);
    }

    @Override
    public FieldMeta getMappingName(String colName) {
        FieldMeta fieldMeta;
        if (this.fieldMetaMap != null && (fieldMeta = this.fieldMetaMap.get(colName.toLowerCase())) != null) {
            return fieldMeta;
        }
        return this.esjdbc.getMappingName(colName);
    }

    @Override
    public Object getEsId() throws Exception {
        return this.esjdbc.getEsIdGenerator().genId(this);
    }

    @Override
    public String getEsIdField() {
        return this.esjdbc.getEsIdField();
    }

    @Override
    public boolean isDrop() {
        return this.drop;
    }

    @Override
    public void setDrop(boolean drop) {
        this.drop = drop;
    }
}

