/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ESJDBC;

public abstract class ErrorWrapper {
    protected volatile Exception error;
    private Lock lock = new ReentrantLock();

    public void setError(Exception error) {
        if (this.error == null) {
            try {
                this.lock.lock();
                if (this.error == null) {
                    this.error = error;
                    this.getESJDBC().setErrorWrapper(this);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean assertCondition() {
        return this.error == null || this.getESJDBC().isContinueOnError();
    }

    public boolean assertCondition(Exception e) {
        return this.error == null && e == null || this.getESJDBC().isContinueOnError();
    }

    public abstract ClientInterface getClientInterface();

    public abstract ESJDBC getESJDBC();
}

