/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client.estodb;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.SQLExecutor;
import java.util.List;
import org.frameworkset.elasticsearch.client.estodb.ES2DB;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESExporterScrollHandler<T>
implements ScrollHandler<T> {
    private ES2DB es2DB;
    private static Logger logger = LoggerFactory.getLogger(ESExporterScrollHandler.class);

    public ESExporterScrollHandler(ES2DB es2DB) {
        this.es2DB = es2DB;
    }

    public void handle(ESDatas<T> response, HandlerInfo handlerInfo) throws Exception {
        long totalSize = response.getTotalSize();
        List datas = response.getDatas();
        int batchNo = this.es2DB.getExportCount().increamentCount();
        if (totalSize == 0L || datas == null || datas.size() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Igonre Execute export task {}:zero or null datas.", (Object)batchNo);
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Execute task {} start.", (Object)batchNo);
        }
        if (this.es2DB.getSql() == null) {
            this.es2DB.getConfigSQLExecutor().executeBatch(this.es2DB.getDbConfig().getDbName(), this.es2DB.getSqlName(), datas, this.es2DB.getBatchSize(), this.es2DB.getBatchHandler());
        } else {
            SQLExecutor.executeBatch((String)this.es2DB.getDbConfig().getDbName(), (String)this.es2DB.getSql(), (List)datas, (int)this.es2DB.getBatchSize(), (BatchHandler)this.es2DB.getBatchHandler());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Execute task {} complete and export data {} record.", (Object)batchNo, (Object)datas.size());
        }
    }
}

