/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch;

import com.frameworkset.util.SimpleStringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.ElasticSearchClientFactory;
import org.frameworkset.elasticsearch.scroll.thread.ThreadPoolFactory;
import org.frameworkset.spi.BaseApplicationContext;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.support.ApplicationObjectSupport;
import org.frameworkset.util.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearch
extends ApplicationObjectSupport {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearch.class);
    protected static final int defaultBatchSize = 100;
    protected final Pattern pattern = Pattern.compile("^(\\d+)(\\D*)", 2);
    private ClientInterface detaultClientInterface;
    protected Properties elasticsearchPropes;
    protected Properties extendElasticsearchPropes;
    protected int batchSize = 100;
    protected long ttlMs = -1L;
    protected String indexName = "trace";
    protected String indexType = "log";
    protected String elasticUser = "";
    protected String elasticPassword = "";
    protected Matcher matcher = this.pattern.matcher("");
    protected String[] restServerAddresses = null;
    protected String origineRestServerAddresses;
    protected ElasticSearchClient restClient = null;
    protected ExecutorService sliceScrollQueryExecutorService;
    protected ExecutorService scrollQueryExecutorService;
    protected int sliceScrollThreadCount = 100;
    protected int sliceScrollThreadQueue = 100;
    protected long sliceScrollBlockedWaitTimeout = 0L;
    protected int scrollThreadCount = 200;
    protected int scrollThreadQueue = 200;
    protected long scrollBlockedWaitTimeout = 0L;
    protected IndexNameBuilder indexNameBuilder;
    private Map<String, ClientInterface> configClientUtis = new HashMap<String, ClientInterface>();

    public String getOrigineRestServerAddresses() {
        return this.origineRestServerAddresses;
    }

    public void setOrigineRestServerAddresses(String origineRestServerAddresses) {
        this.origineRestServerAddresses = origineRestServerAddresses;
    }

    String[] getRestServerAddresses() {
        return this.restServerAddresses;
    }

    public FastDateFormat getIndexDateFormat() {
        return this.indexNameBuilder.getFastDateFormat();
    }

    String getIndexName() {
        return this.indexName;
    }

    String getIndexType() {
        return this.indexType;
    }

    long getTTLMs() {
        return this.ttlMs;
    }

    IndexNameBuilder getIndexNameBuilder() {
        return this.indexNameBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInterface getRestClientUtil() {
        if (this.detaultClientInterface == null) {
            if (this.restClient != null) {
                ElasticSearch elasticSearch = this;
                synchronized (elasticSearch) {
                    if (this.detaultClientInterface != null) {
                        return this.detaultClientInterface;
                    }
                    this.detaultClientInterface = this.restClient.getClientUtil(this.indexNameBuilder);
                    return this.detaultClientInterface;
                }
            }
            return null;
        }
        return this.detaultClientInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInterface getConfigRestClientUtil(String configFile) {
        ClientInterface clientInterface = this.configClientUtis.get(configFile);
        if (clientInterface != null) {
            return clientInterface;
        }
        if (this.restClient != null) {
            Map<String, ClientInterface> map = this.configClientUtis;
            synchronized (map) {
                clientInterface = this.configClientUtis.get(configFile);
                if (clientInterface != null) {
                    return clientInterface;
                }
                clientInterface = this.restClient.getConfigClientUtil(this.indexNameBuilder, configFile);
                this.configClientUtis.put(configFile, clientInterface);
                return clientInterface;
            }
        }
        return null;
    }

    public Object executeRequest(String path, String entity) throws Exception {
        ClientInterface clientUtil = this.getRestClientUtil();
        return clientUtil.executeRequest(path, entity);
    }

    public String getConfigContainerInfo() {
        if (this.getApplicationContext() != null) {
            return this.getApplicationContext().getConfigfile();
        }
        return "ElasticSearch Configs";
    }

    public void configure() {
        this.configureWithConfigContext(null);
    }

    public void configureWithConfigContext(GetProperties configContext) {
        String ttl;
        String _scrollThreadQueue;
        String _scrollBlockedWaitTimeout;
        String _scrollThreadCount;
        String _sliceScrollThreadQueue;
        String _sliceScrollBlockedWaitTimeout;
        String _sliceScrollThreadCount;
        String bz;
        if (configContext != null && configContext instanceof BaseApplicationContext) {
            this.setApplicationContext((BaseApplicationContext)configContext);
        }
        this.origineRestServerAddresses = this.elasticsearchPropes.getProperty("elasticsearch.rest.hostNames");
        if (SimpleStringUtil.isNotEmpty((String)this.origineRestServerAddresses)) {
            this.origineRestServerAddresses = this.origineRestServerAddresses.trim();
            this.restServerAddresses = this.origineRestServerAddresses.split(",");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticsearch.indexName"))) {
            this.indexName = this.elasticsearchPropes.getProperty("elasticsearch.indexName");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticsearch.indexType"))) {
            this.indexType = this.elasticsearchPropes.getProperty("elasticsearch.indexType");
        }
        if (SimpleStringUtil.isNotEmpty((String)(bz = this.elasticsearchPropes.getProperty("batchSize")))) {
            try {
                this.batchSize = Integer.parseInt(bz);
            }
            catch (Exception e) {
                logger.warn(bz, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(_sliceScrollThreadCount = this.elasticsearchPropes.getProperty("elasticsearch.sliceScrollThreadCount")))) {
            try {
                this.sliceScrollThreadCount = Integer.parseInt(_sliceScrollThreadCount);
            }
            catch (Exception e) {
                logger.warn(_sliceScrollThreadCount, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(_sliceScrollBlockedWaitTimeout = this.elasticsearchPropes.getProperty("elasticsearch.sliceScrollBlockedWaitTimeout")))) {
            try {
                this.sliceScrollBlockedWaitTimeout = Long.parseLong(_sliceScrollBlockedWaitTimeout);
            }
            catch (Exception e) {
                logger.warn(_sliceScrollBlockedWaitTimeout, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(_sliceScrollThreadQueue = this.elasticsearchPropes.getProperty("elasticsearch.sliceScrollThreadQueue")))) {
            try {
                this.sliceScrollThreadQueue = Integer.parseInt(_sliceScrollThreadQueue);
            }
            catch (Exception e) {
                logger.warn(_sliceScrollThreadQueue, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(_scrollThreadCount = this.elasticsearchPropes.getProperty("elasticsearch.scrollThreadCount")))) {
            try {
                this.scrollThreadCount = Integer.parseInt(_scrollThreadCount);
            }
            catch (Exception e) {
                logger.warn(_scrollThreadCount, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(_scrollBlockedWaitTimeout = this.elasticsearchPropes.getProperty("elasticsearch.scrollBlockedWaitTimeout")))) {
            try {
                this.scrollBlockedWaitTimeout = Long.parseLong(_scrollBlockedWaitTimeout);
            }
            catch (Exception e) {
                logger.warn(_scrollBlockedWaitTimeout, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(_scrollThreadQueue = this.elasticsearchPropes.getProperty("elasticsearch.scrollThreadQueue")))) {
            try {
                this.scrollThreadQueue = Integer.parseInt(_scrollThreadQueue);
            }
            catch (Exception e) {
                logger.warn(_scrollThreadQueue, (Throwable)e);
            }
        }
        if (SimpleStringUtil.isNotEmpty((String)(ttl = this.elasticsearchPropes.getProperty("elasticsearch.ttl")))) {
            this.ttlMs = this.parseTTL(ttl);
            logger.info("elasticsearch.TTL:" + this.ttlMs + ",config value is:" + ttl);
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticUser"))) {
            this.elasticUser = this.elasticsearchPropes.getProperty("elasticUser");
        }
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("elasticPassword"))) {
            this.elasticPassword = this.elasticsearchPropes.getProperty("elasticPassword");
        }
        String indexNameBuilderClass = this.getIndexNameBuilderClass();
        try {
            Class<?> clazz = Class.forName(indexNameBuilderClass);
            this.indexNameBuilder = (IndexNameBuilder)clazz.newInstance();
            this.indexNameBuilder.configure(this.elasticsearchPropes);
            if (configContext == null) {
                this.start();
            }
        }
        catch (Exception e) {
            throw new ElasticSearchException("Could not instantiate index name builder.", e);
        }
    }

    protected String getIndexNameBuilderClass() {
        String indexNameBuilderClass = "org.frameworkset.elasticsearch.TimeBasedIndexNameBuilder";
        if (SimpleStringUtil.isNotEmpty((String)this.elasticsearchPropes.getProperty("indexNameBuilder"))) {
            indexNameBuilderClass = this.elasticsearchPropes.getProperty("indexNameBuilder");
        }
        return indexNameBuilderClass;
    }

    protected void start() {
        block3: {
            ElasticSearchClientFactory clientFactory = new ElasticSearchClientFactory();
            try {
                if (this.restServerAddresses != null && this.restServerAddresses.length > 0) {
                    logger.info("Start ElasticSearch rest client:" + this.origineRestServerAddresses);
                    this.restClient = clientFactory.getClient(this, "rest", this.restServerAddresses, this.elasticUser, this.elasticPassword, this.extendElasticsearchPropes);
                    this.restClient.configure(this.elasticsearchPropes);
                    this.restClient.init();
                    logger.info("ElasticSearch rest client started.");
                }
            }
            catch (Exception ex) {
                logger.error("ElasticSearch Rest Client started failed", (Throwable)ex);
                if (this.restClient == null) break block3;
                this.restClient.close();
            }
        }
    }

    public void stop() {
        logger.info("ElasticSearch client stopping");
        if (this.restClient != null) {
            this.restClient.close();
        }
        this.configClientUtis.clear();
        this.detaultClientInterface = null;
        if (this.sliceScrollQueryExecutorService != null) {
            this.sliceScrollQueryExecutorService.shutdown();
        }
        if (this.scrollQueryExecutorService != null) {
            this.scrollQueryExecutorService.shutdown();
        }
    }

    protected long parseTTL(String ttl) {
        this.matcher = this.matcher.reset(ttl);
        if (this.matcher.find()) {
            if (this.matcher.group(2).equals("ms")) {
                return Long.parseLong(this.matcher.group(1));
            }
            if (this.matcher.group(2).equals("s")) {
                return TimeUnit.SECONDS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("m")) {
                return TimeUnit.MINUTES.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("h")) {
                return TimeUnit.HOURS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("d")) {
                return TimeUnit.DAYS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("w")) {
                return TimeUnit.DAYS.toMillis(7 * Integer.parseInt(this.matcher.group(1)));
            }
            if (this.matcher.group(2).equals("")) {
                logger.info("TTL qualifier is empty. Defaulting to day qualifier.");
                return TimeUnit.DAYS.toMillis(Integer.parseInt(this.matcher.group(1)));
            }
            logger.debug("Unknown TTL qualifier provided. Setting TTL to 0.");
            return 0L;
        }
        logger.info("TTL not provided. Skipping the TTL config by returning 0.");
        return -1L;
    }

    public void setElasticsearchPropes(Properties elasticsearchPropes) {
        this.elasticsearchPropes = elasticsearchPropes;
    }

    public Properties getExtendElasticsearchPropes() {
        return this.extendElasticsearchPropes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getSliceScrollQueryExecutorService() {
        if (this.sliceScrollQueryExecutorService != null) {
            return this.sliceScrollQueryExecutorService;
        }
        ElasticSearch elasticSearch = this;
        synchronized (elasticSearch) {
            if (this.sliceScrollQueryExecutorService != null) {
                return this.sliceScrollQueryExecutorService;
            }
            if (this.sliceScrollQueryExecutorService == null) {
                this.sliceScrollQueryExecutorService = ThreadPoolFactory.buildSliceScrollThreadPool(this.sliceScrollThreadCount, this.sliceScrollThreadQueue, this.sliceScrollBlockedWaitTimeout);
            }
        }
        return this.sliceScrollQueryExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getScrollQueryExecutorService() {
        if (this.scrollQueryExecutorService != null) {
            return this.scrollQueryExecutorService;
        }
        ElasticSearch elasticSearch = this;
        synchronized (elasticSearch) {
            if (this.scrollQueryExecutorService != null) {
                return this.scrollQueryExecutorService;
            }
            if (this.scrollQueryExecutorService == null) {
                this.scrollQueryExecutorService = ThreadPoolFactory.buildScrollThreadPool(this.scrollThreadCount, this.scrollThreadQueue, this.scrollBlockedWaitTimeout);
            }
        }
        return this.scrollQueryExecutorService;
    }
}

