/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.scroll.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.frameworkset.elasticsearch.scroll.thread.BlockedTaskRejectedExecutionHandler;
import org.frameworkset.elasticsearch.scroll.thread.ESScrollThread;
import org.frameworkset.elasticsearch.scroll.thread.ESSliceScrollThread;

public class ThreadPoolFactory {
    public static ExecutorService buildSliceScrollThreadPool(int sliceScrollThreadCount, int sliceScrollThreadQueue, long sliceScrollBlockedWaitTimeout) {
        ThreadPoolExecutor blockedExecutor = new ThreadPoolExecutor(sliceScrollThreadCount, sliceScrollThreadCount, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(sliceScrollThreadQueue), new ThreadFactory(){
            private AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                int num = this.threadCount.incrementAndGet();
                return new ESSliceScrollThread(r, num);
            }
        }, new BlockedTaskRejectedExecutionHandler("Slice Scroll Query", sliceScrollBlockedWaitTimeout));
        return blockedExecutor;
    }

    public static ExecutorService buildScrollThreadPool(int scrollThreadCount, int scrollThreadQueue, long scrollBlockedWaitTimeout) {
        ThreadPoolExecutor blockedExecutor = new ThreadPoolExecutor(scrollThreadCount, scrollThreadCount, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(scrollThreadQueue), new ThreadFactory(){
            private AtomicInteger threadCount = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                int num = this.threadCount.incrementAndGet();
                return new ESScrollThread(r, num);
            }
        }, new BlockedTaskRejectedExecutionHandler("Scroll Query", scrollBlockedWaitTimeout));
        return blockedExecutor;
    }
}

