/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.serial;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import java.io.IOException;
import java.io.Writer;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.soa.BBossStringWriter;

public class CharEscapeUtil {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected final Writer _writer;
    protected char[] _outputBuffer;
    protected int _outputHead;
    protected int _outputTail;
    protected int _outputEnd;
    protected char[] _entityBuffer;
    protected SerializableString _currentEscape;
    protected char[] _charBuffer;
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;

    public CharEscapeUtil(Writer w, int features) {
        this._writer = w;
        this._outputBuffer = new char[1024];
        this._outputEnd = this._outputBuffer.length;
        if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(features)) {
            this._maximumNonEscapedChar = 127;
        }
    }

    public CharEscapeUtil() {
        this._writer = new BBossStringWriter();
        this._outputBuffer = new char[1024];
        this._outputEnd = this._outputBuffer.length;
    }

    public CharEscapeUtil(Writer w) {
        this._writer = w;
        this._outputBuffer = new char[1024];
        this._outputEnd = this._outputBuffer.length;
    }

    public Object getOutputTarget() {
        return this._writer;
    }

    public int getOutputBuffered() {
        int len = this._outputTail - this._outputHead;
        return Math.max(0, len);
    }

    public boolean canWriteFormattedNumbers() {
        return true;
    }

    public void writeString(String text, boolean flush) {
        try {
            this._writeString(text);
            if (flush) {
                this._flushBuffer();
            }
        }
        catch (IOException e) {
            throw new ElasticSearchException(e);
        }
    }

    public String toString() {
        try {
            this._flushBuffer();
        }
        catch (IOException e) {
            throw new ElasticSearchException(e);
        }
        return this._writer.toString();
    }

    private void _writeSegmentCustom(int end) throws IOException, JsonGenerationException {
        int[] escCodes = this._outputEscapes;
        int maxNonEscaped = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int escLimit = Math.min(escCodes.length, maxNonEscaped + 1);
        CharacterEscapes customEscapes = this._characterEscapes;
        int ptr = 0;
        int escCode = 0;
        int start = ptr;
        while (ptr < end) {
            int c;
            do {
                if ((c = this._outputBuffer[ptr]) < escLimit) {
                    escCode = escCodes[c];
                    if (escCode == 0) continue;
                    break;
                }
                if (c > maxNonEscaped) {
                    escCode = -1;
                    break;
                }
                this._currentEscape = customEscapes.getEscapeSequence(c);
                if (this._currentEscape == null) continue;
                escCode = -2;
                break;
            } while (++ptr < end);
            int flushLen = ptr - start;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, start, flushLen);
                if (ptr >= end) break;
            }
            start = this._prependOrWriteCharacterEscape(this._outputBuffer, ++ptr, end, (char)c, escCode);
        }
    }

    private void _writeLongString(String text) throws IOException {
        int segmentLen;
        this._flushBuffer();
        int textLen = text.length();
        int offset = 0;
        do {
            int max;
            segmentLen = offset + (max = this._outputEnd) > textLen ? textLen - offset : max;
            text.getChars(offset, offset + segmentLen, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(segmentLen);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(segmentLen, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(segmentLen);
        } while ((offset += segmentLen) < textLen);
    }

    private void _writeSegment(int end) throws IOException {
        int ptr;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        int start = ptr = 0;
        while (ptr < end) {
            char c;
            while (((c = this._outputBuffer[ptr]) >= escLen || escCodes[c] == 0) && ++ptr < end) {
            }
            int flushLen = ptr - start;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, start, flushLen);
                if (ptr >= end) break;
            }
            start = this._prependOrWriteCharacterEscape(this._outputBuffer, ++ptr, end, c, escCodes[c]);
        }
    }

    private void _writeSegmentASCII(int end, int maxNonEscaped) throws IOException, JsonGenerationException {
        int[] escCodes = this._outputEscapes;
        int escLimit = Math.min(escCodes.length, maxNonEscaped + 1);
        int ptr = 0;
        int escCode = 0;
        int start = ptr;
        while (ptr < end) {
            char c;
            do {
                if ((c = this._outputBuffer[ptr]) < escLimit) {
                    escCode = escCodes[c];
                    if (escCode == 0) continue;
                    break;
                }
                if (c <= maxNonEscaped) continue;
                escCode = -1;
                break;
            } while (++ptr < end);
            int flushLen = ptr - start;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, start, flushLen);
                if (ptr >= end) break;
            }
            start = this._prependOrWriteCharacterEscape(this._outputBuffer, ++ptr, end, c, escCode);
        }
    }

    public void _writeString(String text) throws IOException {
        int len = text.length();
        if (len > this._outputEnd) {
            this._writeLongString(text);
            return;
        }
        if (this._outputTail + len > this._outputEnd) {
            this._flushBuffer();
        }
        text.getChars(0, len, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(len);
        } else if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(len, this._maximumNonEscapedChar);
        } else {
            this._writeString2(len);
        }
    }

    private void _writeStringASCII(int len, int maxNonEscaped) throws IOException, JsonGenerationException {
        int end = this._outputTail + len;
        int[] escCodes = this._outputEscapes;
        int escLimit = Math.min(escCodes.length, maxNonEscaped + 1);
        int escCode = 0;
        while (this._outputTail < end) {
            char c;
            block5: {
                do {
                    if ((c = this._outputBuffer[this._outputTail]) < escLimit) {
                        escCode = escCodes[c];
                        if (escCode == 0) continue;
                    } else {
                        if (c <= maxNonEscaped) continue;
                        escCode = -1;
                    }
                    break block5;
                } while (++this._outputTail < end);
                break;
            }
            int flushLen = this._outputTail - this._outputHead;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, flushLen);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c, escCode);
        }
    }

    public void _writeString2(int len) throws IOException {
        int end = this._outputTail + len;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        block0: while (this._outputTail < end) {
            char c;
            while ((c = this._outputBuffer[this._outputTail]) >= escLen || escCodes[c] == 0) {
                if (++this._outputTail < end) continue;
                break block0;
            }
            int flushLen = this._outputTail - this._outputHead;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, flushLen);
            }
            char c2 = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c2, escCodes[c2]);
        }
    }

    private void _writeStringCustom(int len) throws IOException, JsonGenerationException {
        int end = this._outputTail + len;
        int[] escCodes = this._outputEscapes;
        int maxNonEscaped = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int escLimit = Math.min(escCodes.length, maxNonEscaped + 1);
        int escCode = 0;
        CharacterEscapes customEscapes = this._characterEscapes;
        while (this._outputTail < end) {
            int c;
            block7: {
                do {
                    if ((c = this._outputBuffer[this._outputTail]) < escLimit) {
                        escCode = escCodes[c];
                        if (escCode == 0) continue;
                    } else if (c > maxNonEscaped) {
                        escCode = -1;
                    } else {
                        this._currentEscape = customEscapes.getEscapeSequence(c);
                        if (this._currentEscape == null) continue;
                        escCode = -2;
                    }
                    break block7;
                } while (++this._outputTail < end);
                break;
            }
            int flushLen = this._outputTail - this._outputHead;
            if (flushLen > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, flushLen);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)c, escCode);
        }
    }

    private void _writeStringCustom(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        len += offset;
        int[] escCodes = this._outputEscapes;
        int maxNonEscaped = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int escLimit = Math.min(escCodes.length, maxNonEscaped + 1);
        CharacterEscapes customEscapes = this._characterEscapes;
        int escCode = 0;
        while (offset < len) {
            int c;
            int start = offset;
            do {
                if ((c = text[offset]) < escLimit) {
                    escCode = escCodes[c];
                    if (escCode == 0) continue;
                    break;
                }
                if (c > maxNonEscaped) {
                    escCode = -1;
                    break;
                }
                this._currentEscape = customEscapes.getEscapeSequence(c);
                if (this._currentEscape == null) continue;
                escCode = -2;
                break;
            } while (++offset < len);
            int newAmount = offset - start;
            if (newAmount < 32) {
                if (this._outputTail + newAmount > this._outputEnd) {
                    this._flushBuffer();
                }
                if (newAmount > 0) {
                    System.arraycopy(text, start, this._outputBuffer, this._outputTail, newAmount);
                    this._outputTail += newAmount;
                }
            } else {
                this._flushBuffer();
                this._writer.write(text, start, newAmount);
            }
            if (offset >= len) break;
            ++offset;
            this._appendCharacterEscape((char)c, escCode);
        }
    }

    protected void _flushBuffer() throws IOException {
        int len = this._outputTail - this._outputHead;
        if (len > 0) {
            int offset = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, offset, len);
        }
    }

    private void _prependOrWriteCharacterEscape(char ch, int escCode) throws IOException, JsonGenerationException {
        String escape;
        if (escCode >= 0) {
            if (this._outputTail >= 2) {
                int ptr;
                this._outputHead = ptr = this._outputTail - 2;
                this._outputBuffer[ptr++] = 92;
                this._outputBuffer[ptr] = (char)escCode;
                return;
            }
            char[] buf = this._entityBuffer;
            if (buf == null) {
                buf = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            buf[1] = (char)escCode;
            this._writer.write(buf, 0, 2);
            return;
        }
        if (escCode != -2) {
            if (this._outputTail >= 6) {
                int ptr;
                char[] buf = this._outputBuffer;
                this._outputHead = ptr = this._outputTail - 6;
                buf[ptr] = 92;
                buf[++ptr] = 117;
                if (ch > '\u00ff') {
                    int hi = ch >> 8 & 0xFF;
                    buf[++ptr] = HEX_CHARS[hi >> 4];
                    buf[++ptr] = HEX_CHARS[hi & 0xF];
                    ch = (char)(ch & 0xFF);
                } else {
                    buf[++ptr] = 48;
                    buf[++ptr] = 48;
                }
                buf[++ptr] = HEX_CHARS[ch >> 4];
                buf[++ptr] = HEX_CHARS[ch & 0xF];
                return;
            }
            char[] buf = this._entityBuffer;
            if (buf == null) {
                buf = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (ch > '\u00ff') {
                int hi = ch >> 8 & 0xFF;
                int lo = ch & 0xFF;
                buf[10] = HEX_CHARS[hi >> 4];
                buf[11] = HEX_CHARS[hi & 0xF];
                buf[12] = HEX_CHARS[lo >> 4];
                buf[13] = HEX_CHARS[lo & 0xF];
                this._writer.write(buf, 8, 6);
            } else {
                buf[6] = HEX_CHARS[ch >> 4];
                buf[7] = HEX_CHARS[ch & 0xF];
                this._writer.write(buf, 2, 6);
            }
            return;
        }
        if (this._currentEscape == null) {
            escape = this._characterEscapes.getEscapeSequence((int)ch).getValue();
        } else {
            escape = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int len = escape.length();
        if (this._outputTail >= len) {
            int ptr;
            this._outputHead = ptr = this._outputTail - len;
            escape.getChars(0, len, this._outputBuffer, ptr);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(escape);
    }

    private int _prependOrWriteCharacterEscape(char[] buffer, int ptr, int end, char ch, int escCode) throws IOException, JsonGenerationException {
        String escape;
        if (escCode >= 0) {
            if (ptr > 1 && ptr < end) {
                buffer[ptr -= 2] = 92;
                buffer[ptr + 1] = (char)escCode;
            } else {
                char[] ent = this._entityBuffer;
                if (ent == null) {
                    ent = this._allocateEntityBuffer();
                }
                ent[1] = (char)escCode;
                this._writer.write(ent, 0, 2);
            }
            return ptr;
        }
        if (escCode != -2) {
            if (ptr > 5 && ptr < end) {
                ptr -= 6;
                buffer[ptr++] = 92;
                buffer[ptr++] = 117;
                if (ch > '\u00ff') {
                    int hi = ch >> 8 & 0xFF;
                    buffer[ptr++] = HEX_CHARS[hi >> 4];
                    buffer[ptr++] = HEX_CHARS[hi & 0xF];
                    ch = (char)(ch & 0xFF);
                } else {
                    buffer[ptr++] = 48;
                    buffer[ptr++] = 48;
                }
                buffer[ptr++] = HEX_CHARS[ch >> 4];
                buffer[ptr] = HEX_CHARS[ch & 0xF];
                ptr -= 5;
            } else {
                char[] ent = this._entityBuffer;
                if (ent == null) {
                    ent = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (ch > '\u00ff') {
                    int hi = ch >> 8 & 0xFF;
                    int lo = ch & 0xFF;
                    ent[10] = HEX_CHARS[hi >> 4];
                    ent[11] = HEX_CHARS[hi & 0xF];
                    ent[12] = HEX_CHARS[lo >> 4];
                    ent[13] = HEX_CHARS[lo & 0xF];
                    this._writer.write(ent, 8, 6);
                } else {
                    ent[6] = HEX_CHARS[ch >> 4];
                    ent[7] = HEX_CHARS[ch & 0xF];
                    this._writer.write(ent, 2, 6);
                }
            }
            return ptr;
        }
        if (this._currentEscape == null) {
            escape = this._characterEscapes.getEscapeSequence((int)ch).getValue();
        } else {
            escape = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int len = escape.length();
        if (ptr >= len && ptr < end) {
            escape.getChars(0, len, buffer, ptr -= len);
        } else {
            this._writer.write(escape);
        }
        return ptr;
    }

    private void _appendCharacterEscape(char ch, int escCode) throws IOException, JsonGenerationException {
        String escape;
        if (escCode >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)escCode;
            return;
        }
        if (escCode != -2) {
            if (this._outputTail + 5 >= this._outputEnd) {
                this._flushBuffer();
            }
            int ptr = this._outputTail;
            char[] buf = this._outputBuffer;
            buf[ptr++] = 92;
            buf[ptr++] = 117;
            if (ch > '\u00ff') {
                int hi = ch >> 8 & 0xFF;
                buf[ptr++] = HEX_CHARS[hi >> 4];
                buf[ptr++] = HEX_CHARS[hi & 0xF];
                ch = (char)(ch & 0xFF);
            } else {
                buf[ptr++] = 48;
                buf[ptr++] = 48;
            }
            buf[ptr++] = HEX_CHARS[ch >> 4];
            buf[ptr++] = HEX_CHARS[ch & 0xF];
            this._outputTail = ptr;
            return;
        }
        if (this._currentEscape == null) {
            escape = this._characterEscapes.getEscapeSequence((int)ch).getValue();
        } else {
            escape = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int len = escape.length();
        if (this._outputTail + len > this._outputEnd) {
            this._flushBuffer();
            if (len > this._outputEnd) {
                this._writer.write(escape);
                return;
            }
        }
        escape.getChars(0, len, this._outputBuffer, this._outputTail);
        this._outputTail += len;
    }

    private char[] _allocateEntityBuffer() {
        char[] buf = new char[14];
        buf[0] = 92;
        buf[2] = 92;
        buf[3] = 117;
        buf[4] = 48;
        buf[5] = 48;
        buf[8] = 92;
        buf[9] = 117;
        this._entityBuffer = buf;
        return buf;
    }
}

