/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.boot;

import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.boot.ElasticsearchBootResult;
import org.frameworkset.elasticsearch.boot.WrapperGetProperties;
import org.frameworkset.spi.DefaultApplicationContext;
import org.frameworkset.spi.assemble.GetProperties;
import org.frameworkset.spi.assemble.PropertiesContainer;
import org.frameworkset.spi.remote.http.ClientConfiguration;

public abstract class ElasticSearchConfigBoot {
    private static boolean inited = false;

    public static ElasticsearchBootResult boot() {
        return ElasticSearchConfigBoot.boot(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElasticsearchBootResult boot(boolean forceBoot) {
        if (inited && !forceBoot) {
            return null;
        }
        ElasticsearchBootResult elasticsearchBootResult = null;
        Class<ElasticSearchConfigBoot> clazz = ElasticSearchConfigBoot.class;
        synchronized (ElasticSearchConfigBoot.class) {
            if (inited && !forceBoot) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            try {
                elasticsearchBootResult = new ElasticsearchBootResult();
                DefaultApplicationContext context = DefaultApplicationContext.getApplicationContext((String)"conf/elasticsearch-boot-config.xml", (boolean)forceBoot);
                String _elasticsearchServerNames = context.getExternalProperty("elasticsearch.serverNames", "default");
                String[] elasticsearchServerNames = _elasticsearchServerNames.split(",");
                WrapperGetProperties getProperties = new WrapperGetProperties((GetProperties)context);
                ClientConfiguration.bootClientConfiguations((String[])elasticsearchServerNames, (GetProperties)getProperties);
                ClientConfiguration.bootHealthCheckClientConfiguations((String[])elasticsearchServerNames, (GetProperties)getProperties);
                List<String> initedElasticsearchs = ElasticSearchHelper.booter(elasticsearchServerNames, (GetProperties)context, forceBoot, false);
                elasticsearchBootResult.setInitedElasticsearchs(initedElasticsearchs);
            }
            finally {
                inited = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return elasticsearchBootResult;
        }
    }

    public static ElasticsearchBootResult boot(Map properties) {
        return ElasticSearchConfigBoot.boot(properties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElasticsearchBootResult boot(Map properties, boolean fromspringboot) {
        PropertiesContainer propertiesContainer = new PropertiesContainer();
        ElasticsearchBootResult elasticsearchBootResult = new ElasticsearchBootResult();
        Class<ElasticSearchConfigBoot> clazz = ElasticSearchConfigBoot.class;
        synchronized (ElasticSearchConfigBoot.class) {
            propertiesContainer.addAll(properties);
            String _elasticsearchServerNames = propertiesContainer.getExternalProperty("elasticsearch.serverNames", "default");
            String[] elasticsearchServerNames = _elasticsearchServerNames.split(",");
            WrapperGetProperties getProperties = new WrapperGetProperties((GetProperties)propertiesContainer);
            ClientConfiguration.bootClientConfiguations((String[])elasticsearchServerNames, (GetProperties)getProperties);
            ClientConfiguration.bootHealthCheckClientConfiguations((String[])elasticsearchServerNames, (GetProperties)getProperties);
            List<String> initedElasticsearchs = ElasticSearchHelper.booter(elasticsearchServerNames, (GetProperties)propertiesContainer, true, fromspringboot);
            elasticsearchBootResult.setInitedElasticsearchs(initedElasticsearchs);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            elasticsearchBootResult.setPropertiesContainer(propertiesContainer);
            return elasticsearchBootResult;
        }
    }
}

