/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.bulk.BulkCommand;
import org.frameworkset.elasticsearch.bulk.BulkConfig;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.bulk.BulkProcessorException;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ClientOptions;
import org.frameworkset.util.concurrent.ThreadPoolFactory;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkProcessor {
    private Logger logger = LoggerFactory.getLogger(BulkProcessor.class);
    private BulkCommand bulkCommand;
    private long lastAppendDataTime = -1L;
    private Lock r = new ReentrantLock();
    private Lock w = new ReentrantLock();
    private BulkConfig bulkConfig;
    private Flush flush;
    private ExecutorService executor;
    private ClientInterface clientInterface;
    private boolean inited;
    private int status;
    private long totalSize = 0L;
    private long failedSize = 0L;

    public BulkConfig getBulkConfig() {
        return this.bulkConfig;
    }

    private BulkCommand buildBulkCommand() {
        return new BulkCommand(this);
    }

    public ClientInterface getClientInterface() {
        return this.clientInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        this.status = 1;
        Flush flush = this.flush;
        synchronized (flush) {
            this.flush.notify();
        }
    }

    public String getRefreshOption() {
        return this.bulkConfig.getRefreshOption();
    }

    public BulkProcessor(BulkConfig bulkConfig) {
        this.bulkConfig = bulkConfig;
    }

    public synchronized void increamentTotalsize(int totalSize) {
        try {
            this.r.lock();
            this.totalSize += (long)totalSize;
        }
        finally {
            this.r.unlock();
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.clientInterface = ElasticSearchHelper.getRestClientUtil(this.bulkConfig.getElasticsearch());
        this.bulkCommand = this.buildBulkCommand();
        this.executor = ThreadPoolFactory.buildThreadPool((String)this.bulkConfig.getBulkProcessorName(), (String)this.bulkConfig.getBulkRejectMessage(), (int)this.bulkConfig.getWorkThreads(), (int)this.bulkConfig.getWorkThreadQueue(), (long)this.bulkConfig.getBlockedWaitTimeout(), (int)this.bulkConfig.getWarnMultsRejects());
        if (this.bulkConfig.getFlushInterval() > 0L) {
            this.flush = new Flush("Elasticsearch[" + (this.bulkConfig.getElasticsearch() != null ? this.bulkConfig.getElasticsearch() : "default") + "]-" + this.bulkConfig.getBulkProcessorName() + "-flush-thread");
            this.flush.start();
        }
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                BulkProcessor.this.shutDown();
            }
        });
    }

    private boolean touchBatchSize() {
        return this.bulkCommand != null && this.bulkCommand.getBulkDataSize() >= this.bulkConfig.getBulkSizes();
    }

    public long getLastAppendDataTime() {
        return this.lastAppendDataTime;
    }

    private void appendBulkData(BulkData bulkData) {
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            this._appendBulkData(bulkData);
        }
        finally {
            this.w.unlock();
        }
    }

    private void _appendBulkData(BulkData bulkData) {
        this.lastAppendDataTime = System.currentTimeMillis();
        this.bulkCommand.addBulkData(bulkData);
        if (this.touchBatchSize()) {
            this.execute(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFlush(long flushInterval) {
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            long interval = System.currentTimeMillis() - this.lastAppendDataTime;
            if (interval > flushInterval && this.bulkCommand.getBulkDataSize() > 0) {
                this.execute(true);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private void forceExecute() {
        try {
            this.w.lock();
            if (this.bulkCommand != null && this.bulkCommand.getBulkDataSize() > 0) {
                this.execute(false);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void insertData(String index, String indexType, Object data, ClientOptions clientOptions) {
        this.assertShutdown();
        BulkData bulkData = new BulkData(0, data);
        bulkData.setIndex(index);
        bulkData.setIndexType(indexType);
        bulkData.setClientOptions(clientOptions);
        this.appendBulkData(bulkData);
    }

    public void insertData(String index, String indexType, Object data) {
        this.assertShutdown();
        BulkData bulkData = new BulkData(0, data);
        bulkData.setIndex(index);
        bulkData.setIndexType(indexType);
        this.appendBulkData(bulkData);
    }

    public void insertData(String index, Object data, ClientOptions clientOptions) {
        this.insertData(index, null, data, clientOptions);
    }

    public void insertData(String index, Object data) {
        this.insertData(index, null, data, null);
    }

    public void updateData(String index, String indexType, Object data, ClientOptions updateOptions) {
        this.assertShutdown();
        BulkData bulkData = new BulkData(1, data);
        bulkData.setIndex(index);
        bulkData.setIndexType(indexType);
        bulkData.setClientOptions(updateOptions);
        this.appendBulkData(bulkData);
    }

    public void updateData(String index, String indexType, Object data) {
        this.assertShutdown();
        BulkData bulkData = new BulkData(1, data);
        bulkData.setIndex(index);
        bulkData.setIndexType(indexType);
        this.appendBulkData(bulkData);
    }

    public void updateData(String index, Object data) {
        this.updateData(index, null, data, null);
    }

    public void updateData(String index, Object data, ClientOptions updateOptions) {
        this.updateData(index, null, data, updateOptions);
    }

    public void deleteData(String index, String indexType, Object data, ClientOptions updateOptions) {
        this.assertShutdown();
        BulkData bulkData = new BulkData(2, data);
        bulkData.setIndex(index);
        bulkData.setIndexType(indexType);
        bulkData.setClientOptions(updateOptions);
        this.appendBulkData(bulkData);
    }

    public void deleteData(String index, String indexType, Object data) {
        this.assertShutdown();
        BulkData bulkData = new BulkData(2, data);
        bulkData.setIndex(index);
        bulkData.setIndexType(indexType);
        this.appendBulkData(bulkData);
    }

    private void execute(boolean initBuilCommand) {
        this.executor.submit(this.bulkCommand);
        this.bulkCommand = initBuilCommand ? this.buildBulkCommand() : null;
    }

    public void deleteDataWithClientOptions(String index, Object data, ClientOptions updateOptions) {
        this.deleteData(index, null, data, updateOptions);
    }

    public void deleteData(String index, Object data) {
        this.deleteData(index, null, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDatas(String index, String indexType, List<?> datas, ClientOptions clientOptions) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                BulkData bulkData = new BulkData(0, data);
                bulkData.setIndex(index);
                bulkData.setIndexType(indexType);
                bulkData.setClientOptions(clientOptions);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDatas(String index, String indexType, List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                BulkData bulkData = new BulkData(0, data);
                bulkData.setIndex(index);
                bulkData.setIndexType(indexType);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void insertDatas(String index, List<?> datas, ClientOptions clientOptions) {
        this.insertDatas(index, null, datas, clientOptions);
    }

    public void insertDatas(String index, List<?> datas) {
        this.insertDatas(index, null, datas, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatas(String index, String indexType, List<?> datas, ClientOptions updateOptions) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                BulkData bulkData = new BulkData(1, data);
                bulkData.setIndex(index);
                bulkData.setIndexType(indexType);
                bulkData.setClientOptions(updateOptions);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatas(String index, String indexType, List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                BulkData bulkData = new BulkData(1, data);
                bulkData.setIndex(index);
                bulkData.setIndexType(indexType);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void updateDatas(String index, List<?> datas) {
        this.updateDatas(index, null, datas, null);
    }

    public void updateDatas(String index, List<?> datas, ClientOptions updateOptions) {
        this.updateDatas(index, null, datas, updateOptions);
    }

    public boolean isShutdown() {
        return this.status == 1;
    }

    public void assertShutdown() {
        if (this.isShutdown()) {
            throw new BulkProcessorException("Bulk processor is Shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatas(String index, String indexType, List<?> datas, ClientOptions updateOptions) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                BulkData bulkData = new BulkData(2, data);
                bulkData.setIndex(index);
                bulkData.setIndexType(indexType);
                bulkData.setClientOptions(updateOptions);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatas(String index, String indexType, List<?> datas) {
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.assertShutdown();
        try {
            this.w.lock();
            if (this.bulkCommand == null) {
                return;
            }
            for (Object data : datas) {
                BulkData bulkData = new BulkData(2, data);
                bulkData.setIndex(index);
                bulkData.setIndexType(indexType);
                this._appendBulkData(bulkData);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public void deleteDatas(String index, List<?> datas, ClientOptions updateOptions) {
        this.deleteDatas(index, null, datas, updateOptions);
    }

    public void deleteDatas(String index, List<?> datas) {
        this.deleteDatas(index, null, datas, null);
    }

    public long getFailedSize() {
        return this.failedSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void increamentFailedSize(int failedSize) {
        try {
            this.r.lock();
            this.failedSize += (long)failedSize;
        }
        finally {
            this.r.unlock();
        }
    }

    public int getBulkSizes() {
        return this.bulkConfig.getBulkSizes();
    }

    public void shutDown() {
        block9: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ShutDown BulkProcessor[{}] begin.....", (Object)this.bulkConfig.getBulkProcessorName());
            }
            this.stop();
            try {
                this.forceExecute();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.executor != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool  begin......");
                    }
                    this.executor.shutdown();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool complete.");
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block9;
                    this.logger.error("ShutDown BulkProcessor[" + this.bulkConfig.getBulkProcessorName() + "] thread executor pool failed:", (Throwable)e);
                }
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ShutDown BulkProcessor[{}] complete.", (Object)this.bulkConfig.getBulkProcessorName());
        }
    }

    class Flush
    extends Thread {
        public Flush(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long flushInterval = BulkProcessor.this.bulkConfig.getFlushInterval();
            try {
                while (true) {
                    Flush flush = this;
                    synchronized (flush) {
                        this.wait(flushInterval);
                    }
                    BulkProcessor.this.forceFlush(flushInterval);
                    if (!BulkProcessor.this.isShutdown()) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
            }
        }
    }
}

