/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.SimpleStringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.IndexNameBuilder;
import org.frameworkset.elasticsearch.bulk.BulkCommand;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.elasticsearch.client.ClientOptions;
import org.frameworkset.elasticsearch.client.ClientUtil;
import org.frameworkset.elasticsearch.client.DateFormats;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.ElasticSearchRestClient;
import org.frameworkset.elasticsearch.client.ExecuteRequestUtil;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.elasticsearch.client.SliceScroll;
import org.frameworkset.elasticsearch.entity.AggHit;
import org.frameworkset.elasticsearch.entity.ClusterSetting;
import org.frameworkset.elasticsearch.entity.ESAggDatas;
import org.frameworkset.elasticsearch.entity.ESDatas;
import org.frameworkset.elasticsearch.entity.ESIndice;
import org.frameworkset.elasticsearch.entity.IndexField;
import org.frameworkset.elasticsearch.entity.IndiceHeader;
import org.frameworkset.elasticsearch.entity.MGetDocs;
import org.frameworkset.elasticsearch.entity.MapRestResponse;
import org.frameworkset.elasticsearch.entity.MapSearchHit;
import org.frameworkset.elasticsearch.entity.MergeOption;
import org.frameworkset.elasticsearch.entity.PitId;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.entity.SearchHit;
import org.frameworkset.elasticsearch.entity.sql.ColumnMeta;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponse;
import org.frameworkset.elasticsearch.entity.sql.SQLRestResponseHandler;
import org.frameworkset.elasticsearch.entity.sql.SQLResult;
import org.frameworkset.elasticsearch.entity.suggest.CompleteElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.entity.suggest.CompleteRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.ElasticSearchPhraseResponseHandler;
import org.frameworkset.elasticsearch.entity.suggest.ElasticSearchTermResponseHandler;
import org.frameworkset.elasticsearch.entity.suggest.PhraseRestResponse;
import org.frameworkset.elasticsearch.entity.suggest.TermRestResponse;
import org.frameworkset.elasticsearch.handler.ESAggBucketHandle;
import org.frameworkset.elasticsearch.handler.ESMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ESPitIdResponseHandler;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchMapResponseHandler;
import org.frameworkset.elasticsearch.handler.ElasticSearchResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentHitResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentResponseHandler;
import org.frameworkset.elasticsearch.handler.GetDocumentSourceResponseHandler;
import org.frameworkset.elasticsearch.handler.MGetDocumentsSourceResponseHandler;
import org.frameworkset.elasticsearch.scroll.BreakableScrollHandler;
import org.frameworkset.elasticsearch.scroll.DefualtScrollHandler;
import org.frameworkset.elasticsearch.scroll.HandlerInfo;
import org.frameworkset.elasticsearch.scroll.ScrollHandler;
import org.frameworkset.elasticsearch.scroll.thread.ScrollTask;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.frameworkset.elasticsearch.serial.SerialUtil;
import org.frameworkset.elasticsearch.template.ESInfo;
import org.frameworkset.json.JsonTypeReference;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestClientUtil
extends ClientUtil {
    private static Logger logger = LoggerFactory.getLogger(AbstractRestClientUtil.class);
    protected ElasticSearchRestClient client;
    protected StringBuilder bulkBuilder;
    protected IndexNameBuilder indexNameBuilder;
    protected String[] monitorIndices = new String[]{".monitoring*", ".triggered_watches", ".watcher-history*", ".ml*", ".kibana_*"};
    protected String monitorIndicesString = ".monitoring*,.triggered_watches,.watcher-history*,.ml*,.kibana_*";

    public AbstractRestClientUtil(ElasticSearchClient client, IndexNameBuilder indexNameBuilder) {
        this.client = (ElasticSearchRestClient)client;
        this.indexNameBuilder = indexNameBuilder;
    }

    @Override
    public ElasticSearchRestClient getClient() {
        return this.client;
    }

    @Override
    public IndexNameBuilder getIndexNameBuilder() {
        return this.indexNameBuilder;
    }

    @Override
    public String getElasticsearchName() {
        return this.client.getElasticsearchName();
    }

    @Override
    public ElasticSearch getElasticSearch() {
        return this.client.getElasticSearch();
    }

    @Override
    public String getCurrentDateString() {
        return this.indexNameBuilder.getCurrentDateString();
    }

    @Override
    public String getDateString(Date date) {
        return this.indexNameBuilder.getDateString(date);
    }

    @Override
    public List<IndexField> getIndexMappingFields(String index, final String indexType) throws ElasticSearchException {
        try {
            final ArrayList<IndexField> fields = new ArrayList<IndexField>();
            this.getIndexMapping(index, false, new ResponseHandler<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        try (InputStream inputStream = null;){
                            inputStream = entity.getContent();
                            if (ResponseUtil.entityEmpty((HttpEntity)entity, (InputStream)inputStream)) {
                                Void void_ = null;
                                return void_;
                            }
                            if (!AbstractRestClientUtil.this.client.isUpper7()) {
                                Map map = (Map)SimpleStringUtil.json2ObjectWithType((InputStream)inputStream, (JsonTypeReference)new JsonTypeReference<Map<String, Object>>(){});
                                Iterator entries = map.entrySet().iterator();
                                if (entries.hasNext()) {
                                    Map.Entry entry = entries.next();
                                    Map mapping = (Map)entry.getValue();
                                    Map typeProperties = (Map)((Map)mapping.get("mappings")).get(indexType);
                                    Map properties = (Map)typeProperties.get("properties");
                                    for (Map.Entry<String, Object> entry2 : properties.entrySet()) {
                                        IndexField indexField = BuildTool.buildIndexField(entry2, fields, null);
                                    }
                                }
                            } else {
                                Map map = (Map)SimpleStringUtil.json2ObjectWithType((InputStream)inputStream, (JsonTypeReference)new JsonTypeReference<Map<String, Object>>(){});
                                Iterator entries = map.entrySet().iterator();
                                if (entries.hasNext()) {
                                    Map.Entry entry = entries.next();
                                    Map index = (Map)entry.getValue();
                                    Map mapping = (Map)index.get("mappings");
                                    Map properties = (Map)mapping.get("properties");
                                    for (Map.Entry<String, Object> entry3 : properties.entrySet()) {
                                        IndexField indexField = BuildTool.buildIndexField(entry3, fields, null);
                                    }
                                }
                            }
                        }
                        return null;
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        throw new ElasticSearchException("Unexpected response : " + EntityUtils.toString((HttpEntity)entity), status);
                    }
                    throw new ElasticSearchException("Unexpected response status: " + status, status);
                }
            });
            return fields;
        }
        catch (ElasticSearchException e) {
            return (List)ResultUtil.hand404HttpRuntimeException(e, Object.class, 4);
        }
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateDocuments(String indexName, String indexType, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getDynamicIndexName(String indexName) {
        return this.indexNameBuilder.getIndexName(indexName);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, refreshOption);
    }

    @Override
    public String addDateDocumentWithId(String indexName, String indexType, Object bean, Object docId) throws ElasticSearchException {
        return this.addDocumentWithId(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId);
    }

    @Override
    public String addDateDocumentWithId(String indexName, String indexType, Object bean, Object docId, Object parentId) throws ElasticSearchException {
        return this.addDocumentWithId(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId, parentId);
    }

    @Override
    public String addDateDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId) throws ElasticSearchException {
        return this.addDocumentWithId(this.indexNameBuilder.getIndexName(indexName), indexType, bean, null, parentId);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, Object docId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId, refreshOption);
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, Object docId, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, docId, parentId, refreshOption);
    }

    @Override
    public String addDateDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, null, parentId, refreshOption);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, (String)null);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<?> beans, String refreshOption) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        ClientOptions clientOptions = null;
        if (refreshOption != null) {
            clientOptions = new ClientOptions();
            clientOptions.setRefreshOption(refreshOption);
        }
        return this.addDocuments(indexName, indexType, beans, clientOptions);
    }

    @Override
    public String addDateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.addDocumentsWithIdKey(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, docIdKey, null, refreshOption);
    }

    @Override
    public String addDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, docIdKey, (String)null);
    }

    @Override
    public String addDateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.addDocumentsWithIdKey(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey, parentIdKey);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdKey, parentIdKey, refreshOption);
    }

    public String addDateMapDocuments(String indexName, String indexType, List<Map> beans, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addMapDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, clientOptions);
    }

    public String addMapDocuments(String indexName, String indexType, List<Map> beans, ClientOptions clientOptions) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Map bean : beans) {
            BulkData bulkData = new BulkData(0, bean);
            bulkData.setIndexType(indexType);
            bulkData.setIndex(indexName);
            bulkData.setClientOptions(clientOptions);
            try {
                BuildTool.evalBuilk((Writer)writer, bulkData, this.client.isUpper7());
            }
            catch (IOException e) {
                throw new ElasticSearchException("evalBuilk addMapDocuments failed", e);
            }
        }
        writer.flush();
        return this.client.executeHttp(BuildTool.buildActionUrl(clientOptions, ""), builder.toString(), "post");
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setIdField(docIdKey);
        clientOptions.setParentIdField(parentIdKey);
        clientOptions.setRefreshOption(refreshOption);
        return this.addDocuments(indexName, indexType, beans, clientOptions);
    }

    @Override
    public String addDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.addDocuments(indexName, indexType, beans, docIdKey, parentIdKey, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, (String)null);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean, String refreshOption) throws ElasticSearchException {
        ClientOptions clientOptions = null;
        if (refreshOption != null) {
            clientOptions = new ClientOptions();
            clientOptions.setRefreshOption(refreshOption);
        }
        return this.addDocument(indexName, indexType, bean, clientOptions);
    }

    @Override
    public String addDocumentWithId(String indexName, String indexType, Object bean, Object docId) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, docId, null);
    }

    @Override
    public String addDocumentWithId(String indexName, String indexType, Object bean, Object docId, Object parentId) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, docId, parentId, null);
    }

    @Override
    public String addDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, null, parentId, null);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean, Object docId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, docId, null, refreshOption);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object bean, Object docId, Object parentId, String refreshOption) throws ElasticSearchException {
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setId(docId);
        clientOptions.setParentId(parentId);
        clientOptions.setRefreshOption(refreshOption);
        return this.addDocument(indexName, indexType, bean, clientOptions);
    }

    @Override
    public String addDocument(String indexName, String indexType, Object params, ClientOptions clientOptions) throws ElasticSearchException {
        String path = BuildTool.buildAddPathUrlMeta(indexName, indexType, params, clientOptions, ClassUtil.getClassInfo(params.getClass()));
        path = this.client.executeHttp(path, SerialUtil.object2json(params), "post");
        return path;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, Object bean, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, clientOptions);
    }

    @Override
    public String addMapDocument(String indexName, String indexType, Map params, ClientOptions clientOptions) throws ElasticSearchException {
        Object docId = null;
        Object parentId = null;
        Object routing = null;
        String refreshOption = null;
        if (clientOptions != null) {
            refreshOption = clientOptions.getRefreshOption();
            docId = clientOptions.getIdField() != null ? params.get(clientOptions.getIdField()) : null;
            Object v0 = parentId = clientOptions.getParentIdField() != null ? params.get(clientOptions.getParentIdField()) : null;
            routing = clientOptions.getRouting() == null ? (clientOptions.getRoutingField() != null ? params.get(clientOptions.getRoutingField()) : null) : clientOptions.getRouting();
        }
        return this.addDocument(indexName, indexType, params, docId, parentId, routing, refreshOption);
    }

    @Override
    public String addMapDocument(String indexName, String indexType, Map bean) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, null, null, null, null);
    }

    @Override
    public String addDateMapDocument(String indexName, String indexType, Map bean) throws ElasticSearchException {
        return this.addDocument(this.indexNameBuilder.getIndexName(indexName), indexType, bean, null, null, null, null);
    }

    @Override
    public String addDateMapDocument(String indexName, String indexType, Map params, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addMapDocument(this.indexNameBuilder.getIndexName(indexName), indexType, params, clientOptions);
    }

    public String addDocument(String indexName, String indexType, Object bean, Object docId, Object parentId, Object routing, String refreshOption) throws ElasticSearchException {
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setRefreshOption(refreshOption);
        clientOptions.setId(docId);
        clientOptions.setParentId(parentId);
        clientOptions.setRouting(routing);
        return this.addDocument(indexName, indexType, bean, clientOptions);
    }

    @Override
    public String addDocumentWithParentId(String indexName, String indexType, Object bean, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, indexType, bean, null, parentId, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, (String)null);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<?> beans, String refreshOption) throws ElasticSearchException {
        ClientOptions clientOptions = null;
        if (refreshOption != null) {
            clientOptions = new ClientOptions();
            clientOptions.setRefreshOption(refreshOption);
        }
        return this.updateDocuments(indexName, indexType, beans, clientOptions);
    }

    @Override
    public String updateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, docIdKey, (String)null);
    }

    @Override
    public String updateDocumentsWithIdKey(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, docIdKey, parentIdKey);
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, indexType, beans, docIdKey, null, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, String indexType, List<?> beans, ClientOptions clientOptions) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Object bean : beans) {
            try {
                BulkData bulkData = new BulkData(0, bean);
                bulkData.setIndex(indexName);
                bulkData.setIndexType(indexType);
                bulkData.setClientOptions(clientOptions);
                BuildTool.evalBuilk((Writer)writer, bulkData, this.client.isUpper7());
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        return this.client.executeHttp(BuildTool.buildActionUrl(clientOptions, ""), builder.toString(), "post");
    }

    @Override
    public String deleteDocumentsWithrefreshOption(String indexName, String indexType, String refreshOption, String[] ids) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        if (!this.client.isUpper7()) {
            for (String id : ids) {
                builder.append("{ \"delete\" : { \"_index\" : \"").append(indexName).append("\", \"_type\" : \"").append(indexType).append("\", \"_id\" : \"").append(id).append("\" } }\n");
            }
        } else {
            for (String id : ids) {
                builder.append("{ \"delete\" : { \"_index\" : \"").append(indexName).append("\", \"_id\" : \"").append(id).append("\" } }\n");
            }
        }
        return this.client.executeHttp("_bulk?" + refreshOption, builder.toString(), "post");
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<?> beans, ClientOptions clientOptions) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (Object bean : beans) {
            try {
                BulkData bulkData = new BulkData(1, bean);
                bulkData.setIndex(indexName);
                bulkData.setIndexType(indexType);
                bulkData.setClientOptions(clientOptions);
                BuildTool.evalBuilk((Writer)writer, bulkData, this.client.isUpper7());
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        writer.flush();
        return this.client.executeHttp(BuildTool.buildActionUrl(clientOptions, ""), builder.toString(), "post");
    }

    @Override
    public String updateDocument(String index, String indexType, Object params, ClientOptions updateOptions) throws ElasticSearchException {
        Object detect_noop = null;
        Object doc_as_upsert = null;
        ClassUtil.ClassInfo beanClassInfo = ClassUtil.getClassInfo(params.getClass());
        Boolean returnSource = null;
        List<String> sourceUpdateExcludes = null;
        List<String> sourceUpdateIncludes = null;
        if (updateOptions != null) {
            if (updateOptions.getDetectNoop() != null) {
                detect_noop = updateOptions.getDetectNoop();
            } else {
                Object object = detect_noop = updateOptions.getDetectNoopField() != null ? BuildTool.getFieldValue(params, beanClassInfo, updateOptions.getDetectNoopField()) : null;
            }
            doc_as_upsert = updateOptions.getDocasupsert() != null ? updateOptions.getDocasupsert() : (updateOptions.getDocasupsertField() != null ? BuildTool.getRouting(params, beanClassInfo, updateOptions.getDocasupsertField()) : BuildTool.getEsDocAsUpsert(params, beanClassInfo));
            returnSource = updateOptions.getReturnSource();
            sourceUpdateExcludes = updateOptions.getSourceUpdateExcludes();
            sourceUpdateIncludes = updateOptions.getSourceUpdateIncludes();
        } else {
            doc_as_upsert = BuildTool.getEsDocAsUpsert(params, beanClassInfo);
        }
        String path = BuildTool.buildUpdatePathUrlMeta(index, indexType, params, updateOptions, beanClassInfo, this.client.isUpper7());
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"doc\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(params, (Writer)writer);
        if (detect_noop != null) {
            builder.append(",\"detect_noop\":").append(detect_noop);
        }
        if (doc_as_upsert != null) {
            builder.append(",\"doc_as_upsert\":").append(doc_as_upsert);
        }
        if (returnSource != null) {
            builder.append(",\"_source\":").append(String.valueOf(returnSource));
        }
        if (sourceUpdateExcludes != null && !this.client.isUpper7()) {
            builder.append(",\"_source_excludes\":");
            SerialUtil.object2json(sourceUpdateExcludes, (Writer)writer);
        }
        if (sourceUpdateIncludes != null && !this.client.isUpper7()) {
            builder.append(",\"_source_includes\":");
            SerialUtil.object2json(sourceUpdateIncludes, (Writer)writer);
        }
        builder.append("}");
        try {
            String searchResult = this.client.executeHttp(path, builder.toString(), "post");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeBulk(BulkCommand bulkCommand) {
        List<BulkData> bulkDatas = bulkCommand.getBatchBulkDatas();
        if (bulkDatas == null || bulkDatas.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        try {
            for (BulkData bulkData : bulkDatas) {
                try {
                    BuildTool.evalBuilk((Writer)writer, bulkData, this.client.isUpper7());
                }
                catch (IOException e) {
                    throw new ElasticSearchException(e);
                }
            }
            writer.flush();
            String string = this.client.executeHttp(BuildTool.buildActionUrl(bulkCommand.getBulkProcessor().getBulkConfig(), ""), builder.toString(), "post");
            return string;
        }
        finally {
            builder.setLength(0);
            builder = null;
            writer = null;
        }
    }

    @Override
    public String updateDocuments(String indexName, String indexType, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setIdField(docIdKey);
        clientOptions.setParentIdField(parentIdKey);
        clientOptions.setRefreshOption(refreshOption);
        return this.updateDocuments(indexName, indexType, beans, clientOptions);
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocument(String indexName, String indexType, String addTemplate, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeRequest(String path) throws ElasticSearchException {
        return this.executeRequest(path, null);
    }

    @Override
    public String deleteDocuments(String indexName, String indexType, String[] ids) throws ElasticSearchException {
        return this.deleteDocuments(indexName, indexType, ids, null);
    }

    @Override
    public Map getClusterInfo() {
        return this.client.getClusterInfo();
    }

    @Override
    public String getElasticsearchVersion() {
        return this.client.getEsVersion();
    }

    @Override
    public String deleteDocuments(String indexName, String indexType, String[] ids, ClientOptions clientOptions) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = new BBossStringWriter(builder);
        for (String id : ids) {
            BulkData bulkData = new BulkData(2, id);
            bulkData.setIndexType(indexType);
            bulkData.setIndex(indexName);
            bulkData.setClientOptions(clientOptions);
            try {
                BuildTool.evalBuilk((Writer)writer, bulkData, this.client.isUpper7());
            }
            catch (IOException e) {
                throw new ElasticSearchException("evalBuilk deleteDocuments failed:docid[" + id + "]", e);
            }
        }
        writer.flush();
        return this.client.executeHttp(BuildTool.buildActionUrl(clientOptions, ""), builder.toString(), "post");
    }

    @Override
    public String deleteByQuery(String path, String entity) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, "post");
    }

    @Override
    public String deleteByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String deleteByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String deleteTempate(String template) throws ElasticSearchException {
        try {
            return this.client.executeHttp("/_template/" + template, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 8);
        }
    }

    @Override
    public String getTempate(String template) throws ElasticSearchException {
        try {
            return this.client.executeHttp("/_template/" + template, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 3);
        }
    }

    @Override
    public String getTempate() throws ElasticSearchException {
        return this.client.executeHttp("/_template", "get");
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans) throws ElasticSearchException {
        return null;
    }

    @Override
    public String addDocuments(String indexName, String indexType, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getDocument(String indexName, String indexType, String documentId, Map<String, Object> options) throws ElasticSearchException {
        try {
            return this.client.executeHttp(BuildTool.buildGetDocumentRequest(indexName, indexType, documentId, options), "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 0);
        }
    }

    @Override
    public <T> T getDocumentByFieldLike(String indexName, String fieldName, Object fieldValue, Class<T> type) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, null);
        String dsl = BuildTool.matchByFieldValueDsl(fieldName, fieldValue);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public String getDocumentByFieldLike(String indexName, String fieldName, Object fieldValue) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, null);
        String dsl = BuildTool.matchByFieldValueDsl(fieldName, fieldValue);
        return this.client.executeRequest(actionUrl, dsl);
    }

    @Override
    public <T> T getDocumentByFieldLike(String indexName, String fieldName, Object fieldValue, Class<T> type, Map<String, Object> options) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, options);
        String dsl = BuildTool.matchByFieldValueDsl(fieldName, fieldValue);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public String getDocumentByFieldLike(String indexName, String fieldName, Object fieldValue, Map<String, Object> options) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, options);
        String dsl = BuildTool.matchByFieldValueDsl(fieldName, fieldValue);
        return this.client.executeRequest(actionUrl, dsl);
    }

    @Override
    public <T> T getDocumentByField(String indexName, String fieldName, Object fieldValue, Class<T> type) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, null);
        String dsl = BuildTool.findByFieldValueDsl(fieldName, fieldValue);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public <T> ESDatas<T> searchListByField(String indexName, String fieldName, Object fieldValue, Class<T> type, int from, int size) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, null);
        String dsl = BuildTool.findByFieldValueDsl(fieldName, fieldValue, from, size);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public <T> ESDatas<T> searchListByField(String indexName, String fieldName, Object value, Class<T> type, int from, int size, Map<String, Object> options) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, options);
        String dsl = BuildTool.findByFieldValueDsl(fieldName, value, from, size);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public <T> ESDatas<T> searchListByFieldLike(String indexName, String fieldName, Object value, Class<T> type, int from, int size) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, null);
        String dsl = BuildTool.matchByFieldValueDsl(fieldName, value, from, size);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public <T> ESDatas<T> searchListByFieldLike(String indexName, String fieldName, Object value, Class<T> type, int from, int size, Map<String, Object> options) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, options);
        String dsl = BuildTool.matchByFieldValueDsl(fieldName, value, from, size);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public String getDocumentByField(String indexName, String fieldName, Object fieldValue) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, null);
        String dsl = BuildTool.findByFieldValueDsl(fieldName, fieldValue);
        return this.client.executeRequest(actionUrl, dsl);
    }

    @Override
    public <T> T getDocumentByField(String indexName, String fieldName, Object fieldValue, Class<T> type, Map<String, Object> options) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, options);
        String dsl = BuildTool.findByFieldValueDsl(fieldName, fieldValue);
        RestResponse result = (RestResponse)this.client.executeRequest(actionUrl, dsl, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public String getDocumentByField(String indexName, String fieldName, Object fieldValue, Map<String, Object> options) throws ElasticSearchException {
        String actionUrl = BuildTool.buildSearchDocumentRequest(indexName, null, options);
        String dsl = BuildTool.findByFieldValueDsl(fieldName, fieldValue);
        return this.client.executeRequest(actionUrl, dsl);
    }

    @Override
    public String getDocumentByPath(String path) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 0);
        }
    }

    @Override
    public String getDocumentSource(String path) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 0);
        }
    }

    @Override
    public <T> T getDocumentByPath(String path, Class<T> beanType) throws ElasticSearchException {
        try {
            SearchHit searchResult = (SearchHit)this.client.executeRequest(path, (String)null, new GetDocumentResponseHandler(beanType), "get");
            return ResultUtil.buildObject(searchResult, beanType);
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, beanType, 0);
        }
    }

    @Override
    public <T> T getDocumentSource(String path, Class<T> beanType) throws ElasticSearchException {
        try {
            Object searchResult = this.client.executeRequest(path, (String)null, new GetDocumentSourceResponseHandler(beanType), "get");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, beanType, 0);
        }
    }

    @Override
    public String getDocument(String indexName, String indexType, String documentId) throws ElasticSearchException {
        return this.getDocument(indexName, indexType, documentId, (Map<String, Object>)null);
    }

    @Override
    public <T> T getDocument(String indexName, String indexType, String documentId, Class<T> beanType) throws ElasticSearchException {
        return this.getDocument(indexName, indexType, documentId, null, beanType);
    }

    @Override
    public <T> T getDocument(String indexName, String indexType, String documentId, Map<String, Object> options, Class<T> beanType) throws ElasticSearchException {
        try {
            SearchHit searchResult = (SearchHit)this.client.executeRequest(BuildTool.buildGetDocumentRequest(indexName, indexType, documentId, options), (String)null, new GetDocumentResponseHandler(beanType), "get");
            return ResultUtil.buildObject(searchResult, beanType);
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, beanType, 0);
        }
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String entity, Class<T> type) throws ElasticSearchException {
        MGetDocs searchResult = (MGetDocs)this.client.executeRequest(path, entity, new MGetDocumentsSourceResponseHandler((Class)type), "post");
        return ResultUtil.buildObjects(searchResult, type);
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> mgetDocuments(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String indexType, String documentId, Map<String, Object> options) throws ElasticSearchException {
        try {
            MapSearchHit searchResult = (MapSearchHit)this.client.executeRequest(BuildTool.buildGetDocumentRequest(indexName, indexType, documentId, options), (String)null, new GetDocumentHitResponseHandler(), "get");
            return searchResult;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, MapSearchHit.class, 0);
        }
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String indexType, String documentId) throws ElasticSearchException {
        return this.getDocumentHit(indexName, indexType, documentId, null);
    }

    @Override
    public String deleteDocument(String indexName, String indexType, String id) throws ElasticSearchException {
        try {
            return this.client.executeHttp(indexName + "/" + indexType + "/" + id, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 2);
        }
    }

    @Override
    public String deleteDocument(String indexName, String indexType, String id, String refreshOption) throws ElasticSearchException {
        try {
            if (refreshOption == null || refreshOption.equals("")) {
                return this.deleteDocument(indexName, indexType, id);
            }
            return this.client.executeHttp(indexName + "/" + indexType + "/" + id + "?" + refreshOption, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 2);
        }
    }

    @Override
    public String executeRequest(String path, String entity) throws ElasticSearchException {
        return this.client.executeRequest(path, entity);
    }

    @Override
    public <T> T executeRequest(String path, String entity, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeRequest(path, entity, responseHandler);
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String entity, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String entity, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> sql(Class<T> beanType, String entity) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", entity, new SQLRestResponseHandler());
        return ResultUtil.buildSQLResult(result, beanType);
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String entity, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String entity, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> SQLResult<T> fetchQuery(Class<T> beanType, String entity) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", entity, new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, (SQLResult)null);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String entity, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String entity, Object bean) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T sqlObject(Class<T> beanType, String entity) throws ElasticSearchException {
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", entity, new SQLRestResponseHandler());
        return ResultUtil.buildSQLObject(result, beanType);
    }

    @Override
    public String closeSQLCursor(String cursor) throws ElasticSearchException {
        return (String)this.client.executeRequest("/_xpack/sql/close", "{\"cursor\": \"" + cursor + "\"}", new ESStringResponseHandler(), "post");
    }

    @Override
    public <T> SQLResult<T> fetchQueryByCursor(Class<T> beanType, SQLResult<T> oldPage) throws ElasticSearchException {
        if (oldPage.getCursor() == null) {
            return null;
        }
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", "{\"cursor\": \"" + oldPage.getCursor() + "\"}", new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, oldPage);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public <T> SQLResult<T> fetchQueryByCursor(Class<T> beanType, String cursor, ColumnMeta[] metas) throws ElasticSearchException {
        if (cursor == null) {
            return null;
        }
        SQLRestResponse result = (SQLRestResponse)this.client.executeRequest("/_xpack/sql", "{\"cursor\": \"" + cursor + "\"}", new SQLRestResponseHandler());
        SQLResult<T> datas = ResultUtil.buildFetchSQLResult(result, beanType, metas);
        datas.setClientInterface(this);
        return datas;
    }

    @Override
    public String executeHttp(String path, String action) throws ElasticSearchException {
        return this.client.executeHttp(path, action);
    }

    @Override
    public String executeHttp(String path, String entity, String action) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, action);
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeHttp(String path, String entity, Map params, String action) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, Object bean, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public String executeHttp(String path, String entity, Object bean, String action) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeHttp(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeHttp(path, action, responseHandler);
    }

    @Override
    public <T> T discover(String path, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.discover(path, action, responseHandler);
    }

    @Override
    public <T> T executeHttp(String path, String entity, String action, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, action, responseHandler);
    }

    @Override
    public String getIndexMapping(String index) throws ElasticSearchException {
        return this.getIndexMapping(index, true);
    }

    @Override
    public <T> T getIndexMapping(String index, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return this.getIndexMapping(index, true, responseHandler);
    }

    @Override
    public String getIndexMapping(String index, boolean pretty) throws ElasticSearchException {
        try {
            if (pretty) {
                return this.client.executeHttp(index + "/_mapping?pretty", "get");
            }
            return this.client.executeHttp(index + "/_mapping", "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 4);
        }
    }

    @Override
    public <T> T getIndexMapping(String index, boolean pretty, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        try {
            if (pretty) {
                return this.client.executeRequest(index + "/_mapping?pretty", null, responseHandler, "get");
            }
            return this.client.executeRequest(index + "/_mapping", null, responseHandler, "get");
        }
        catch (ElasticSearchException e) {
            return (T)ResultUtil.hand404HttpRuntimeException(e, Object.class, 4);
        }
    }

    @Override
    public String deleteByPath(String path) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 2);
        }
    }

    @Override
    public boolean existIndice(String indiceName) throws ElasticSearchException {
        try {
            this.executeHttp(indiceName, "head");
            return true;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, Boolean.TYPE, 5);
        }
    }

    @Override
    public boolean existIndiceType(String indiceName, String type) throws ElasticSearchException {
        try {
            this.executeHttp(indiceName + "/_mapping/" + type, "head");
            return true;
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, Boolean.TYPE, 6);
        }
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Map params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T executeRequest(String path, String templateName, Object params, ResponseHandler<T> responseHandler) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public MapRestResponse search(String path, String entity) throws ElasticSearchException {
        MapRestResponse searchResult = (MapRestResponse)this.client.executeRequest(path, entity, new ElasticSearchMapResponseHandler());
        return searchResult;
    }

    @Override
    public long count(String index, String entity) throws ElasticSearchException {
        MapRestResponse searchResult = (MapRestResponse)this.client.executeRequest(index + "/_count", entity, new ElasticSearchMapResponseHandler());
        return searchResult.getCount();
    }

    @Override
    public long count(String index, String template, Map params) throws ElasticSearchException {
        throw new ElasticSearchException("Un implements method");
    }

    @Override
    public long count(String index, String template, Object params) throws ElasticSearchException {
        throw new ElasticSearchException("Un implements method");
    }

    @Override
    public long countAll(String index) throws ElasticSearchException {
        String queryAll = "{\"query\": {\"match_all\": {}}}";
        MapRestResponse searchResult = (MapRestResponse)this.client.executeRequest(index + "/_count", queryAll, new ElasticSearchMapResponseHandler());
        return searchResult.getCount();
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, Class<T> type) throws ElasticSearchException {
        return this.searchAll(index, 5000, type);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, int fetchSize, Class<T> type) throws ElasticSearchException {
        return this.searchAll(index, fetchSize, null, type);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, int fetchSize, ScrollHandler<T> scrollHandler, Class<T> type) throws ElasticSearchException {
        StringBuilder builder = new StringBuilder();
        String queryAll = builder.append("{ \"size\":").append(fetchSize).append(",\"query\": {\"match_all\": {}},\"sort\": [\"_doc\"]}").toString();
        builder.setLength(0);
        return this.scroll(builder.append(index).append("/_search").toString(), queryAll, "10m", type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> searchAll(String index, ScrollHandler<T> scrollHandler, Class<T> type) throws ElasticSearchException {
        return this.searchAll(index, 5000, scrollHandler, type);
    }

    @Override
    public <T> ESDatas<T> searchAllParallel(String index, int fetchSize, Class<T> type, int thread) throws ElasticSearchException {
        return this.searchAllParallel(index, fetchSize, null, type, thread);
    }

    @Override
    public <T> ESDatas<T> searchAllParallel(String index, Class<T> type, int thread) throws ElasticSearchException {
        return this.searchAllParallel(index, 5000, type, thread);
    }

    @Override
    public <T> ESDatas<T> searchAllParallel(String index, final int fetchSize, ScrollHandler<T> scrollHandler, Class<T> type, int max) throws ElasticSearchException {
        if (!this.client.isLower5()) {
            SliceScroll sliceScroll = new SliceScroll(){

                @Override
                public String buildSliceDsl(int sliceId, int max) {
                    StringBuilder builder = new StringBuilder();
                    String sliceDsl = builder.append("{\"slice\": {\"id\": ").append(sliceId).append(",\"max\": ").append(max).append("},\"size\":").append(fetchSize).append(",\"query\": {\"match_all\": {}},\"sort\": [\"_doc\"]}").toString();
                    return sliceDsl;
                }
            };
            return ExecuteRequestUtil._slice(this, index + "/_search", scrollHandler, type, max, "10m", sliceScroll);
        }
        StringBuilder builder = new StringBuilder();
        String queryAll = builder.append("{ \"size\":").append(fetchSize).append(",\"query\": {\"match_all\": {}},\"sort\": [\"_doc\"]}").toString();
        builder.setLength(0);
        return this.scrollParallel(builder.append(index).append("/_search").toString(), queryAll, "10m", type, scrollHandler);
    }

    @Override
    public <T> ESDatas<T> searchAllParallel(String index, ScrollHandler<T> scrollHandler, Class<T> type, int thread) throws ElasticSearchException {
        return this.searchAllParallel(index, 5000, scrollHandler, type, thread);
    }

    @Override
    public TermRestResponse termSuggest(String path, String entity) throws ElasticSearchException {
        TermRestResponse searchResult = (TermRestResponse)this.client.executeRequest(path, entity, new ElasticSearchTermResponseHandler());
        return searchResult;
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String entity) throws ElasticSearchException {
        PhraseRestResponse searchResult = (PhraseRestResponse)this.client.executeRequest(path, entity, new ElasticSearchPhraseResponseHandler());
        return searchResult;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String entity, Class<?> type) throws ElasticSearchException {
        RestResponse searchResult = (RestResponse)this.client.executeRequest(path, entity, new CompleteElasticSearchResponseHandler(type));
        return (CompleteRestResponse)searchResult;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String entity) throws ElasticSearchException {
        RestResponse searchResult = (RestResponse)this.client.executeRequest(path, entity, new CompleteElasticSearchResponseHandler(Map.class));
        return (CompleteRestResponse)searchResult;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public TermRestResponse termSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public PhraseRestResponse phraseSuggest(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public CompleteRestResponse complateSuggest(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, Class<?> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String entity, Class<?> type) throws ElasticSearchException {
        RestResponse searchResult = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return searchResult;
    }

    @Override
    public <T> ESDatas<T> searchScroll(String scroll, String scrollId, Class<T> type) throws ElasticSearchException {
        if (!this.client.isV1()) {
            StringBuilder entity = new StringBuilder();
            entity.append("{\"scroll\" : \"").append(scroll).append("\",\"scroll_id\" : \"").append(scrollId).append("\"}");
            RestResponse result = (RestResponse)this.client.executeRequest("_search/scroll", entity.toString(), new ElasticSearchResponseHandler(type));
            return ResultUtil.buildESDatas(result, type);
        }
        StringBuilder path = new StringBuilder();
        path.append("_search/scroll?scroll=").append(scroll).append("&scroll_id=").append(scrollId);
        RestResponse result = (RestResponse)this.client.executeHttp(path.toString(), "get", new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public String searchScroll(String scroll, String scrollId) throws ElasticSearchException {
        if (!this.client.isV1()) {
            StringBuilder entity = new StringBuilder();
            entity.append("{\"scroll\" : \"").append(scroll).append("\",\"scroll_id\" : \"").append(scrollId).append("\"}");
            String result = this.client.executeHttp("_search/scroll", entity.toString(), "post");
            return result;
        }
        StringBuilder path = new StringBuilder();
        path.append("_search/scroll?scroll=").append(scroll).append("&scroll_id=").append(scrollId);
        String result = this.client.executeHttp(path.toString(), "get");
        return result;
    }

    @Override
    public String deleteScrolls(String[] scrollIds) throws ElasticSearchException {
        return ExecuteRequestUtil.deleteScrolls(this.getClient(), scrollIds);
    }

    @Override
    public String deleteScrolls(List<String> scrollIds) throws ElasticSearchException {
        return ExecuteRequestUtil.deleteScrolls(this.getClient(), scrollIds);
    }

    @Override
    public String deleteScrolls(Set<String> scrollIds) throws ElasticSearchException {
        return ExecuteRequestUtil.deleteScrolls(this.getClient(), scrollIds);
    }

    @Override
    public String deleteAllScrolls() throws ElasticSearchException {
        String result = this.client.executeHttp("_search/scroll/_all", "delete");
        return result;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> ESDatas<T> searchList(String path, String entity, Class<T> type) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public <T> ESDatas<T> searchList(String path, Class<T> type) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, (String)null, new ElasticSearchResponseHandler(type), "get");
        return ResultUtil.buildESDatas(result, type);
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scrollParallel(String path, String dslTemplate, String scroll, Map params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String entity, String scroll, Class<T> type) throws ElasticSearchException {
        return this.scroll(path, entity, scroll, type, (ScrollHandler)null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> ESDatas<T> scrollParallel(String path, String entity, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        ESDatas<T> eSDatas;
        block22: {
            ArrayList<Future> tasks = null;
            try {
                path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
                RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
                ESDatas<T> response = ResultUtil.buildESDatas(result, type);
                int taskId = 0;
                boolean useDefaultScrollHandler = false;
                ExecutorService executorService = this.client.getScrollQueryExecutorService();
                List datas = response.getDatas();
                Object scrollTask = null;
                BreakableScrollHandler breakedScrollHandler = null;
                if (scrollHandler == null) {
                    scrollHandler = new DefualtScrollHandler<T>(response);
                    useDefaultScrollHandler = true;
                } else {
                    if (scrollHandler instanceof BreakableScrollHandler) {
                        breakedScrollHandler = (BreakableScrollHandler)((Object)scrollHandler);
                    }
                    if (datas != null && datas.size() > 0) {
                        tasks = new ArrayList<Future>();
                        HandlerInfo handlerInfo = new HandlerInfo();
                        handlerInfo.setTaskId(taskId);
                        ++taskId;
                        this.runScrollTask(tasks, scrollHandler, response, handlerInfo, executorService);
                    }
                }
                TreeSet<String> scrollIds = null;
                String scrollId = response.getScrollId();
                if (scrollId != null) {
                    scrollIds = new TreeSet<String>();
                    scrollIds.add(scrollId);
                }
                if (datas != null && datas.size() > 0) {
                    ESDatas<T> _response = null;
                    List _datas = null;
                    while (breakedScrollHandler == null || !breakedScrollHandler.isBreaked()) {
                        _response = this.searchScroll(scroll, scrollId, type);
                        String _scrollId = _response.getScrollId();
                        if (scrollId != null) {
                            scrollIds.add(_scrollId);
                        }
                        if ((_datas = _response.getDatas()) == null || _datas.size() == 0) break;
                        HandlerInfo handlerInfo = new HandlerInfo();
                        handlerInfo.setTaskId(taskId);
                        handlerInfo.setScrollId(scrollId);
                        ++taskId;
                        if (!useDefaultScrollHandler) {
                            ++taskId;
                            this.runScrollTask(tasks, scrollHandler, _response, handlerInfo, executorService);
                        } else {
                            scrollHandler.handle(_response, handlerInfo);
                        }
                        scrollId = _scrollId;
                    }
                }
                if (tasks != null && tasks.size() > 0) {
                    ExecuteRequestUtil.waitTasksComplete(tasks);
                }
                if (scrollIds != null && scrollIds.size() > 0) {
                    try {
                        this.deleteScrolls(scrollIds);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!useDefaultScrollHandler) {
                    response.setDatas(null);
                }
                eSDatas = response;
                if (tasks == null) break block22;
            }
            catch (ElasticSearchException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new ElasticSearchException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (tasks != null && tasks.size() > 0) {
                        ExecuteRequestUtil.waitTasksComplete((List<Future>)tasks);
                    }
                    throw throwable;
                }
            }
            if (tasks.size() > 0) {
                ExecuteRequestUtil.waitTasksComplete(tasks);
            }
        }
        return eSDatas;
    }

    @Override
    public String forcemerge(String indices) {
        String result = this.client.executeHttp(indices + "/_forcemerge", "post");
        return result;
    }

    @Override
    public String forcemerge(String indices, MergeOption mergeOption) {
        StringBuilder action = new StringBuilder().append(indices).append("/_forcemerge");
        if (mergeOption != null) {
            boolean seted = false;
            if (mergeOption.getMaxnumSegments() != null) {
                seted = true;
                action.append("?max_num_segments=").append(mergeOption.getMaxnumSegments());
            }
            if (mergeOption.getFlush() != null) {
                if (seted) {
                    action.append("&");
                } else {
                    seted = true;
                    action.append("?");
                }
                action.append("flush=").append(mergeOption.getFlush());
            }
            if (mergeOption.getOnlyExpungeDeletes() != null) {
                if (seted) {
                    action.append("&");
                } else {
                    action.append("?");
                }
                action.append("only_expunge_deletes=").append(mergeOption.getOnlyExpungeDeletes());
            }
        }
        String result = this.client.executeHttp(action.toString(), "post");
        return result;
    }

    @Override
    public String forcemerge() {
        String result = this.client.executeHttp("/_forcemerge", "post");
        return result;
    }

    @Override
    public String forcemerge(MergeOption mergeOption) {
        StringBuilder action = new StringBuilder().append("/_forcemerge");
        if (mergeOption != null) {
            boolean seted = false;
            if (mergeOption.getMaxnumSegments() != null) {
                seted = true;
                action.append("?max_num_segments=").append(mergeOption.getMaxnumSegments());
            }
            if (mergeOption.getFlush() != null) {
                if (seted) {
                    action.append("&");
                } else {
                    seted = true;
                    action.append("?");
                }
                action.append("flush=").append(mergeOption.getFlush());
            }
            if (mergeOption.getOnlyExpungeDeletes() != null) {
                if (seted) {
                    action.append("&");
                } else {
                    action.append("?");
                }
                action.append("only_expunge_deletes=").append(mergeOption.getOnlyExpungeDeletes());
            }
        }
        String result = this.client.executeHttp(action.toString(), "post");
        return result;
    }

    public <T> void runScrollTask(List<Future> tasks, ScrollHandler<T> _scrollHandler, ESDatas<T> sliceResponse, HandlerInfo handlerInfo, ExecutorService executorService) {
        ScrollTask<T> scrollTask = new ScrollTask<T>(_scrollHandler, sliceResponse, handlerInfo);
        tasks.add(executorService.submit(scrollTask));
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String entity, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        try {
            path = path.indexOf(63) < 0 ? path + "?scroll=" + scroll : path + "&scroll=" + scroll;
            RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
            ESDatas<T> response = ResultUtil.buildESDatas(result, type);
            int taskId = 0;
            boolean useDefaultScrollHandler = false;
            BreakableScrollHandler breakedScrollHandler = null;
            if (scrollHandler == null) {
                scrollHandler = new DefualtScrollHandler<T>(response);
                useDefaultScrollHandler = true;
            } else {
                if (scrollHandler instanceof BreakableScrollHandler) {
                    breakedScrollHandler = (BreakableScrollHandler)((Object)scrollHandler);
                }
                HandlerInfo handlerInfo = new HandlerInfo();
                handlerInfo.setTaskId(taskId);
                ++taskId;
                scrollHandler.handle(response, handlerInfo);
            }
            List datas = response.getDatas();
            TreeSet<String> scrollIds = null;
            String scrollId = response.getScrollId();
            if (scrollId != null) {
                scrollIds = new TreeSet<String>();
                scrollIds.add(scrollId);
            }
            if (datas != null && datas.size() > 0) {
                ESDatas<T> _response = null;
                List _datas = null;
                while (breakedScrollHandler == null || !breakedScrollHandler.isBreaked()) {
                    _response = this.searchScroll(scroll, scrollId, type);
                    String _scrollId = _response.getScrollId();
                    if (scrollId != null) {
                        scrollIds.add(_scrollId);
                    }
                    if ((_datas = _response.getDatas()) == null || _datas.size() == 0) break;
                    HandlerInfo handlerInfo = new HandlerInfo();
                    handlerInfo.setTaskId(taskId);
                    handlerInfo.setScrollId(scrollId);
                    ++taskId;
                    scrollHandler.handle(_response, handlerInfo);
                    scrollId = _scrollId;
                }
            }
            if (scrollIds != null && scrollIds.size() > 0) {
                try {
                    this.deleteScrolls(scrollIds);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!useDefaultScrollHandler) {
                response.setDatas(null);
            }
            return response;
        }
        catch (ElasticSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ElasticSearchException(e);
        }
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scrollSliceParallel(String path, String dslTemplate, Map params, String scroll, Class<T> type) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scrollSliceParallel(String path, String dslTemplate, Map params, String scroll, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scrollParallel(String path, String dslTemplate, String scroll, Object params, Class<T> type, ScrollHandler<T> scrollHandler) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ESDatas<T> scroll(String path, String dslTemplate, String scroll, Object params, Class<T> type) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Object params, int max, String scroll, Class<T> type, ScrollHandler<T> scrollHandler, boolean parallel) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    public <T> ESDatas<T> scrollSlice(String path, String dslTemplate, Object params, int max, String scroll, Class<T> type, boolean parallel) throws ElasticSearchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T searchObject(String path, String templateName, Map params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T searchObject(String path, String templateName, Object params, Class<T> type) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> T searchObject(String path, String entity, Class<T> type) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler(type));
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public <T> T searchObject(String path, Class<T> type) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, (String)null, new ElasticSearchResponseHandler(type), "get");
        return ResultUtil.buildObject(result, type);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, String stats) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return ResultUtil.buildESAggDatas(result, type, aggs, stats, null);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, String stats, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return ResultUtil.buildESAggDatas(result, type, aggs, stats, aggBucketHandle);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Map params, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Object params, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return ResultUtil.buildESAggDatas(result, type, aggs, null, null);
    }

    @Override
    public <T extends AggHit> ESAggDatas<T> searchAgg(String path, String entity, Class<T> type, String aggs, ESAggBucketHandle<T> aggBucketHandle) throws ElasticSearchException {
        RestResponse result = (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler());
        return ResultUtil.buildESAggDatas(result, type, aggs, null, aggBucketHandle);
    }

    @Override
    public String createTempate(String template, String entity) throws ElasticSearchException {
        return this.client.executeHttp("_template/" + this.handleIndexName(template), entity, "put");
    }

    @Override
    public String createTempate(String template, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createTempate(String template, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Map params, ESTypeReferences type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String templateName, Object params, ESTypeReferences type) throws ElasticSearchException {
        return null;
    }

    @Override
    public RestResponse search(String path, String entity, ESTypeReferences type) throws ElasticSearchException {
        return (RestResponse)this.client.executeRequest(path, entity, new ElasticSearchResponseHandler((ESTypeReferences<?, ?>)type));
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Map<String, Object> searchMap(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public Map<String, Object> searchMap(String path, String entity) throws ElasticSearchException {
        return (Map)this.client.executeRequest(path, entity, new ESMapResponseHandler());
    }

    @Override
    public String dropIndice(String index) throws ElasticSearchException {
        try {
            return this.client.executeHttp(index + "?pretty", "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 7);
        }
    }

    @Override
    public String updateIndiceMapping(String action, String indexMapping) throws ElasticSearchException {
        try {
            return this.client.executeHttp(this.handleIndexName(action), indexMapping, "put");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 9);
        }
    }

    @Override
    public String createIndiceMapping(String indexName, String indexMapping) throws ElasticSearchException {
        return this.client.executeHttp(this.handleIndexName(indexName), indexMapping, "put");
    }

    private String handleIndexName(String indexName) {
        if (this.client.isUpper7() && this.client.getElasticSearch().isIncludeTypeName()) {
            if (indexName.indexOf("include_type_name=") > 0) {
                return indexName;
            }
            StringBuilder ret = new StringBuilder();
            if (indexName.indexOf("?") > 0) {
                ret.append(indexName).append("&include_type_name=true");
            } else {
                ret.append(indexName).append("?include_type_name=true");
            }
            return ret.toString();
        }
        return indexName;
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Object parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Object parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateIndiceMapping(String action, String templateName, Map parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String createIndiceMapping(String indexName, String templateName, Map parameter) throws ElasticSearchException {
        return null;
    }

    @Override
    public String getIndice(String index) throws ElasticSearchException {
        return this.getIndexMapping(index, true);
    }

    @Override
    public List<ESIndice> getIndexes() throws ElasticSearchException {
        String data = this.client.executeHttp("_cat/indices?v", "get");
        if (logger.isDebugEnabled()) {
            logger.debug(data);
        }
        if (SimpleStringUtil.isNotEmpty((String)data)) {
            try {
                List<ESIndice> indices = this.extractIndice(data);
                return indices;
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        return null;
    }

    @Override
    public List<ESIndice> getIndexes(String indicePattern) throws ElasticSearchException {
        String data = this.client.executeHttp("_cat/indices/" + indicePattern + "?v", "get");
        if (logger.isDebugEnabled()) {
            logger.debug(data);
        }
        if (SimpleStringUtil.isNotEmpty((String)data)) {
            try {
                List<ESIndice> indices = this.extractIndice(data);
                return indices;
            }
            catch (IOException e) {
                throw new ElasticSearchException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ESIndice> extractIndice(String data) throws IOException {
        StringReader reader = null;
        BufferedReader br = null;
        try {
            String line;
            reader = new StringReader(data);
            br = new BufferedReader(reader);
            ArrayList<ESIndice> indices = new ArrayList<ESIndice>();
            int i = 0;
            SimpleDateFormat dayDateFormat = new SimpleDateFormat(this.client.getDayDateFormat());
            SimpleDateFormat monthDateFormat = new SimpleDateFormat(this.client.getMonthDateFormat());
            SimpleDateFormat yearDateFormat = new SimpleDateFormat(this.client.getYearDateFormat());
            DateFormats dateFormats = new DateFormats();
            dateFormats.setDayDateFormat(dayDateFormat);
            dateFormats.setMonthDateFormat(monthDateFormat);
            dateFormats.setYearDateFormat(yearDateFormat);
            List<IndiceHeader> indiceHeaderList = null;
            while ((line = br.readLine()) != null) {
                if (i == 0) {
                    indiceHeaderList = BuildTool.buildListIndiceHeaders(line);
                    ++i;
                    continue;
                }
                ESIndice esIndice = BuildTool.buildESIndice(line, dateFormats, indiceHeaderList);
                indices.add(esIndice);
            }
            ArrayList<ESIndice> arrayList = indices;
            return arrayList;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String refreshIndexInterval(String indexName, int interval) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/_settings", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"   } }", "put");
    }

    @Override
    public String refreshIndexInterval(String indexName, String indexType, int interval) throws ElasticSearchException {
        return this.client.executeHttp(indexName + "/" + indexType + "/_settings", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
    }

    @Override
    public String refreshIndexInterval(int interval, boolean preserveExisting) throws ElasticSearchException {
        if (preserveExisting) {
            return this.client.executeHttp("_all/_settings?preserve_existing=true", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
        }
        return this.client.executeHttp("_all/_settings?preserve_existing=false", "{  \"index\" : {  \"refresh_interval\" : \"" + interval + "s\"    } }", "put");
    }

    @Override
    public String refreshIndexInterval(int interval) throws ElasticSearchException {
        return this.refreshIndexInterval(interval, false);
    }

    @Override
    public String cleanAllXPackIndices() throws ElasticSearchException {
        StringBuilder ret = new StringBuilder();
        for (String monitor : this.monitorIndices) {
            try {
                ret.append(this.client.executeHttp(URLEncoder.encode(monitor, "UTF-8") + "?pretty", "delete")).append("\n");
            }
            catch (Exception e) {
                ret.append(e.getMessage()).append("\n");
            }
        }
        return ret.toString();
    }

    @Override
    public String updateByPath(String path, String entity) throws ElasticSearchException {
        try {
            return this.client.executeHttp(path, entity, "post");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 1);
        }
    }

    @Override
    public String updateByPath(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateByPath(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateByQuery(String path) throws ElasticSearchException {
        return this.client.executeHttp(path, "post");
    }

    @Override
    public String updateByQuery(String path, String entity) throws ElasticSearchException {
        return this.client.executeHttp(path, entity, "post");
    }

    @Override
    public String updateByQuery(String path, String templateName, Map params) throws ElasticSearchException {
        return null;
    }

    @Override
    public String updateByQuery(String path, String templateName, Object params) throws ElasticSearchException {
        return null;
    }

    @Override
    public <T> List<T> mgetDocuments(String index, String indexType, Class<T> type, Object ... ids) throws ElasticSearchException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (indexType == null || indexType.equals("")) {
            path.append(index).append("/_mget");
        } else {
            path.append(index).append("/").append(indexType).append("/_mget");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"ids\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(ids, (Writer)writer);
        builder.append("}");
        MGetDocs searchResult = (MGetDocs)this.client.executeRequest(path.toString(), builder.toString(), new MGetDocumentsSourceResponseHandler((Class)type), "post");
        return ResultUtil.buildObjects(searchResult, type);
    }

    @Override
    public String mgetDocuments(String index, String indexType, Object ... ids) throws ElasticSearchException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        if (indexType == null || indexType.equals("")) {
            path.append(index).append("/_mget");
        } else {
            path.append(index).append("/").append(indexType).append("/_mget");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {\"ids\":");
        BBossStringWriter writer = new BBossStringWriter(builder);
        SerialUtil.object2json(ids, (Writer)writer);
        builder.append("}");
        String searchResult = this.client.executeHttp(path.toString(), builder.toString(), "post");
        return searchResult;
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params, String refreshOption) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, refreshOption, (Boolean)null, (Boolean)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params, String refreshOption) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, refreshOption, (Boolean)null, (Boolean)null);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, indexType, id, params, (String)null, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Map params, String refreshOption, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setId(id);
        clientOptions.setRefreshOption(refreshOption);
        clientOptions.setDetectNoop(detect_noop);
        clientOptions.setDocasupsert(doc_as_upsert);
        return this.updateDocument(index, indexType, (Object)params, clientOptions);
    }

    @Override
    public String updateDocument(String index, String indexType, Object id, Object params, String refreshOption, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setId(id);
        clientOptions.setRefreshOption(refreshOption);
        clientOptions.setDetectNoop(detect_noop);
        clientOptions.setDocasupsert(doc_as_upsert);
        return this.updateDocument(index, indexType, params, clientOptions);
    }

    @Override
    public String reindex(String sourceIndice, String destIndice) {
        String reindex = "{\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\"}}";
        return this.client.executeHttp("_reindex", reindex, "post");
    }

    @Override
    public String reindexByDsl(String actionUrl, String dslName, Object params) {
        throw new UnsupportedOperationException("reindexByDsl(String actionUrl,String dslName,Object params)");
    }

    @Override
    public String reindexByDsl(String actionUrl, String dsl) {
        return this.client.executeHttp(actionUrl, dsl, "post");
    }

    @Override
    public String reindex(String sourceIndice, String destIndice, String versionType) {
        String reindex = "{\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\",\"version_type\": \"" + versionType + "\"}}";
        return this.client.executeHttp("_reindex", reindex, "post");
    }

    @Override
    public String reindex(String sourceIndice, String destIndice, String opType, String conflicts) {
        if (conflicts == null || conflicts.equals("")) {
            String reindex = "{\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\",\"op_type\": \"" + opType + "\"}}";
            return this.client.executeHttp("_reindex", reindex, "post");
        }
        String reindex = "{\"conflicts\": \"" + conflicts + "\",\"source\": {\"index\": \"" + sourceIndice + "\"},\"dest\": {\"index\": \"" + destIndice + "\",\"op_type\": \"" + opType + "\"}}";
        return this.client.executeHttp("_reindex", reindex, "post");
    }

    @Override
    public String addAlias(String indice, String alias) {
        String aliasJson = "{\"actions\": [{\"add\": {\"index\":\"" + indice + "\",\"alias\": \"" + alias + "\"}}]}";
        return this.client.executeHttp("_aliases", aliasJson, "post");
    }

    @Override
    public String removeAlias(String indice, String alias) {
        String removeAlias = "{\"actions\": [{\"remove\": {\"index\":\"" + indice + "\",\"alias\": \"" + alias + "\"}}]}";
        return this.client.executeHttp("_aliases", removeAlias, "post");
    }

    @Override
    public ESInfo getESInfo(String templateName) {
        return null;
    }

    @Override
    public String closeIndex(String index) {
        String closeIndex = "/" + index + "/_close";
        return this.client.executeHttp(closeIndex, "post");
    }

    @Override
    public String openIndex(String index) {
        String closeIndex = "/" + index + "/_open";
        return this.client.executeHttp(closeIndex, "post");
    }

    @Override
    public String getClusterSettings() {
        return this.getClusterSettings(true);
    }

    @Override
    public String getClusterSettings(boolean includeDefault) {
        if (includeDefault) {
            return this.client.executeHttp("/_cluster/settings?include_defaults=true", "get");
        }
        return this.client.executeHttp("/_cluster/settings", "get");
    }

    @Override
    public String getIndiceSetting(String indice) {
        return this.getIndiceSetting(indice, null);
    }

    @Override
    public String getIndiceSetting(String indice, String params) {
        StringBuilder builder = new StringBuilder().append(indice).append("/_settings");
        if (params != null && params.length() > 0) {
            builder.append("?").append(params);
        }
        return this.client.executeHttp(builder.toString(), "get");
    }

    @Override
    public String getIndiceSettingByName(String indice, String settingName) {
        StringBuilder builder = new StringBuilder().append(indice).append("/_settings");
        if (settingName != null && settingName.length() > 0) {
            builder.append("/").append(settingName);
        }
        return this.client.executeHttp(builder.toString(), "get");
    }

    @Override
    public String unassignedNodeLeftDelayedTimeout(String indice, String delayedTimeout) {
        StringBuilder builder = new StringBuilder().append(indice).append("/_settings");
        StringBuilder updateDsl = new StringBuilder();
        updateDsl.append("{").append("\"settings\":{").append("\"index.unassigned.node_left.delayed_timeout\":\"").append(delayedTimeout).append("\"}}");
        return this.client.executeHttp(builder.toString(), updateDsl.toString(), "put");
    }

    @Override
    public String updateNumberOfReplicas(String indice, int numberOfReplicas) {
        StringBuilder builder = new StringBuilder().append(indice).append("/_settings");
        StringBuilder updateDsl = new StringBuilder();
        updateDsl.append("{").append("\"settings\":{").append("\"index.number_of_replicas\":").append(numberOfReplicas).append("}}");
        return this.client.executeHttp(builder.toString(), updateDsl.toString(), "put");
    }

    @Override
    public String updateNumberOfReplicas(int numberOfReplicas) {
        StringBuilder updateDsl = new StringBuilder();
        updateDsl.append("{").append("\"settings\":{").append("\"index.number_of_replicas\":").append(numberOfReplicas).append("}}");
        return this.client.executeHttp("_all/_settings", updateDsl.toString(), "put");
    }

    @Override
    public String updateAllIndicesSettings(Map<String, Object> settings) {
        if (settings == null || settings.size() == 0) {
            return "";
        }
        return this._updateIndiceSettings("_all/_settings", settings);
    }

    @Override
    public String updateIndiceSettings(String indice, Map<String, Object> settings) {
        if (settings == null || settings.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder().append(indice).append("/_settings");
        return this._updateIndiceSettings(builder.toString(), settings);
    }

    public String _updateIndiceSettings(String path, Map<String, Object> settings) {
        if (settings == null || settings.size() == 0) {
            return "";
        }
        StringBuilder updateDsl = new StringBuilder();
        updateDsl.append("{").append("\"settings\":{");
        Iterator<Map.Entry<String, Object>> iterator = settings.entrySet().iterator();
        boolean seted = false;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (seted) {
                updateDsl.append(",");
            } else {
                seted = true;
            }
            Object value = entry.getValue();
            updateDsl.append("\"").append(entry.getKey()).append("\":");
            if (value == null) {
                updateDsl.append("null");
                continue;
            }
            if (value instanceof String) {
                updateDsl.append("\"").append(value).append("\"");
                continue;
            }
            updateDsl.append(value);
        }
        updateDsl.append("}}");
        return this.client.executeHttp(path, updateDsl.toString(), "put");
    }

    public String _updateIndiceSetting(String path, String key, Object value) {
        StringBuilder updateDsl = new StringBuilder();
        updateDsl.append("{").append("\"settings\":{");
        updateDsl.append("\"").append(key).append("\":");
        if (value == null) {
            updateDsl.append("null");
        } else if (value instanceof String) {
            updateDsl.append("\"").append(value).append("\"");
        } else {
            updateDsl.append(value);
        }
        updateDsl.append("}}");
        return this.client.executeHttp(path, updateDsl.toString(), "put");
    }

    @Override
    public String updateAllIndicesSetting(String key, Object value) {
        return this._updateIndiceSetting("_all/_settings", key, value);
    }

    @Override
    public String updateIndiceSetting(String indice, String key, Object value) {
        StringBuilder builder = new StringBuilder().append(indice).append("/_settings");
        return this._updateIndiceSetting(builder.toString(), key, value);
    }

    @Override
    public String unassignedNodeLeftDelayedTimeout(String delayedTimeout) {
        StringBuilder updateDsl = new StringBuilder();
        updateDsl.append("{").append("\"settings\":{").append("\"index.unassigned.node_left.delayed_timeout\":\"").append(delayedTimeout).append("\"}}");
        return this.client.executeHttp("_all/_settings", updateDsl.toString(), "put");
    }

    @Override
    public String addDateDocumentsWithIdOptions(String indexName, String indexType, List<Object> beans, String docIdField, String refreshOption) throws ElasticSearchException {
        return this.addDocumentsWithIdField(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdField, refreshOption);
    }

    @Override
    public String addDateDocumentsWithIdField(String indexName, String indexType, List<Object> beans, String docIdField) throws ElasticSearchException {
        return this.addDocumentsWithIdField(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdField);
    }

    @Override
    public String addDocumentsWithIdField(String indexName, String indexType, List<Object> beans, String docIdField, String refreshOption) throws ElasticSearchException {
        return this.addDocumentsWithIdField(indexName, indexType, beans, docIdField, null, refreshOption);
    }

    @Override
    public String addDocumentsWithIdField(String indexName, String indexType, List<Object> beans, String docIdField) throws ElasticSearchException {
        return this.addDocumentsWithIdField(indexName, indexType, beans, docIdField, null, null);
    }

    @Override
    public String addDateDocumentsWithIdField(String indexName, String indexType, List<Object> beans, String docIdField, String parentIdField, String refreshOption) throws ElasticSearchException {
        return this.addDocumentsWithIdField(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdField, parentIdField, refreshOption);
    }

    @Override
    public String addDateDocumentsWithIdField(String indexName, String indexType, List<Object> beans, String docIdField, String parentIdField) throws ElasticSearchException {
        return this.addDocumentsWithIdParentField(this.indexNameBuilder.getIndexName(indexName), indexType, beans, docIdField, parentIdField);
    }

    @Override
    public String addDateDocuments(String indexName, String indexType, List<?> beans, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDocuments(this.indexNameBuilder.getIndexName(indexName), indexType, beans, clientOptions);
    }

    @Override
    public String addDocumentsWithIdField(String indexName, String indexType, List<Object> beans, String docIdField, String parentIdField, String refreshOption) throws ElasticSearchException {
        if (beans == null || beans.size() == 0) {
            return null;
        }
        ClientOptions clientOptions = new ClientOptions();
        clientOptions.setIdField(docIdField);
        clientOptions.setParentIdField(parentIdField);
        clientOptions.setRefreshOption(refreshOption);
        return this.addDocuments(indexName, indexType, beans, clientOptions);
    }

    @Override
    public String addDocumentsWithIdParentField(String indexName, String indexType, List<Object> beans, String docIdField, String parentIdField) throws ElasticSearchException {
        return this.addDocumentsWithIdField(indexName, indexType, beans, docIdField, parentIdField, null);
    }

    @Override
    public String updateClusterSetting(ClusterSetting clusterSetting) {
        StringBuilder updateDsl = new StringBuilder();
        if (clusterSetting.isPersistent()) {
            updateDsl.append("{").append("\"persistent\":{");
        } else {
            updateDsl.append("{").append("\"transient\":{");
        }
        updateDsl.append("\"").append(clusterSetting.getKey()).append("\":");
        if (clusterSetting.getValue() == null) {
            updateDsl.append("null");
        } else if (clusterSetting.getValue() instanceof String) {
            updateDsl.append("\"").append(clusterSetting.getValue()).append("\"");
        } else {
            updateDsl.append(clusterSetting.getValue());
        }
        updateDsl.append("}}");
        return this.client.executeHttp("_cluster/settings", updateDsl.toString(), "put");
    }

    @Override
    public String updateClusterSettings(List<ClusterSetting> clusterSettings) {
        if (clusterSettings == null || clusterSettings.size() == 0) {
            return "";
        }
        StringBuilder updateDsl = new StringBuilder();
        StringBuilder persistentDsl = new StringBuilder();
        StringBuilder transientDsl = new StringBuilder();
        boolean persistentSet = false;
        boolean transientSet = false;
        updateDsl.append("{");
        for (int i = 0; i < clusterSettings.size(); ++i) {
            ClusterSetting clusterSetting = clusterSettings.get(i);
            if (clusterSetting.isPersistent()) {
                if (!persistentSet) {
                    persistentSet = true;
                    persistentDsl.append("\"persistent\":{");
                } else {
                    persistentDsl.append(",");
                }
                persistentDsl.append("\"").append(clusterSetting.getKey()).append("\":");
                if (clusterSetting.getValue() == null) {
                    persistentDsl.append("null");
                    continue;
                }
                if (clusterSetting.getValue() instanceof String) {
                    persistentDsl.append("\"").append(clusterSetting.getValue()).append("\"");
                    continue;
                }
                persistentDsl.append(clusterSetting.getValue());
                continue;
            }
            if (!transientSet) {
                transientSet = true;
                transientDsl.append("\"transient\":{");
            } else {
                transientDsl.append(",");
            }
            transientDsl.append("\"").append(clusterSetting.getKey()).append("\":");
            if (clusterSetting.getValue() == null) {
                transientDsl.append("null");
                continue;
            }
            if (clusterSetting.getValue() instanceof String) {
                transientDsl.append("\"").append(clusterSetting.getValue()).append("\"");
                continue;
            }
            transientDsl.append(clusterSetting.getValue());
        }
        if (persistentDsl.length() > 0) {
            persistentDsl.append("}");
            updateDsl.append(persistentDsl.toString());
        }
        if (transientDsl.length() > 0 && persistentDsl.length() > 0) {
            updateDsl.append(",");
        }
        if (transientDsl.length() > 0) {
            transientDsl.append("}");
            updateDsl.append(transientDsl.toString());
        }
        updateDsl.append("}");
        return this.client.executeHttp("_cluster/settings", updateDsl.toString(), "put");
    }

    @Override
    public String disableClusterRoutingAllocation() {
        ClusterSetting clusterSetting = new ClusterSetting();
        clusterSetting.setPersistent(true);
        clusterSetting.setKey("cluster.routing.allocation.enable");
        clusterSetting.setValue((Object)"none");
        return this.updateClusterSetting(clusterSetting);
    }

    @Override
    public String enableClusterRoutingAllocation() {
        ClusterSetting clusterSetting = new ClusterSetting();
        clusterSetting.setPersistent(true);
        clusterSetting.setKey("cluster.routing.allocation.enable");
        clusterSetting.setValue(null);
        return this.updateClusterSetting(clusterSetting);
    }

    @Override
    public String flushSynced() {
        if (this.client.isUpper8()) {
            return this.client.executeHttp("_flush", "post");
        }
        return this.client.executeHttp("_flush/synced", "post");
    }

    @Override
    public String flushSynced(String indice) {
        if (this.client.isUpper8()) {
            return this.client.executeHttp(indice + "/_flush", "post");
        }
        return this.client.executeHttp(indice + "/_flush/synced", "post");
    }

    @Override
    public String addDocumentWithParentId(String indexName, Object bean, Object parentId) throws ElasticSearchException {
        return this.addDocumentWithParentId(indexName, "_doc", bean, parentId);
    }

    @Override
    public String addDocumentWithParentId(String indexName, Object bean, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocumentWithParentId(indexName, "_doc", bean, parentId, refreshOption);
    }

    @Override
    public String addDateDocumentWithParentId(String indexName, Object bean, Object parentId) throws ElasticSearchException {
        return this.addDateDocumentWithParentId(indexName, "_doc", bean, parentId);
    }

    @Override
    public String addDateDocumentWithParentId(String indexName, Object bean, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDateDocumentWithParentId(indexName, "_doc", bean, parentId, refreshOption);
    }

    @Override
    public String updateDocument(String index, Object id, Map params) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params);
    }

    @Override
    public String updateDocument(String index, Object id, Object params) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params);
    }

    @Override
    public String updateDocument(String index, Object id, Map params, String refreshOption) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params, refreshOption);
    }

    @Override
    public String updateDocument(String index, Object id, Object params, String refreshOption) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params, refreshOption);
    }

    @Override
    public String deleteDocuments(String indexName, String[] ids) throws ElasticSearchException {
        return this.deleteDocuments(indexName, null, ids);
    }

    @Override
    public String deleteDocumentsWithrefreshOption(String indexName, String refreshOption, String[] ids) throws ElasticSearchException {
        return this.deleteDocumentsWithrefreshOption(indexName, null, refreshOption, ids);
    }

    @Override
    public List<IndexField> getIndexMappingFields(String index) throws ElasticSearchException {
        return this.getIndexMappingFields(index, null);
    }

    @Override
    public String addDocumentsNew(String indexName, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", addTemplate, beans, refreshOption);
    }

    @Override
    public String addDocumentsNew(String indexName, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", addTemplate, beans);
    }

    @Override
    public String addDocumentNew(String indexName, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", addTemplate, bean);
    }

    @Override
    public String addDocumentNew(String indexName, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", addTemplate, bean, refreshOption);
    }

    @Override
    public String updateDocumentsNew(String indexName, String updateTemplate, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, "_doc", updateTemplate, beans);
    }

    @Override
    public String updateDocumentsNew(String indexName, String updateTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, "_doc", updateTemplate, beans, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", beans, refreshOption);
    }

    @Override
    public String addDocuments(String indexName, List<?> beans) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", beans);
    }

    @Override
    public String addDocument(String indexName, Object bean) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", bean);
    }

    @Override
    public String addDocument(String indexName, Object bean, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", bean, clientOptions);
    }

    @Override
    public String addDateDocument(String indexName, Object bean, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", bean, clientOptions);
    }

    @Override
    public String addMapDocument(String indexName, Map bean, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDateMapDocument(indexName, "_doc", bean, clientOptions);
    }

    @Override
    public String addDateMapDocument(String indexName, Map bean) throws ElasticSearchException {
        return this.addDateMapDocument(indexName, "_doc", bean);
    }

    @Override
    public String addMapDocument(String indexName, Map bean) throws ElasticSearchException {
        return this.addMapDocument(indexName, "_doc", bean);
    }

    @Override
    public String addDateMapDocument(String indexName, Map bean, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDateMapDocument(indexName, "_doc", bean, clientOptions);
    }

    @Override
    public String addDocument(String indexName, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", bean, refreshOption);
    }

    @Override
    public String addDocumentWithId(String indexName, Object bean, Object docId) throws ElasticSearchException {
        return this.addDocumentWithId(indexName, "_doc", bean, docId);
    }

    @Override
    public String addDocumentWithId(String indexName, Object bean, Object docId, Object parentId) throws ElasticSearchException {
        return this.addDocumentWithId(indexName, "_doc", bean, docId, parentId);
    }

    @Override
    public String addDocument(String indexName, Object bean, Object docId, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", bean, docId, parentId, refreshOption);
    }

    @Override
    public String addDocument(String indexName, Object bean, Object docId, String refreshOption) throws ElasticSearchException {
        return this.addDocument(indexName, "_doc", bean, docId, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, List<?> beans, ClientOptions clientOptions) throws ElasticSearchException {
        return this.updateDocuments(indexName, (String)null, beans, clientOptions);
    }

    @Override
    public String updateDocuments(String indexName, List<?> beans) throws ElasticSearchException {
        return this.updateDocuments(indexName, (String)null, beans);
    }

    @Override
    public String updateDocumentsWithIdKey(String indexName, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.updateDocumentsWithIdKey(indexName, (String)null, beans, docIdKey);
    }

    @Override
    public String updateDocumentsWithIdKey(String indexName, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.updateDocumentsWithIdKey(indexName, null, beans, docIdKey, parentIdKey);
    }

    @Override
    public String updateDocuments(String indexName, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, (String)null, beans, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, (String)null, beans, docIdKey, refreshOption);
    }

    @Override
    public String updateDocuments(String indexName, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        return this.updateDocuments(indexName, null, beans, docIdKey, parentIdKey, refreshOption);
    }

    @Override
    public String getDocument(String indexName, String documentId) throws ElasticSearchException {
        return this.getDocument(indexName, "_doc", documentId);
    }

    @Override
    public String getDocument(String indexName, String documentId, Map<String, Object> options) throws ElasticSearchException {
        return this.getDocument(indexName, "_doc", documentId, options);
    }

    @Override
    public <T> T getDocument(String indexName, String documentId, Class<T> beanType) throws ElasticSearchException {
        return this.getDocument(indexName, "_doc", documentId, beanType);
    }

    @Override
    public <T> T getDocument(String indexName, String documentId, Map<String, Object> options, Class<T> beanType) throws ElasticSearchException {
        return this.getDocument(indexName, "_doc", documentId, options, beanType);
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String documentId, Map<String, Object> options) throws ElasticSearchException {
        return this.getDocumentHit(indexName, "_doc", documentId, options);
    }

    @Override
    public MapSearchHit getDocumentHit(String indexName, String documentId) throws ElasticSearchException {
        return this.getDocumentHit(indexName, "_doc", documentId);
    }

    @Override
    public String addDateDocument(String indexName, Object bean) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", bean);
    }

    @Override
    public String addDateDocument(String indexName, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", bean, refreshOption);
    }

    @Override
    public String addDateDocumentWithId(String indexName, Object bean, Object docId) throws ElasticSearchException {
        return this.addDateDocumentWithId(indexName, "_doc", bean, docId);
    }

    @Override
    public String addDateDocumentWithId(String indexName, Object bean, Object docId, Object parentId) throws ElasticSearchException {
        return this.addDateDocumentWithId(indexName, "_doc", bean, docId, parentId);
    }

    @Override
    public String addDateDocument(String indexName, Object bean, Object docId, String refreshOption) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", bean, docId, refreshOption);
    }

    @Override
    public String addDateDocument(String indexName, Object bean, Object docId, Object parentId, String refreshOption) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", bean, docId, parentId, refreshOption);
    }

    @Override
    public String addDateDocuments(String indexName, List<?> beans) throws ElasticSearchException {
        return this.addDateDocuments(indexName, (String)null, beans);
    }

    @Override
    public String addDateDocuments(String indexName, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDateDocuments(indexName, (String)null, beans, refreshOption);
    }

    @Override
    public String addDateDocuments(String indexName, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDateDocuments(indexName, (String)null, beans, docIdKey, refreshOption);
    }

    @Override
    public String addDateDocumentsWithIdKey(String indexName, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.addDateDocumentsWithIdKey(indexName, (String)null, beans, docIdKey);
    }

    @Override
    public String addDocuments(String indexName, List<Map> beans, String docIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, (String)null, beans, docIdKey, refreshOption);
    }

    @Override
    public String addDocumentsWithIdKey(String indexName, List<Map> beans, String docIdKey) throws ElasticSearchException {
        return this.addDocumentsWithIdKey(indexName, (String)null, beans, docIdKey);
    }

    @Override
    public String addDateDocuments(String indexName, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDateDocuments(indexName, null, beans, docIdKey, parentIdKey, refreshOption);
    }

    @Override
    public String addDateDocumentsWithIdKey(String indexName, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.addDateDocumentsWithIdKey(indexName, null, beans, docIdKey, parentIdKey);
    }

    @Override
    public String addDocuments(String indexName, List<Map> beans, String docIdKey, String parentIdKey, String refreshOption) throws ElasticSearchException {
        return this.addDocuments(indexName, null, beans, docIdKey, parentIdKey, refreshOption);
    }

    @Override
    public String addDocumentsWithIdKey(String indexName, List<Map> beans, String docIdKey, String parentIdKey) throws ElasticSearchException {
        return this.addDocumentsWithIdKey(indexName, null, beans, docIdKey, parentIdKey);
    }

    @Override
    public String addDateDocumentsWithIdOptions(String indexName, List<Object> beans, String docIdField, String refreshOption) throws ElasticSearchException {
        return this.addDateDocumentsWithIdOptions(indexName, null, beans, docIdField, refreshOption);
    }

    @Override
    public String addDateDocumentsWithIdField(String indexName, List<Object> beans, String docIdField) throws ElasticSearchException {
        return this.addDateDocumentsWithIdField(indexName, (String)null, beans, docIdField);
    }

    @Override
    public String addDocumentsWithIdField(String indexName, List<Object> beans, String docIdField, String refreshOption) throws ElasticSearchException {
        return this.addDocumentsWithIdField(indexName, (String)null, beans, docIdField, refreshOption);
    }

    @Override
    public String addDocumentsWithIdField(String indexName, List<Object> beans, String docIdField) throws ElasticSearchException {
        return this.addDocumentsWithIdField(indexName, (String)null, beans, docIdField);
    }

    @Override
    public String addDateDocumentsWithIdField(String indexName, List<Object> beans, String docIdField, String parentIdField, String refreshOption) throws ElasticSearchException {
        return this.addDateDocumentsWithIdField(indexName, null, beans, docIdField, parentIdField, refreshOption);
    }

    @Override
    public String addDateDocumentsWithIdField(String indexName, List<Object> beans, String docIdField, String parentIdField) throws ElasticSearchException {
        return this.addDateDocumentsWithIdField(indexName, (String)null, beans, docIdField, parentIdField);
    }

    @Override
    public String addDocumentsWithIdField(String indexName, List<Object> beans, String docIdField, String parentIdField, String refreshOption) throws ElasticSearchException {
        return this.addDocumentsWithIdField(indexName, null, beans, docIdField, parentIdField, refreshOption);
    }

    @Override
    public String addDocumentsWithIdParentField(String indexName, List<Object> beans, String docIdField, String parentIdField) throws ElasticSearchException {
        return this.addDocumentsWithIdParentField(indexName, null, beans, docIdField, parentIdField);
    }

    @Override
    public String addDateDocuments(String indexName, List<?> beans, ClientOptions ClientOptions2) throws ElasticSearchException {
        return this.addDateDocuments(indexName, (String)null, beans, ClientOptions2);
    }

    @Override
    public String addDocuments(String indexName, List<?> beans, ClientOptions ClientOptions2) throws ElasticSearchException {
        return this.addDocuments(indexName, "_doc", beans, ClientOptions2);
    }

    @Override
    public String addDateDocumentNew(String indexName, String addTemplate, Object bean) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", addTemplate, bean);
    }

    @Override
    public String addDateDocumentNew(String indexName, String addTemplate, Object bean, String refreshOption) throws ElasticSearchException {
        return this.addDateDocument(indexName, "_doc", addTemplate, bean, refreshOption);
    }

    @Override
    public String addDateDocumentsNew(String indexName, String addTemplate, List<?> beans) throws ElasticSearchException {
        return this.addDateDocuments(indexName, "_doc", addTemplate, beans);
    }

    @Override
    public String addDateDocumentsNew(String indexName, String addTemplate, List<?> beans, String refreshOption) throws ElasticSearchException {
        return this.addDateDocuments(indexName, "_doc", addTemplate, beans, refreshOption);
    }

    @Override
    public String deleteDocumentNew(String indexName, String id) throws ElasticSearchException {
        return this.deleteDocument(indexName, "_doc", id);
    }

    @Override
    public String deleteDocumentNew(String indexName, String id, String refreshOption) throws ElasticSearchException {
        return this.deleteDocument(indexName, "_doc", id, refreshOption);
    }

    @Override
    public <T> List<T> mgetDocuments(String index, Class<T> type, Object ... ids) throws ElasticSearchException {
        return this.mgetDocuments(index, "_doc", type, ids);
    }

    @Override
    public String mgetDocumentsNew(String index, Object ... ids) throws ElasticSearchException {
        return this.mgetDocuments(index, "_doc", ids);
    }

    @Override
    public String updateDocument(String index, Object id, Object params, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, Object id, Map params, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, Object id, Map params, String refreshOption, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params, refreshOption, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, Object id, Object params, String refreshOption, Boolean detect_noop, Boolean doc_as_upsert) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, id, params, refreshOption, detect_noop, doc_as_upsert);
    }

    @Override
    public String updateDocument(String index, Object params, ClientOptions updateOptions) throws ElasticSearchException {
        return this.updateDocument(index, (String)null, params, updateOptions);
    }

    @Override
    public boolean isVersionUpper7() {
        return this.client.isUpper7();
    }

    @Override
    public boolean isVersionUpper8() {
        return this.client.isUpper8();
    }

    @Override
    public int getVersion() {
        return this.client.getVersion();
    }

    @Override
    public String addDocument(Object bean) throws ElasticSearchException {
        return this.addDocument((String)null, null, bean);
    }

    @Override
    public String addDocument(Object bean, ClientOptions clientOptions) throws ElasticSearchException {
        return this.addDocument((String)null, (String)null, bean, clientOptions);
    }

    @Override
    public String updateDocument(Object params, ClientOptions updateOptions) throws ElasticSearchException {
        return this.updateDocument((String)null, (String)null, params, updateOptions);
    }

    @Override
    public String updateDocument(Object documentId, Object params) throws ElasticSearchException {
        return this.updateDocument((String)null, documentId, params);
    }

    @Override
    public String addDocuments(List<?> beans) throws ElasticSearchException {
        try {
            BuildTool.initBatchContextThreadLocal();
            String string = this.addDocuments((String)null, (String)null, beans);
            return string;
        }
        finally {
            BuildTool.cleanBatchContextThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addDocuments(List<?> beans, ClientOptions clientOptions) throws ElasticSearchException {
        try {
            BuildTool.initBatchContextThreadLocal();
            String string = this.addDocuments((String)null, (String)null, beans, clientOptions);
            return string;
        }
        finally {
            BuildTool.cleanBatchContextThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateDocuments(List<?> beans, ClientOptions clientOptions) throws ElasticSearchException {
        try {
            BuildTool.initBatchContextThreadLocal();
            String string = this.updateDocuments((String)null, (String)null, beans, clientOptions);
            return string;
        }
        finally {
            BuildTool.cleanBatchContextThreadLocal();
        }
    }

    @Override
    public String updateDocuments(List<?> beans) throws ElasticSearchException {
        try {
            BuildTool.initBatchContextThreadLocal();
            String string = this.updateDocuments((String)null, (String)null, beans);
            return string;
        }
        finally {
            BuildTool.cleanBatchContextThreadLocal();
        }
    }

    @Override
    public String createScript(String scriptName, String scriptDsl) {
        return this.client.executeHttp("_scripts/" + scriptName, scriptDsl, "post");
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate, Map params) {
        return null;
    }

    @Override
    public String createScript(String scriptName, String scriptDslTemplate, Object params) {
        return null;
    }

    @Override
    public String deleteScript(String scriptName) {
        return this.client.executeHttp("_scripts/" + scriptName, "delete");
    }

    @Override
    public String getScript(String scriptName) {
        try {
            return this.client.executeHttp("_scripts/" + scriptName, "get");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 10);
        }
    }

    @Override
    public PitId requestPitId(String index, String keepaliveTime) {
        if (!keepaliveTime.startsWith("keep_alive=")) {
            return (PitId)this.client.executeHttp("/" + index + "/_pit?keep_alive=" + keepaliveTime, "post", new ESPitIdResponseHandler());
        }
        return (PitId)this.client.executeHttp("/" + index + "/_pit?" + keepaliveTime, "post", new ESPitIdResponseHandler());
    }

    @Override
    public String deletePitId(String pitId) {
        try {
            return this.client.executeHttp("/_pit", "{\"id\" : \"" + pitId + "\"}", "delete");
        }
        catch (ElasticSearchException e) {
            return ResultUtil.hand404HttpRuntimeException(e, String.class, 11);
        }
    }
}

