/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.RestResponse;
import org.frameworkset.elasticsearch.handler.BaseESResponsehandler;
import org.frameworkset.elasticsearch.serial.ESClass;
import org.frameworkset.elasticsearch.serial.ESClassType;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchResponseHandler
extends BaseESResponsehandler {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchResponseHandler.class);

    public ElasticSearchResponseHandler() {
    }

    public ElasticSearchResponseHandler(ESTypeReferences<?, ?> types) {
        super(types);
    }

    public ElasticSearchResponseHandler(ESClassType type) {
        super(type);
    }

    public ElasticSearchResponseHandler(Class<?> type) {
        super(type);
    }

    public RestResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = this.initStatus(response);
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            RestResponse searchResponse = null;
            if (entity != null) {
                try {
                    ESSerialThreadLocal.setESTypeReferences((ESClass)this.types);
                    RestResponse restResponse = (RestResponse)super.converJson(entity, RestResponse.class);
                    return restResponse;
                }
                catch (Exception e) {
                    throw new ElasticSearchException("Request url:" + this.url, e, status);
                }
                finally {
                    ESSerialThreadLocal.clean();
                }
            }
            return searchResponse;
        }
        HttpEntity entity = response.getEntity();
        return (RestResponse)super.handleException(this.url, entity, status);
    }
}

