/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.handler;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.entity.SearchHit;
import org.frameworkset.elasticsearch.handler.BaseGetDocESResponsehandler;
import org.frameworkset.elasticsearch.serial.ESClass;
import org.frameworkset.elasticsearch.serial.ESClassType;
import org.frameworkset.elasticsearch.serial.ESSerialThreadLocal;
import org.frameworkset.elasticsearch.serial.ESTypeReferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDocumentResponseHandler
extends BaseGetDocESResponsehandler {
    private static Logger logger = LoggerFactory.getLogger(GetDocumentResponseHandler.class);

    public GetDocumentResponseHandler() {
    }

    public GetDocumentResponseHandler(ESTypeReferences<?, ?> types) {
        super(types);
    }

    public GetDocumentResponseHandler(ESClassType type) {
        super(type);
    }

    public GetDocumentResponseHandler(Class<?> type) {
        super(type);
    }

    public SearchHit handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int status = this.initStatus(response);
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    ESSerialThreadLocal.setESTypeReferences((ESClass)this.types);
                    SearchHit searchHit = (SearchHit)super.converJson(entity, SearchHit.class);
                    return searchHit;
                }
                catch (Exception e) {
                    throw new ElasticSearchException("Request url:" + this.url, e, status);
                }
                finally {
                    ESSerialThreadLocal.clean();
                }
            }
            return null;
        }
        HttpEntity entity = response.getEntity();
        return (SearchHit)super.handleException(this.url, entity, status);
    }
}

