/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import java.io.IOException;
import java.io.Writer;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.bulk.BaseBulkCommand;
import org.frameworkset.elasticsearch.bulk.BulkConfig;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.bulk.BulkProcessor;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.soa.BBossStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxMemBulkCommandImpl
extends BaseBulkCommand {
    private static Logger logger = LoggerFactory.getLogger(MaxMemBulkCommandImpl.class);
    private int records;
    private BBossStringWriter writer;

    public MaxMemBulkCommandImpl(BulkProcessor bulkProcessor) {
        super(bulkProcessor);
        StringBuilder builder = new StringBuilder();
        this.writer = new BBossStringWriter(builder);
    }

    @Override
    protected void clear() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
        super.clearDatas();
    }

    @Override
    public boolean touchBatchSize(BulkConfig bulkConfig) {
        return this.getBulkDataRecords() >= bulkConfig.getBulkSizes() || this.getBulkDataMemSize() >= bulkConfig.getMaxMemSize();
    }

    @Override
    public String getDataString() {
        return this.writer != null ? this.writer.toString() : null;
    }

    @Override
    public void addBulkData(BulkData bulkData) {
        ++this.records;
        try {
            super.addBulkData(bulkData);
            BuildTool.evalBuilk((Writer)this.writer, bulkData, this.clientInterface.isUpper7());
        }
        catch (IOException e) {
            throw new ElasticSearchException(e);
        }
    }

    @Override
    public int getBulkDataRecords() {
        return this.records;
    }

    public int getBulkDataMemSize() {
        if (this.writer != null && this.writer.getBuffer() != null) {
            return this.writer.getBuffer().length();
        }
        return 0;
    }
}

