/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import com.frameworkset.util.DaemonThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.template.ConfigDSLUtil;
import org.frameworkset.elasticsearch.template.TemplateContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHolder {
    private Map<String, ConfigDSLUtil> configDSLUtils = new HashMap<String, ConfigDSLUtil>();
    private DaemonThread damon = null;
    private String holderName;
    private static Logger log = LoggerFactory.getLogger(ConfigDSLUtil.class);
    private Object lock = new Object();

    public ConfigHolder(String holderName) {
        this.holderName = holderName;
    }

    public ConfigHolder() {
        this.holderName = "Default";
    }

    public ConfigDSLUtil getConfigDSLUtil(String templateFile) {
        return this.getConfigDSLUtil(ElasticSearchHelper.getDslfileMappingDir(), templateFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigDSLUtil getConfigDSLUtil(TemplateContainer templateContainer) {
        String namespace = templateContainer.getNamespace();
        ConfigDSLUtil sqlUtil = this.configDSLUtils.get(namespace);
        if (sqlUtil != null) {
            return sqlUtil;
        }
        Map<String, ConfigDSLUtil> map = this.configDSLUtils;
        synchronized (map) {
            sqlUtil = this.configDSLUtils.get(namespace);
            if (sqlUtil != null) {
                return sqlUtil;
            }
            sqlUtil = new ConfigDSLUtil(this, templateContainer);
            this.configDSLUtils.put(namespace, sqlUtil);
            this.checkESUtil(sqlUtil);
        }
        return sqlUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigDSLUtil getConfigDSLUtil(String dslMappingDir, String templateFile) {
        ConfigDSLUtil configDSLUtil = this.configDSLUtils.get(templateFile);
        if (configDSLUtil != null) {
            return configDSLUtil;
        }
        Map<String, ConfigDSLUtil> map = this.configDSLUtils;
        synchronized (map) {
            configDSLUtil = this.configDSLUtils.get(templateFile);
            if (configDSLUtil != null) {
                return configDSLUtil;
            }
            configDSLUtil = new ConfigDSLUtil(this, dslMappingDir, templateFile);
            this.configDSLUtils.put(templateFile, configDSLUtil);
            this.checkESUtil(configDSLUtil);
        }
        return configDSLUtil;
    }

    public void destory() {
        if (this.configDSLUtils != null) {
            for (Map.Entry<String, ConfigDSLUtil> entry : this.configDSLUtils.entrySet()) {
                entry.getValue()._destroy();
            }
            this.configDSLUtils.clear();
        }
    }

    public List<String> getTemplateFiles() {
        Iterator<String> it = this.configDSLUtils.keySet().iterator();
        ArrayList<String> files = new ArrayList<String>();
        while (it.hasNext()) {
            files.add(it.next());
        }
        return files;
    }

    public void stopmonitor() {
        try {
            if (this.damon != null) {
                this.damon.stopped();
                this.damon = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkESUtil(ConfigDSLUtil configDSLUtil) {
        TemplateContainer templateContainer = configDSLUtil.getTemplateContext();
        long refresh_interval = ElasticSearchHelper.getDslfileRefreshInterval();
        if (refresh_interval > 0L) {
            if (this.damon == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.damon == null) {
                        this.damon = new DaemonThread(refresh_interval, this.holderName + " DSL Refresh Worker");
                        this.damon.start();
                    }
                }
            }
            templateContainer.monitor(this.damon, new ConfigDSLUtil.ResourceTempateRefresh(configDSLUtil));
        } else {
            log.debug(this.holderName + " DSL Refresh Interval:" + refresh_interval + ",ignore hotload DSL [" + templateContainer.getNamespace() + "]");
        }
    }
}

