/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormats {
    private SimpleDateFormat dayDateFormat;
    private SimpleDateFormat monthDateFormat;
    private SimpleDateFormat yearDateFormat;
    private int dayDateFormatLen;
    private int monthDateFormatLen;
    private int yearDateFormatLen;
    public static final int indiceSplitPolicy_unKnown = -1;
    public static final int indiceSplitPolicy_splitByDay = 1;
    public static final int indiceSplitPolicy_splitByMonth = 2;
    public static final int indiceSplitPolicy_splitByYear = 3;
    private Integer indiceSplitPolicy;

    public void resetIndiceSplitPolicy() {
        this.indiceSplitPolicy = null;
    }

    public Date parserDate(String dateStr) {
        if (dateStr == null || dateStr.equals("")) {
            this.indiceSplitPolicy = -1;
            return null;
        }
        Date date = null;
        try {
            if (dateStr.length() == this.dayDateFormatLen) {
                date = this.dayDateFormat.parse(dateStr);
                this.indiceSplitPolicy = 1;
            } else if (dateStr.length() == this.monthDateFormatLen) {
                date = this.monthDateFormat.parse(dateStr);
                this.indiceSplitPolicy = 2;
            } else if (dateStr.length() == this.yearDateFormatLen) {
                date = this.yearDateFormat.parse(dateStr);
                this.indiceSplitPolicy = 3;
            } else {
                this.indiceSplitPolicy = -1;
            }
        }
        catch (Exception e) {
            this.indiceSplitPolicy = -1;
        }
        return date;
    }

    public SimpleDateFormat getDayDateFormat() {
        return this.dayDateFormat;
    }

    public void setDayDateFormat(SimpleDateFormat dayDateFormat, int dayDateFormatLen) {
        this.dayDateFormat = dayDateFormat;
        this.dayDateFormatLen = dayDateFormatLen;
    }

    public SimpleDateFormat getMonthDateFormat() {
        return this.monthDateFormat;
    }

    public void setMonthDateFormat(SimpleDateFormat monthDateFormat, int monthDateFormatLen) {
        this.monthDateFormat = monthDateFormat;
        this.monthDateFormatLen = monthDateFormatLen;
    }

    public SimpleDateFormat getYearDateFormat() {
        return this.yearDateFormat;
    }

    public void setYearDateFormat(SimpleDateFormat yearDateFormat, int yearDateFormatLen) {
        this.yearDateFormat = yearDateFormat;
        this.yearDateFormatLen = yearDateFormatLen;
    }

    public Integer getIndiceSplitPolicy() {
        return this.indiceSplitPolicy;
    }
}

