/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.ArrayList;
import org.frameworkset.elasticsearch.ElasticSearch;
import org.frameworkset.elasticsearch.ElasticSearchHelper;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDiscoverUtil {
    private static Logger logger = LoggerFactory.getLogger(HostDiscoverUtil.class);

    public static synchronized void handleDiscoverHosts(String[] hosts) {
        HostDiscoverUtil.handleDiscoverHosts(hosts, "default");
    }

    public static synchronized void handleDiscoverHosts(String[] hosts, String elasticsearch) {
        if (elasticsearch == null) {
            throw new IllegalArgumentException("elasticsearch can not be null.");
        }
        ElasticSearch elasticSearch = ElasticSearchHelper.getElasticSearchSink(elasticsearch);
        if (elasticSearch == null) {
            throw new IllegalArgumentException("elasticSearch[" + elasticsearch + "] is null.");
        }
        ArrayList<ESAddress> addressList = new ArrayList<ESAddress>();
        for (String host : hosts) {
            ESAddress esAddress = new ESAddress(host.trim(), elasticSearch.getHealthPath());
            addressList.add(esAddress);
        }
        ElasticSearchClient elasticSearchRestClient = elasticSearch.getRestClient();
        ArrayList<ESAddress> newAddress = new ArrayList<ESAddress>();
        elasticSearchRestClient.recoverRemovedNodes(addressList);
        for (int i = 0; i < addressList.size(); ++i) {
            ESAddress address = (ESAddress)addressList.get(i);
            if (elasticSearchRestClient.containAddress(address)) continue;
            newAddress.add(address);
        }
        if (newAddress.size() > 0) {
            if (logger.isInfoEnabled()) {
                logger.info("Discovery new elasticsearch[" + elasticSearch.getElasticSearchName() + "] node [" + newAddress + "].");
            }
            elasticSearchRestClient.addAddresses(newAddress);
        }
        elasticSearchRestClient.handleRemoved(addressList);
    }

    public static synchronized void swithShowdsl(boolean showdsl) {
        HostDiscoverUtil.swithShowdsl(showdsl, "default");
    }

    public static synchronized void swithShowdsl(boolean showdsl, String elasticsearch) {
        ElasticSearch elasticSearch = ElasticSearchHelper.getElasticSearchSink(elasticsearch);
        if (elasticSearch == null) {
            throw new IllegalArgumentException("elasticSearch[" + elasticsearch + "] is null.");
        }
        ElasticSearchClient elasticSearchRestClient = elasticSearch.getRestClient();
        elasticSearchRestClient.setShowTemplate(showdsl);
    }
}

