/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.util.Date;
import java.util.Map;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ElasticSearchClient;
import org.frameworkset.elasticsearch.client.LogDslCallback;
import org.frameworkset.elasticsearch.client.RestSearchExecutorUtil;
import org.frameworkset.elasticsearch.entity.LogDsl;
import org.frameworkset.elasticsearch.handler.ESStringResponseHandler;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSearchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RestSearchExecutor.class);
    private String httpPool;
    private ElasticSearchClient elasticSearchClient;
    private String discoverHttpPool;

    public RestSearchExecutor(String httpPool, String discoverHttpPool, ElasticSearchClient elasticSearchClient) {
        this.httpPool = httpPool;
        this.discoverHttpPool = discoverHttpPool;
        this.elasticSearchClient = elasticSearchClient;
    }

    private void logDsl(long start, String url, String action, String dsl, int resultCode) {
        LogDslCallback logDslCallback = null;
        LogDslCallback logSlowDslCallback = null;
        Integer slowDslThreshold = this.elasticSearchClient.slowDslThreshold();
        logDslCallback = this.elasticSearchClient.getLogDslCallback();
        if (slowDslThreshold != null && slowDslThreshold > 0) {
            logSlowDslCallback = this.elasticSearchClient.getSlowDslCallback();
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        if (logDslCallback != null) {
            LogDsl slowDsl = new LogDsl();
            slowDsl.setUrl(url);
            slowDsl.setAction(action);
            slowDsl.setTime(time);
            slowDsl.setDsl(dsl);
            if (slowDslThreshold != null) {
                slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
            }
            slowDsl.setStartTime(new Date(start));
            slowDsl.setEndTime(new Date(end));
            slowDsl.setResultCode(resultCode);
            logDslCallback.logDsl(slowDsl);
        } else if (logSlowDslCallback != null && time >= (long)slowDslThreshold.intValue()) {
            LogDsl slowDsl = new LogDsl();
            slowDsl.setUrl(url);
            slowDsl.setAction(action);
            slowDsl.setTime(time);
            slowDsl.setDsl(dsl);
            slowDsl.setSlowDslThreshold(slowDslThreshold.intValue());
            slowDsl.setStartTime(new Date(start));
            slowDsl.setEndTime(new Date(end));
            slowDsl.setResultCode(resultCode);
            logSlowDslCallback.logDsl(slowDsl);
        }
    }

    public String execute(String url, String entity, ESStringResponseHandler responseHandler) throws Exception {
        long start = System.currentTimeMillis();
        int resultCode = 0;
        try {
            String string = (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, (Map)null, (ResponseHandler)responseHandler);
            return string;
        }
        catch (Exception e) {
            resultCode = 1;
            throw e;
        }
        finally {
            if (responseHandler.getUrl() != null) {
                url = responseHandler.getUrl();
            }
            this.logDsl(start, url, "post", entity, resultCode);
        }
    }

    public <T> T executeHttp(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        int resultCode = 0;
        long start = System.currentTimeMillis();
        try {
            T t = RestSearchExecutorUtil.__executeHttp(this.httpPool, null, url, entity, action, responseHandler);
            return t;
        }
        catch (Exception e) {
            resultCode = 1;
            throw e;
        }
        finally {
            String temp;
            if (responseHandler instanceof URLResponseHandler && (temp = ((URLResponseHandler)responseHandler).getUrl()) != null) {
                url = temp;
            }
            this.logDsl(start, url, action, entity, resultCode);
        }
    }

    public <T> T discoverHost(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        int resultCode = 0;
        long start = System.currentTimeMillis();
        try {
            T t = RestSearchExecutorUtil.__executeHttp(this.discoverHttpPool, null, url, entity, action, responseHandler);
            return t;
        }
        catch (Exception e) {
            resultCode = 1;
            throw e;
        }
        finally {
            String temp;
            if (responseHandler instanceof URLResponseHandler && (temp = ((URLResponseHandler)responseHandler).getUrl()) != null) {
                url = temp;
            }
            this.logDsl(start, url, action, entity, resultCode);
        }
    }

    public String executeSimpleRequest(String url, String entity, ESStringResponseHandler responseHandler) throws Exception {
        long start = System.currentTimeMillis();
        int resultCode = 0;
        try {
            String response = null;
            response = entity == null ? (String)HttpRequestUtil.httpPostforString((String)this.httpPool, (String)url, null, (Map)null, (ResponseHandler)responseHandler) : (String)HttpRequestUtil.sendJsonBody((String)this.httpPool, (String)entity, (String)url, (Map)null, (ResponseHandler)responseHandler);
            String string = response;
            return string;
        }
        catch (Exception e) {
            resultCode = 1;
            throw e;
        }
        finally {
            String temp = responseHandler.getUrl();
            if (temp != null) {
                url = temp;
            }
            this.logDsl(start, url, "post", entity, resultCode);
        }
    }

    public <T> T executeRequest(String url, String entity, String action, ResponseHandler<T> responseHandler) throws Exception {
        long start = System.currentTimeMillis();
        int resultCode = 0;
        try {
            T t = RestSearchExecutorUtil._executeRequest(this.httpPool, null, url, entity, action, responseHandler);
            return t;
        }
        catch (Exception e) {
            resultCode = 1;
            throw e;
        }
        finally {
            String temp;
            if (responseHandler instanceof URLResponseHandler && (temp = ((URLResponseHandler)responseHandler).getUrl()) != null) {
                url = temp;
            }
            this.logDsl(start, url, action, entity, resultCode);
        }
    }

    public String getClusterVersionInfo() {
        return this.elasticSearchClient.getClusterVersionInfo();
    }
}

