/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class NormalRollingFileAppender
extends RollingFileAppender {
    protected String originFileName;
    protected boolean useDatePattern = true;
    protected SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected long tnextRollover = 0L;
    protected String logFileName;
    protected File parent;

    public boolean isUseDatePattern() {
        return this.useDatePattern;
    }

    public void setUseDatePattern(boolean useDatePattern) {
        this.useDatePattern = useDatePattern;
    }

    public NormalRollingFileAppender() {
    }

    public NormalRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
    }

    public NormalRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
    }

    protected boolean deleteOldFile() {
        boolean renameSucceeded = true;
        if (!this.parent.exists()) {
            return renameSucceeded;
        }
        File[] logfiles = this.parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NormalRollingFileAppender.this.logFileName);
            }
        });
        if (logfiles == null || logfiles.length == 0 || logfiles.length < this.maxBackupIndex) {
            return renameSucceeded;
        }
        File file = null;
        for (File f : logfiles) {
            if (file == null) {
                file = f;
                continue;
            }
            if (file.lastModified() <= f.lastModified()) continue;
            file = f;
        }
        if (file != null && file.exists()) {
            renameSucceeded = file.delete();
        }
        return renameSucceeded;
    }

    public void rollOver() {
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
            this.tnextRollover = size + this.maxFileSize;
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        boolean renameSucceeded = true;
        if (this.maxBackupIndex > 0) {
            renameSucceeded = this.deleteOldFile();
        }
        if (!renameSucceeded) {
            try {
                this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
            }
            catch (IOException var6) {
                if (var6 instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."), (Throwable)var6);
            }
        } else {
            this.closeFile();
            try {
                String tempfileName;
                Date time = new Date(System.currentTimeMillis());
                String currentIndex = this.dataFormat.format(time);
                this.fileName = tempfileName = this.originFileName + "." + currentIndex;
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
                this.tnextRollover = 0L;
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
            }
        }
    }

    protected String buildName(String name) {
        return name;
    }

    public void setFile(String file) {
        String val = file.trim();
        val = this.buildName(val);
        int idx = val.lastIndexOf("/");
        this.parent = new File(val).getParentFile();
        if (this.parent == null) {
            this.parent = new File(".");
        }
        this.logFileName = idx >= 0 ? val.substring(idx + 1) : val;
        this.logFileName = this.logFileName + ".";
        this.originFileName = val;
        if (!this.parent.exists()) {
            Date time = new Date(System.currentTimeMillis());
            String currentIndex = this.dataFormat.format(time);
            this.fileName = val + "." + currentIndex;
        } else {
            File[] logfiles = this.parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(NormalRollingFileAppender.this.logFileName);
                }
            });
            if (logfiles == null || logfiles.length == 0) {
                Date time = new Date(System.currentTimeMillis());
                String currentIndex = this.dataFormat.format(time);
                this.fileName = val + "." + currentIndex;
            } else {
                File lastFile = null;
                for (File f : logfiles) {
                    if (lastFile == null) {
                        lastFile = f;
                        continue;
                    }
                    if (f.lastModified() <= lastFile.lastModified()) continue;
                    lastFile = f;
                }
                try {
                    this.fileName = lastFile.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Date time = new Date(System.currentTimeMillis());
                    String currentIndex = this.dataFormat.format(time);
                    this.fileName = val + "." + currentIndex;
                }
            }
        }
    }

    protected void subAppend(LoggingEvent event) {
        long size;
        super.subAppend(event);
        if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.tnextRollover) {
            this.rollOver();
        }
    }
}

