/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv.play.controllers;

import com.bcgdv.play.services.Api;
import com.bcgdv.play.util.ApiHeaderHelper;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import javax.inject.Inject;
import play.mvc.Controller;

public class ApiAwareController
extends Controller
implements Api {
    protected Api api;

    protected ApiAwareController() {
    }

    @Inject
    public ApiAwareController(Api api) {
        this.api = api;
    }

    @Override
    public JsonNode get(String uri) {
        return this.api.get(uri, this.requestHeaders());
    }

    public JsonNode get(String uri, String token) {
        return this.api.get(uri, this.headers(token));
    }

    @Override
    public JsonNode get(String uri, Map headers) {
        return this.api.get(uri, headers);
    }

    @Override
    public JsonNode post(String uri) {
        return this.api.post(uri);
    }

    public JsonNode post(String uri, String token) {
        return this.api.post(uri, this.headers(token));
    }

    @Override
    public JsonNode post(String uri, Map headers) {
        return this.api.post(uri, headers);
    }

    @Override
    public JsonNode post(String uri, JsonNode body) {
        return this.api.post(uri, this.requestHeaders(), body);
    }

    public JsonNode post(String uri, JsonNode body, String token) {
        return this.api.post(uri, this.headers(token), body);
    }

    @Override
    public JsonNode post(String uri, Map headers, JsonNode body) {
        return this.api.post(uri, headers, body);
    }

    @Override
    public void putAndForget(String uri, Map header, JsonNode body) {
        this.api.putAndForget(uri, header, body);
    }

    @Override
    public void putAndForget(String uri, JsonNode body) {
        this.api.putAndForget(uri, body);
    }

    public void putAndForget(String uri, JsonNode body, String token) {
        this.api.putAndForget(uri, this.headers(token), body);
    }

    @Override
    public JsonNode put(String uri, JsonNode body) {
        return this.api.put(uri, this.requestHeaders(), body);
    }

    public JsonNode put(String uri, JsonNode body, String token) {
        return this.api.put(uri, this.headers(token), body);
    }

    @Override
    public JsonNode put(String uri, Map headers, JsonNode body) {
        return this.api.put(uri, headers, body);
    }

    @Override
    public JsonNode delete(String uri) {
        return this.api.delete(uri, this.requestHeaders());
    }

    public JsonNode delete(String uri, String token) {
        return this.api.delete(uri, this.headers(token));
    }

    @Override
    public JsonNode delete(String uri, Map headers) {
        return this.api.delete(uri, headers);
    }

    protected Map<String, String> headers(String token) {
        return ApiHeaderHelper.headers(token, ApiAwareController.request());
    }

    protected Map requestHeaders() {
        return ApiHeaderHelper.requestHeaders(ApiAwareController.request());
    }
}

