/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv.play.services;

import com.bcgdv.RequestIdGenerator;
import com.bcgdv.play.services.Api;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import play.Logger;
import play.libs.Json;
import play.libs.ws.WS;
import play.libs.ws.WSRequest;
import play.libs.ws.WSResponse;

public class SimpleApiAdapter
implements Api {
    protected static String scheme;

    public SimpleApiAdapter() {
        String scheme = this.getEnvOrProperty("API_SCHEME");
        if (scheme == null) {
            this.initScheme("http");
        } else {
            this.initScheme(scheme);
        }
    }

    public SimpleApiAdapter(String scheme) {
        SimpleApiAdapter.scheme = scheme;
    }

    protected void initScheme(String scheme) {
        SimpleApiAdapter.scheme = scheme;
    }

    @Override
    public JsonNode get(String uri) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, new HashMap()).get().toCompletableFuture().join());
    }

    @Override
    public JsonNode get(String uri, Map headers) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, headers).get().toCompletableFuture().join());
    }

    @Override
    public JsonNode post(String uri, JsonNode body) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, new HashMap()).post(body).toCompletableFuture().join());
    }

    @Override
    public JsonNode post(String uri) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, new HashMap()).post((JsonNode)Json.newObject()).toCompletableFuture().join());
    }

    @Override
    public JsonNode post(String uri, Map headers) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, headers).post((JsonNode)Json.newObject()).toCompletableFuture().join());
    }

    @Override
    public JsonNode post(String uri, Map headers, JsonNode body) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, headers).post(body).toCompletableFuture().join());
    }

    @Override
    public JsonNode put(String uri, JsonNode body) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, new HashMap()).put(body).toCompletableFuture().join());
    }

    @Override
    public JsonNode put(String uri, Map headers, JsonNode body) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, headers).put(body).toCompletableFuture().join());
    }

    @Override
    public void putAndForget(String uri, Map headers, JsonNode body) {
        Logger.info((String)"Trying to make  put request for url {}", (Object[])new Object[]{uri});
        CompletableFuture.runAsync(() -> {
            try {
                WSResponse response = (WSResponse)this.apiRequest(uri, headers).put(body).toCompletableFuture().get();
                Logger.info((String)("Remote put response  for uri " + uri + "is " + response.getStatus()));
            }
            catch (Exception e) {
                Logger.warn((String)("Remote put response  for uri  failed :" + uri + e.getMessage()));
            }
        });
    }

    @Override
    public void putAndForget(String uri, JsonNode body) {
        this.putAndForget(uri, new HashMap(), body);
    }

    @Override
    public JsonNode delete(String uri) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, new HashMap()).delete().toCompletableFuture().join());
    }

    @Override
    public JsonNode delete(String uri, Map headers) {
        return this.handleResponse((WSResponse)this.apiRequest(uri, headers).delete().toCompletableFuture().join());
    }

    protected WSRequest apiRequest(String pathSegment, Map headers) {
        WSRequest request = WS.url((String)this.buildUri(pathSegment));
        request.setFollowRedirects(Boolean.valueOf(true));
        request.setRequestTimeout(this.getTimeout());
        request.setContentType("application/json");
        if (headers != null && headers.containsKey("Authorization")) {
            request.setHeader("Authorization", (String)headers.get("Authorization"));
        }
        if (headers != null && headers.containsKey(RequestIdGenerator.X_REQUEST_ID)) {
            request.setHeader(RequestIdGenerator.X_REQUEST_ID, (String)headers.get(RequestIdGenerator.X_REQUEST_ID));
        }
        return request;
    }

    protected String buildUri(String pathSegment) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(this.getHost());
        sb.append(this.getPort());
        sb.append(pathSegment);
        return sb.toString();
    }

    protected String getPort() {
        String port = this.getEnvOrProperty("API_PORT");
        if (port == null) {
            if ("https".equals(scheme)) {
                port = ":443";
            }
            if ("http".equals(scheme)) {
                port = ":80";
            }
        } else {
            port = ":" + port;
        }
        return port != null ? port : "";
    }

    protected String getHost() {
        String host = this.getEnvOrProperty("API_HOST_NAME");
        if (host == null) {
            host = "localhost";
        }
        return host;
    }

    protected JsonNode handleResponse(WSResponse response) {
        if (response.getStatus() < 400) {
            return Json.parse((String)this.jsonSafeResponse(response));
        }
        return this.handleRemoteError(response.getUri().getPath(), response);
    }

    protected String jsonSafeResponse(WSResponse response) {
        return "".equals(response.getBody()) ? "{}" : response.getBody();
    }

    protected JsonNode handleRemoteError(String uri, WSResponse response) {
        String message = "remote response for uri: " + uri + ", status: " + response.getStatus();
        Logger.warn((String)message);
        throw new RuntimeJsonMappingException(message);
    }

    protected long getTimeout() {
        String timeout = this.getEnvOrProperty("HTTP_CLIENT_TIMEOUT");
        if (timeout == null) {
            return 90000L;
        }
        return Long.parseLong(timeout);
    }

    protected String getEnvOrProperty(String param) {
        String value = System.getenv(param);
        if (value == null) {
            value = System.getProperty(param);
        }
        return value;
    }
}

