/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv.play.services;

import com.bcgdv.play.services.Api;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import play.Logger;

public class TimingWrapperInterceptor
implements Api {
    protected static final String ROUND_TRIP = "remote api round trip for %s in %sms";
    protected Api api;

    public TimingWrapperInterceptor(Api api) {
        this.api = api;
    }

    @Override
    public JsonNode get(String uri) {
        long before = this.now();
        JsonNode result = this.api.get(uri);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode get(String uri, Map headers) {
        long before = this.now();
        JsonNode result = this.api.get(uri, headers);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode post(String uri, Map headers) {
        long before = this.now();
        JsonNode result = this.api.post(uri, headers);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode post(String uri) {
        long before = this.now();
        JsonNode result = this.api.post(uri);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode post(String uri, JsonNode body) {
        long before = this.now();
        JsonNode result = this.api.post(uri, body);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode post(String uri, Map headers, JsonNode body) {
        long before = this.now();
        JsonNode result = this.api.post(uri, headers, body);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode put(String uri, JsonNode body) {
        long before = this.now();
        JsonNode result = this.api.put(uri, body);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode put(String uri, Map headers, JsonNode body) {
        long before = this.now();
        JsonNode result = this.api.put(uri, headers, body);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public void putAndForget(String uri, Map header, JsonNode body) {
        this.api.putAndForget(uri, header, body);
    }

    @Override
    public void putAndForget(String uri, JsonNode body) {
        this.api.putAndForget(uri, body);
    }

    @Override
    public JsonNode delete(String uri) {
        long before = this.now();
        JsonNode result = this.api.delete(uri);
        return this.logAndReturn(uri, before, result);
    }

    @Override
    public JsonNode delete(String uri, Map headers) {
        long before = this.now();
        JsonNode result = this.api.delete(uri, headers);
        return this.logAndReturn(uri, before, result);
    }

    protected JsonNode logAndReturn(String uri, long before, JsonNode result) {
        Logger.info((String)String.format(ROUND_TRIP, uri, this.now() - before));
        return result;
    }

    protected long now() {
        return System.currentTimeMillis();
    }
}

