/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv.play.util;

import com.bcgdv.RequestIdGenerator;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import play.mvc.Http;

public class ApiHeaderHelper {
    protected static final String AUTHORIZATION = "Authorization";

    protected ApiHeaderHelper() {
    }

    public static Map<String, String> headers(String token, Http.Request request) {
        HashMap headers = Maps.newHashMap();
        headers.put(AUTHORIZATION, token);
        ApiHeaderHelper.addXRequestHeader(headers, request);
        return headers;
    }

    public static Map requestHeaders(Http.Request request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String authorizationHeader = request.getHeader(AUTHORIZATION);
        if (authorizationHeader != null && !"".equals(authorizationHeader)) {
            headers.put(AUTHORIZATION, authorizationHeader);
        }
        ApiHeaderHelper.addXRequestHeader(headers, request);
        return headers;
    }

    public static void addXRequestHeader(Map<String, String> headers, Http.Request request) {
        String requestIdHeader = request.getHeader(RequestIdGenerator.X_REQUEST_ID);
        if (requestIdHeader != null && !"".equals(requestIdHeader)) {
            headers.put(RequestIdGenerator.X_REQUEST_ID, requestIdHeader);
        }
    }
}

