/*
 * Decompiled with CFR 0.152.
 */
package com.bcgdv;

import java.util.UUID;

public class RequestIdGenerator {
    public static String X_REQUEST_ID = "X-Request-ID";
    protected static final String DEFAULT_INSTALLATION_ID = "0";
    protected static final String DEFAULT_BUILD_NUMBER = "0";
    protected static final String DEFAULT_ENVIRONMENT = "D";
    protected static final String DEFAULT_PLATFORM = "S";
    protected static final String REGEX_NUMBERS = "[0-9]";
    protected static final String REGEX_LETTERS = "[a-z]";
    protected static final String ZERO = "0";
    protected static final String X = "X";
    protected static final String R = "R";
    protected static final String DASH = "-";
    protected static final String EMPTY = "";
    protected String buildNumber;
    protected String installationId;
    protected Environment environment;
    private String base;

    public RequestIdGenerator() {
        this.buildNumber = "0";
        this.installationId = "0";
        this.environment = Environment.DEV;
        this.base = this.getBase();
    }

    public RequestIdGenerator(Environment environment, String installationId, String buildNumber) {
        this.environment = environment;
        this.installationId = installationId;
        this.buildNumber = buildNumber;
        this.base = this.getBase();
    }

    public static String generateInstallationId() {
        return UUID.randomUUID().toString().replaceAll(DASH, EMPTY);
    }

    public String unique() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.base);
        sb.append(UUID.randomUUID());
        return sb.toString();
    }

    public String empty() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.base);
        sb.append(UUID.randomUUID().toString().replaceAll(REGEX_NUMBERS, "0").replaceAll(REGEX_LETTERS, "0"));
        return sb.toString();
    }

    protected String getBase() {
        StringBuilder sb = new StringBuilder();
        sb.append(X);
        sb.append(DASH);
        sb.append(this.getEnvironment());
        sb.append(this.getInstallationID());
        sb.append(DASH);
        sb.append(this.getPlatform());
        sb.append(this.buildNumber);
        sb.append(DASH);
        sb.append(R);
        return sb.toString();
    }

    protected String getInstallationID() {
        return this.installationId;
    }

    protected String getEnvironment() {
        return this.environment.toString();
    }

    protected String getPlatform() {
        return DEFAULT_PLATFORM;
    }

    public static enum Environment {
        DEV,
        TEST,
        PROD;

        protected static final String DEVELOPMENT_ENVIRONMENT = "D";
        protected static final String TEST_ENVIRONMENT = "T";
        protected static final String PRODUCTION_ENVIRONMENT = "P";

        public String toString() {
            if (this == DEV) {
                return "D";
            }
            if (this == TEST) {
                return TEST_ENVIRONMENT;
            }
            if (this == PROD) {
                return PRODUCTION_ENVIRONMENT;
            }
            return "D";
        }
    }
}

