/*
 * Decompiled with CFR 0.152.
 */
package gander.cleaners;

import gander.cleaners.DocumentCleaner;
import gander.cleaners.DocumentCleaner$;
import java.util.List;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.TagsEvaluator;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class DocumentCleaner$class {
    /*
     * WARNING - void declaration
     */
    public static Document clean(DocumentCleaner $this, Document doc) {
        void var2_2;
        DocumentCleaner$.MODULE$.trace("Starting cleaning phase with DefaultDocumentCleaner", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Document docToClean = doc;
        docToClean = DocumentCleaner$class.cleanEmTags($this, docToClean);
        docToClean = DocumentCleaner$class.removeDropCaps($this, docToClean);
        docToClean = DocumentCleaner$class.removeScriptsAndStyles($this, docToClean);
        docToClean = DocumentCleaner$class.cleanBadTags($this, docToClean);
        docToClean = DocumentCleaner$class.removeNodesViaRegEx($this, docToClean, DocumentCleaner$.MODULE$.captionPattern());
        docToClean = DocumentCleaner$class.removeNodesViaRegEx($this, docToClean, DocumentCleaner$.MODULE$.googlePattern());
        docToClean = DocumentCleaner$class.removeNodesViaRegEx($this, docToClean, DocumentCleaner$.MODULE$.entriesPattern());
        docToClean = DocumentCleaner$class.removeNodesViaRegEx($this, docToClean, DocumentCleaner$.MODULE$.facebookPattern());
        docToClean = DocumentCleaner$class.removeNodesViaRegEx($this, docToClean, DocumentCleaner$.MODULE$.twitterPattern());
        docToClean = DocumentCleaner$class.cleanUpSpanTagsInParagraphs($this, docToClean);
        docToClean = DocumentCleaner$class.convertWantedTagsToParagraphs($this, docToClean, DocumentCleaner$.MODULE$.articleRootTags());
        return var2_2;
    }

    private static Document cleanEmTags(DocumentCleaner $this, Document doc) {
        Elements ems = doc.getElementsByTag("em");
        ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)ems).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Element, Elements> apply(Element node) {
                Elements images = node.getElementsByTag("img");
                return new Tuple2((Object)node, (Object)images);
            }
        }, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Element, Elements> x$1) {
                Elements images;
                Tuple2<Element, Elements> tuple2 = x$1;
                if (tuple2 != null && (images = (Elements)tuple2._2()) != null) {
                    Elements elements = images;
                    boolean bl = elements.size() == 0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).foreach((Function1)new Serializable($this, doc){
            public static final long serialVersionUID = 0L;
            private final Document doc$1;

            public final void apply(Tuple2<Element, Elements> x$2) {
                Tuple2<Element, Elements> tuple2 = x$2;
                if (tuple2 != null) {
                    Element node = (Element)tuple2._1();
                    Elements images = (Elements)tuple2._2();
                    if (images != null) {
                        TextNode tn = new TextNode(node.text(), this.doc$1.baseUri());
                        node.replaceWith((Node)tn);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.doc$1 = doc$1;
            }
        });
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(ems.size()).append((Object)" EM tags modified").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return doc;
    }

    private static Document cleanUpSpanTagsInParagraphs(DocumentCleaner $this, Document doc) {
        Elements spans = doc.getElementsByTag("span");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)spans).asScala()).foreach((Function1)new Serializable($this, doc){
            public static final long serialVersionUID = 0L;
            private final Document doc$3;

            public final void apply(Element item) {
                String string2 = item.parent().nodeName();
                String string3 = "p";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    TextNode tn = new TextNode(item.text(), this.doc$3.baseUri());
                    item.replaceWith((Node)tn);
                    DocumentCleaner$.MODULE$.trace(new StringBuilder().append((Object)"Replacing nested span with TextNode: ").append((Object)item.text()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
            }
            {
                this.doc$3 = doc$3;
            }
        });
        return doc;
    }

    private static Document removeDropCaps(DocumentCleaner $this, Document doc) {
        Elements items = doc.select("span[class~=(dropcap|drop_cap)]");
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(items.size()).append((Object)" dropcap tags removed").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)items).asScala()).foreach((Function1)new Serializable($this, doc){
            public static final long serialVersionUID = 0L;
            private final Document doc$2;

            public final void apply(Element item) {
                TextNode tn = new TextNode(item.text(), this.doc$2.baseUri());
                item.replaceWith((Node)tn);
            }
            {
                this.doc$2 = doc$2;
            }
        });
        return doc;
    }

    private static Document removeScriptsAndStyles(DocumentCleaner $this, Document doc) {
        Elements scripts = doc.getElementsByTag("script");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)scripts).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Element item) {
                item.remove();
            }
        });
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(scripts.size()).append((Object)" script tags removed").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Elements styles = doc.getElementsByTag("style");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)styles).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Element style) {
                style.remove();
            }
        });
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(styles.size()).append((Object)" style tags removed").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return doc;
    }

    private static Document cleanBadTags(DocumentCleaner $this, Document doc) {
        Elements children = doc.body().children();
        Elements naughtyList = children.select(DocumentCleaner$.MODULE$.queryNaughtyIDs());
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyList.size()).append((Object)" naughty ID elements found").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)naughtyList).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DocumentCleaner $outer;

            public final void apply(Element node) {
                DocumentCleaner$.MODULE$.trace(new StringBuilder().append((Object)"Removing node with id: ").append((Object)node.id()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DocumentCleaner$class.gander$cleaners$DocumentCleaner$$removeNode(this.$outer, node);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Elements naughtyList2 = children.select(DocumentCleaner$.MODULE$.queryNaughtyIDs());
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyList2.size()).append((Object)" naughty ID elements found after removal").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Elements naughtyClasses = children.select(DocumentCleaner$.MODULE$.queryNaughtyClasses());
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyClasses.size()).append((Object)" naughty CLASS elements found").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)naughtyClasses).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DocumentCleaner $outer;

            public final void apply(Element node) {
                DocumentCleaner$.MODULE$.trace(new StringBuilder().append((Object)"Removing node with class: ").append((Object)node.className()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DocumentCleaner$class.gander$cleaners$DocumentCleaner$$removeNode(this.$outer, node);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Elements naughtyClasses2 = children.select(DocumentCleaner$.MODULE$.queryNaughtyClasses());
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyClasses2.size()).append((Object)" naughty CLASS elements found after removal").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Elements naughtyList5 = children.select(DocumentCleaner$.MODULE$.queryNaughtyNames());
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyList5.size()).append((Object)" naughty Name elements found").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)naughtyList5).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DocumentCleaner $outer;

            public final void apply(Element node) {
                DocumentCleaner$.MODULE$.trace(new StringBuilder().append((Object)"Removing node with class: ").append((Object)node.attr("class")).append((Object)" id: ").append((Object)node.id()).append((Object)" name: ").append((Object)node.attr("name")).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                DocumentCleaner$class.gander$cleaners$DocumentCleaner$$removeNode(this.$outer, node);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return doc;
    }

    private static Document removeNodesViaRegEx(DocumentCleaner $this, Document doc, Pattern pattern) {
        try {
            Elements naughtyList = doc.getElementsByAttributeValueMatching("id", pattern);
            DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyList.size()).append((Object)" ID elements found against pattern: ").append((Object)pattern).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)naughtyList).asScala()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DocumentCleaner $outer;

                public final void apply(Element node) {
                    DocumentCleaner$class.gander$cleaners$DocumentCleaner$$removeNode(this.$outer, node);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Elements naughtyList3 = doc.getElementsByAttributeValueMatching("class", pattern);
            DocumentCleaner$.MODULE$.trace(new StringBuilder().append(naughtyList3.size()).append((Object)" CLASS elements found against pattern: ").append((Object)pattern).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)naughtyList3).asScala()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DocumentCleaner $outer;

                public final void apply(Element node) {
                    DocumentCleaner$class.gander$cleaners$DocumentCleaner$$removeNode(this.$outer, node);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DocumentCleaner$.MODULE$.warn(illegalArgumentException, illegalArgumentException.toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        return doc;
    }

    public static void gander$cleaners$DocumentCleaner$$removeNode(DocumentCleaner $this, Element node) {
        if (node == null || node.parent() == null) {
            return;
        }
        node.remove();
    }

    public static void replaceElementsWithPara(DocumentCleaner $this, Document doc, Element div) {
        Document newDoc = new Document(doc.baseUri());
        Element newNode = newDoc.createElement("p");
        newNode.append(div.html());
        div.replaceWith((Node)newNode);
    }

    private static Document convertWantedTagsToParagraphs(DocumentCleaner $this, Document doc, TagsEvaluator wantedTags) {
        Elements selected = Collector.collect((Evaluator)wantedTags, (Element)doc);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)selected).asScala()).foreach((Function1)new Serializable($this, doc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DocumentCleaner $outer;
            private final Document doc$4;

            public final void apply(Element elem) {
                if (Collector.collect((Evaluator)DocumentCleaner$.MODULE$.blockElemementTags(), (Element)elem).isEmpty()) {
                    this.$outer.replaceElementsWithPara(this.doc$4, elem);
                } else {
                    ListBuffer<Node> replacements = this.$outer.getReplacementNodes(this.doc$4, elem);
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)elem.children()).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Element x$3) {
                            x$3.remove();
                        }
                    });
                    replacements.foreach((Function1)new Serializable(this, elem){
                        public static final long serialVersionUID = 0L;
                        private final Element elem$1;

                        public final Object apply(Node n) {
                            Element element;
                            try {
                                element = this.elem$1.appendChild(n);
                            }
                            catch (Exception exception) {
                                DocumentCleaner$.MODULE$.info(exception, "Failed to append cleaned child!", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                element = BoxedUnit.UNIT;
                            }
                            return element;
                        }
                        {
                            this.elem$1 = elem$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.doc$4 = doc$4;
            }
        });
        return doc;
    }

    public static Element getFlushedBuffer(DocumentCleaner $this, StringBuilder replacementText, Document doc) {
        String bufferedText = replacementText.toString();
        DocumentCleaner$.MODULE$.trace(new StringBuilder().append((Object)"Flushing TextNode Buffer: ").append((Object)bufferedText.trim()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Document newDoc = new Document(doc.baseUri());
        Element newPara = newDoc.createElement("p");
        newPara.html(replacementText.toString());
        return newPara;
    }

    public static ListBuffer getReplacementNodes(DocumentCleaner $this, Document doc, Element div) {
        StringBuilder replacementText = new StringBuilder();
        ListBuffer nodesToReturn = new ListBuffer();
        ListBuffer nodesToRemove = new ListBuffer();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(div.childNodes()).asScala()).foreach((Function1)new Serializable($this, replacementText, nodesToReturn, nodesToRemove, doc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DocumentCleaner $outer;
            private final StringBuilder replacementText$1;
            private final ListBuffer nodesToReturn$1;
            private final ListBuffer nodesToRemove$1;
            private final Document doc$5;

            public final Object apply(Node kid) {
                ListBuffer listBuffer;
                String string2 = kid.nodeName();
                String string3 = "p";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null) && this.replacementText$1.size() > 0) {
                    BoxedUnit boxedUnit;
                    Element newNode = this.$outer.getFlushedBuffer(this.replacementText$1, this.doc$5);
                    this.nodesToReturn$1.$plus$eq((Object)newNode);
                    this.replacementText$1.clear();
                    Node node = kid;
                    if (node instanceof Element) {
                        Element element = (Element)node;
                        boxedUnit = this.nodesToReturn$1.$plus$eq((Object)element);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    listBuffer = boxedUnit;
                } else {
                    String string4 = kid.nodeName();
                    String string5 = "#text";
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        TextNode kidTextNode = (TextNode)kid;
                        String kidText = kidTextNode.attr("text");
                        String replaceText = DocumentCleaner$.MODULE$.tabsAndNewLinesReplacements().replaceAll(kidText);
                        if (replaceText.trim().length() > 1) {
                            Node prevSibNode = kidTextNode.previousSibling();
                            while (prevSibNode != null) {
                                String string6 = prevSibNode.nodeName();
                                String string7 = "a";
                                if (string6 != null ? !string6.equals(string7) : string7 != null) break;
                                String string8 = prevSibNode.attr("grv-usedalready");
                                String string9 = "yes";
                                if (!(string8 == null ? string9 != null : !string8.equals(string9))) break;
                                this.replacementText$1.append(new StringBuilder().append((Object)" ").append((Object)prevSibNode.outerHtml()).append((Object)" ").toString());
                                this.nodesToRemove$1.$plus$eq((Object)prevSibNode);
                                prevSibNode.attr("grv-usedalready", "yes");
                                prevSibNode = prevSibNode.previousSibling() == null ? null : prevSibNode.previousSibling();
                            }
                            this.replacementText$1.append(replaceText);
                            Node nextSibNode = kidTextNode.nextSibling();
                            while (nextSibNode != null) {
                                String string10 = nextSibNode.nodeName();
                                String string11 = "a";
                                if (string10 != null ? !string10.equals(string11) : string11 != null) break;
                                String string12 = nextSibNode.attr("grv-usedalready");
                                String string13 = "yes";
                                if (!(string12 == null ? string13 != null : !string12.equals(string13))) break;
                                this.replacementText$1.append(new StringBuilder().append((Object)" ").append((Object)nextSibNode.outerHtml()).append((Object)" ").toString());
                                this.nodesToRemove$1.$plus$eq((Object)nextSibNode);
                                nextSibNode.attr("grv-usedalready", "yes");
                                nextSibNode = nextSibNode.nextSibling() == null ? null : nextSibNode.nextSibling();
                            }
                        }
                        listBuffer = this.nodesToRemove$1.$plus$eq((Object)kid);
                    } else {
                        listBuffer = this.nodesToReturn$1.$plus$eq((Object)kid);
                    }
                }
                return listBuffer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replacementText$1 = replacementText$1;
                this.nodesToReturn$1 = nodesToReturn$1;
                this.nodesToRemove$1 = nodesToRemove$1;
                this.doc$5 = doc$5;
            }
        });
        if (replacementText.nonEmpty()) {
            Element newNode = $this.getFlushedBuffer(replacementText, doc);
            nodesToReturn.$plus$eq((Object)newNode);
            replacementText.clear();
        }
        nodesToRemove.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Node x$4) {
                x$4.remove();
            }
        });
        return nodesToReturn;
    }

    public static void $init$(DocumentCleaner $this) {
    }
}

