/*
 * Decompiled with CFR 0.152.
 */
package gander.extractors;

import gander.extractors.ContentExtractor;
import gander.extractors.ContentExtractor$;
import gander.text.ReplaceSequence$;
import gander.text.StopWords$;
import gander.text.StringReplacement$;
import gander.text.StringSplitter;
import gander.text.WordStats;
import gander.text.string$;
import java.net.URL;
import java.util.ArrayList;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.Selector;
import org.jsoup.select.TagsEvaluator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public abstract class ContentExtractor$class {
    public static Logger getLogger(ContentExtractor $this) {
        return ContentExtractor$.MODULE$.logger();
    }

    public static String getTitle(ContentExtractor $this, Document doc) {
        String string2;
        String title = string$.MODULE$.empty();
        try {
            Elements titleElem = doc.getElementsByTag("title");
            if (titleElem == null || titleElem.isEmpty()) {
                return string$.MODULE$.empty();
            }
            String titleText = titleElem.first().text();
            if (string$.MODULE$.isNullOrEmpty(titleText)) {
                return string$.MODULE$.empty();
            }
            boolean usedDelimeter = false;
            if (titleText.contains("|")) {
                titleText = $this.doTitleSplits(titleText, $this.PIPE_SPLITTER());
                usedDelimeter = true;
            }
            if (!usedDelimeter && titleText.contains("-")) {
                titleText = $this.doTitleSplits(titleText, $this.DASH_SPLITTER());
                usedDelimeter = true;
            }
            if (!usedDelimeter && titleText.contains("\u00bb")) {
                titleText = $this.doTitleSplits(titleText, $this.ARROWS_SPLITTER());
                usedDelimeter = true;
            }
            if (!usedDelimeter && titleText.contains(":")) {
                titleText = $this.doTitleSplits(titleText, $this.COLON_SPLITTER());
            }
            title = $this.MOTLEY_REPLACEMENT().replaceAll(titleText);
            ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Page title is: ").append((Object)title).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            string2 = title;
        }
        catch (NullPointerException nullPointerException) {
            ContentExtractor$.MODULE$.warn(nullPointerException.toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            string2 = string$.MODULE$.empty();
        }
        return string2;
    }

    public static String doTitleSplits(ContentExtractor $this, String title, StringSplitter splitter) {
        int largetTextLen = 0;
        int largeTextIndex = 0;
        String[] titlePieces = splitter.split(title);
        for (int i = 0; i < titlePieces.length; ++i) {
            String current = titlePieces[i];
            if (current.length() <= largetTextLen) continue;
            largetTextLen = current.length();
            largeTextIndex = i;
        }
        return $this.TITLE_REPLACEMENTS().replaceAll(titlePieces[largeTextIndex]).trim();
    }

    private static String getMetaContent(ContentExtractor $this, Document doc, String metaName) {
        Elements meta = doc.select(metaName);
        String content = null;
        if (meta.size() > 0) {
            content = meta.first().attr("content");
        }
        return string$.MODULE$.isNullOrEmpty(content) ? string$.MODULE$.empty() : content.trim();
    }

    public static String getMetaDescription(ContentExtractor $this, Document doc) {
        return ContentExtractor$class.getMetaContent($this, doc, "meta[name=description]");
    }

    public static String getMetaKeywords(ContentExtractor $this, Document doc) {
        return ContentExtractor$class.getMetaContent($this, doc, "meta[name=keywords]");
    }

    public static String getCanonicalLink(ContentExtractor $this, Document doc, String finalUrl) {
        String href;
        Elements meta = doc.select("link[rel=canonical]");
        return meta.size() > 0 ? (new StringOps(Predef$.MODULE$.augmentString(href = ((String)Option$.MODULE$.apply((Object)meta.first().attr("href")).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).trim())).nonEmpty() ? href : finalUrl) : finalUrl;
    }

    public static String getDomain(ContentExtractor $this, String url) {
        return new URL(url).getHost();
    }

    public static scala.collection.immutable.Set extractTags(ContentExtractor $this, Document doc) {
        Document node = doc;
        if (node.children().size() == 0) {
            return $this.NO_STRINGS();
        }
        Elements elements = Selector.select((String)$this.A_REL_TAG_SELECTOR(), (Element)node);
        if (elements.size() == 0) {
            return $this.NO_STRINGS();
        }
        HashSet tags = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)elements).asScala()).foreach((Function1)new Serializable($this, tags){
            public static final long serialVersionUID = 0L;
            private final HashSet tags$1;

            public final Object apply(Element el) {
                String tag = el.text();
                return string$.MODULE$.isNullOrEmpty(tag) ? BoxedUnit.UNIT : this.tags$1.$plus$eq((Object)tag);
            }
            {
                this.tags$1 = tags$1;
            }
        });
        return tags.toSet();
    }

    public static Option calculateBestNodeBasedOnClustering(ContentExtractor $this, Document doc) {
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Starting to calculate TopNode").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        ObjectRef topNode = ObjectRef.create(null);
        Elements nodesToCheck = Collector.collect((Evaluator)$this.TOP_NODE_TAGS(), (Element)doc);
        DoubleRef startingBoost = DoubleRef.create((double)1.0);
        IntRef cnt = IntRef.create((int)0);
        IntRef i = IntRef.create((int)0);
        HashSet parentNodes = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer nodesWithText = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)nodesToCheck).asScala()).foreach((Function1)new Serializable($this, nodesWithText){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContentExtractor $outer;
            private final Buffer nodesWithText$1;

            public final Object apply(Element node) {
                String nodeText = node.text();
                WordStats wordStats = StopWords$.MODULE$.getStopWordCount(nodeText);
                boolean highLinkDensity = ContentExtractor$class.gander$extractors$ContentExtractor$$isHighLinkDensity(this.$outer, node);
                return wordStats.getStopWordCount() > 2 && !highLinkDensity ? this.nodesWithText$1.$plus$eq((Object)node) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nodesWithText$1 = nodesWithText$1;
            }
        });
        int numberOfNodes = nodesWithText.size();
        int negativeScoring = 0;
        double bottomNodesForNegativeScore = (double)numberOfNodes * 0.25;
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"About to inspect num of nodes with text: ").append((Object)BoxesRunTime.boxToInteger((int)numberOfNodes)).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        nodesWithText.foreach((Function1)new Serializable($this, startingBoost, cnt, i, parentNodes, numberOfNodes, negativeScoring, bottomNodesForNegativeScore){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContentExtractor $outer;
            private final DoubleRef startingBoost$1;
            private final IntRef cnt$1;
            private final IntRef i$1;
            private final HashSet parentNodes$1;
            private final int numberOfNodes$1;
            private final int negativeScoring$1;
            private final double bottomNodesForNegativeScore$1;

            public final void apply(Element node) {
                float booster;
                float negscore;
                float boostScore = 0.0f;
                if (ContentExtractor$class.gander$extractors$ContentExtractor$$isOkToBoost(this.$outer, node) && this.cnt$1.elem >= 0) {
                    boostScore = (float)(1.0 / this.startingBoost$1.elem * (double)50);
                    this.startingBoost$1.elem += 1.0;
                }
                if (this.numberOfNodes$1 > 15 && (double)(this.numberOfNodes$1 - this.i$1.elem) <= this.bottomNodesForNegativeScore$1 && (negscore = package$.MODULE$.abs(boostScore = -((float)package$.MODULE$.pow((double)(booster = (float)this.bottomNodesForNegativeScore$1 - (float)(this.numberOfNodes$1 - this.i$1.elem)), (double)2))) + (float)this.negativeScoring$1) > (float)40) {
                    boostScore = 5.0f;
                }
                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Location Boost Score: ").append((Object)BoxesRunTime.boxToFloat((float)boostScore)).append((Object)" on interation: ").append((Object)BoxesRunTime.boxToInteger((int)this.i$1.elem)).append((Object)"' id='").append((Object)node.parent().id()).append((Object)"' class='").append((Object)node.parent().attr("class")).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                String nodeText = node.text();
                WordStats wordStats = StopWords$.MODULE$.getStopWordCount(nodeText);
                int upscore = (int)((float)wordStats.getStopWordCount() + boostScore);
                ContentExtractor$class.gander$extractors$ContentExtractor$$updateScore(this.$outer, node.parent(), upscore);
                ContentExtractor$class.gander$extractors$ContentExtractor$$updateScore(this.$outer, node.parent().parent(), upscore / 2);
                ContentExtractor$class.gander$extractors$ContentExtractor$$updateNodeCount(this.$outer, node.parent(), 1);
                ContentExtractor$class.gander$extractors$ContentExtractor$$updateNodeCount(this.$outer, node.parent().parent(), 1);
                Object object = this.parentNodes$1.contains((Object)node.parent()) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.parentNodes$1.add((Object)node.parent()));
                Object object2 = this.parentNodes$1.contains((Object)node.parent().parent()) ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.parentNodes$1.add((Object)node.parent().parent()));
                ++this.cnt$1.elem;
                ++this.i$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.startingBoost$1 = startingBoost$1;
                this.cnt$1 = cnt$1;
                this.i$1 = i$1;
                this.parentNodes$1 = parentNodes$1;
                this.numberOfNodes$1 = numberOfNodes$1;
                this.negativeScoring$1 = negativeScoring$1;
                this.bottomNodesForNegativeScore$1 = bottomNodesForNegativeScore$1;
            }
        });
        IntRef topNodeScore = IntRef.create((int)0);
        parentNodes.foreach((Function1)new Serializable($this, topNode, topNodeScore){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContentExtractor $outer;
            private final ObjectRef topNode$1;
            private final IntRef topNodeScore$1;

            public final void apply(Element e) {
                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"ParentNode: score='").append((Object)e.attr("gravityScore")).append((Object)"' nodeCount='").append((Object)e.attr("gravityNodes")).append((Object)"' id='").append((Object)e.id()).append((Object)"' class='").append((Object)e.attr("class")).append((Object)"' ").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                int score = ContentExtractor$class.gander$extractors$ContentExtractor$$getScore(this.$outer, e);
                if (score > this.topNodeScore$1.elem) {
                    this.topNode$1.elem = e;
                    this.topNodeScore$1.elem = score;
                }
                if ((Element)this.topNode$1.elem == null) {
                    this.topNode$1.elem = e;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topNode$1 = topNode$1;
                this.topNodeScore$1 = topNodeScore$1;
            }
        });
        $this.printTraceLog((Element)topNode.elem);
        return Option$.MODULE$.apply((Object)((Element)topNode.elem));
    }

    public static void printTraceLog(ContentExtractor $this, Element topNode) {
        try {
            if (topNode != null) {
                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Our TOPNODE: score='").append((Object)topNode.attr("gravityScore")).append((Object)"' nodeCount='").append((Object)topNode.attr("gravityNodes")).append((Object)"' id='").append((Object)topNode.id()).append((Object)"' class='").append((Object)topNode.attr("class")).append((Object)"' ").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                String text = topNode.text().trim().length() > 100 ? new StringBuilder().append((Object)topNode.text().trim().substring(0, 100)).append((Object)"...").toString() : topNode.text().trim();
                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Text - ").append((Object)text).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
        }
        catch (NullPointerException nullPointerException) {
            ContentExtractor$.MODULE$.warn(new StringBuilder().append((Object)"printTraceLog: ").append((Object)nullPointerException.toString()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    public static boolean gander$extractors$ContentExtractor$$isOkToBoost(ContentExtractor $this, Element node) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                String para = "p";
                IntRef stepsAway = IntRef.create((int)0);
                int minimumStopWordCount = 5;
                int maxStepsAwayFromNode = 3;
                $this.walkSiblings(node, new Serializable($this, para, stepsAway, minimumStopWordCount, maxStepsAwayFromNode, object){
                    public static final long serialVersionUID = 0L;
                    private final String para$1;
                    private final IntRef stepsAway$1;
                    private final int minimumStopWordCount$1;
                    private final int maxStepsAwayFromNode$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Element currentNode) {
                        String string2 = currentNode.tagName();
                        String string3 = this.para$1;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            if (this.stepsAway$1.elem >= this.maxStepsAwayFromNode$1) {
                                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Next paragraph is too far away, not boosting").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                            }
                            String paraText = currentNode.text();
                            WordStats wordStats = StopWords$.MODULE$.getStopWordCount(paraText);
                            if (wordStats.getStopWordCount() > this.minimumStopWordCount$1) {
                                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"We're gonna boost this node, seems contenty").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                            }
                            ++this.stepsAway$1.elem;
                        }
                    }
                    {
                        this.para$1 = para$1;
                        this.stepsAway$1 = stepsAway$1;
                        this.minimumStopWordCount$1 = minimumStopWordCount$1;
                        this.maxStepsAwayFromNode$1 = maxStepsAwayFromNode$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public static String getShortText(ContentExtractor $this, String e, int max) {
        return e.length() > max ? new StringBuilder().append((Object)e.substring(0, max)).append((Object)"...").toString() : e;
    }

    public static boolean gander$extractors$ContentExtractor$$isHighLinkDensity(ContentExtractor $this, Element e) {
        Elements links = e.getElementsByTag("a");
        if (links.size() == 0) {
            return false;
        }
        String text = e.text().trim();
        String[] words = $this.SPACE_SPLITTER().split(text);
        float numberOfWords = words.length;
        StringBuilder sb = new StringBuilder();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)links).asScala()).foreach((Function1)new Serializable($this, sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final StringBuilder apply(Element link) {
                return this.sb$1.append(link.text());
            }
            {
                this.sb$1 = sb$1;
            }
        });
        String linkText = sb.toString();
        String[] linkWords = $this.SPACE_SPLITTER().split(linkText);
        float numberOfLinkWords = linkWords.length;
        float numberOfLinks = links.size();
        float linkDivisor = numberOfLinkWords / numberOfWords;
        float score = linkDivisor * numberOfLinks;
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Calulated link density score as: ").append((Object)BoxesRunTime.boxToFloat((float)score)).append((Object)" for node: ").append((Object)$this.getShortText(e.text(), 50)).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return score > 1.0f;
    }

    public static int gander$extractors$ContentExtractor$$getScore(ContentExtractor $this, Element node) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    int score;
                    option = ContentExtractor$class.getGravityScoreFromNode($this, node);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    n = score = BoxesRunTime.unboxToInt((Object)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = 0;
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    private static Option getGravityScoreFromNode(ContentExtractor $this, Element node) {
        None$ none$;
        try {
            String grvScoreString = node.attr("gravityScore");
            if (string$.MODULE$.isNullOrEmpty(grvScoreString)) {
                return None$.MODULE$;
            }
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(grvScoreString)));
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void gander$extractors$ContentExtractor$$updateScore(ContentExtractor $this, Element node, int addToScore) {
        int currentScore = 0;
        try {
            String scoreString = node.attr("gravityScore");
            currentScore = string$.MODULE$.isNullOrEmpty(scoreString) ? 0 : Integer.parseInt(scoreString);
        }
        catch (NumberFormatException numberFormatException) {
            currentScore = 0;
        }
        int newScore = currentScore + addToScore;
        node.attr("gravityScore", Integer.toString(newScore));
    }

    public static void gander$extractors$ContentExtractor$$updateNodeCount(ContentExtractor $this, Element node, int addToCount) {
        int currentScore = 0;
        try {
            String countString = node.attr("gravityNodes");
            currentScore = string$.MODULE$.isNullOrEmpty(countString) ? 0 : Integer.parseInt(countString);
        }
        catch (NumberFormatException numberFormatException) {
            currentScore = 0;
        }
        int newScore = currentScore + addToCount;
        node.attr("gravityNodes", Integer.toString(newScore));
    }

    public static List extractVideos(ContentExtractor $this, Element node) {
        ArrayList candidates = new ArrayList();
        Buffer goodMovies = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String youtubeStr = "youtube";
        String vimdeoStr = "vimeo";
        try {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)node.parent().getElementsByTag("embed")).asScala()).foreach((Function1)new Serializable($this, candidates){
                public static final long serialVersionUID = 0L;
                private final ArrayList candidates$1;

                public final boolean apply(Element x$1) {
                    return this.candidates$1.add(x$1);
                }
                {
                    this.candidates$1 = candidates$1;
                }
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)node.parent().getElementsByTag("object")).asScala()).foreach((Function1)new Serializable($this, candidates){
                public static final long serialVersionUID = 0L;
                private final ArrayList candidates$1;

                public final boolean apply(Element x$2) {
                    return this.candidates$1.add(x$2);
                }
                {
                    this.candidates$1 = candidates$1;
                }
            });
            ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"extractVideos: Starting to extract videos. Found: ").append((Object)BoxesRunTime.boxToInteger((int)candidates.size())).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(candidates).asScala()).foreach((Function1)new Serializable($this, goodMovies, youtubeStr, vimdeoStr){
                public static final long serialVersionUID = 0L;
                public final Buffer goodMovies$1;
                public final String youtubeStr$1;
                public final String vimdeoStr$1;

                public final void apply(Element el) {
                    Attributes attrs = el.attributes();
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)attrs).asScala()).foreach((Function1)new Serializable(this, el){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ContentExtractor$.anonfun.extractVideos.3 $outer;
                        private final Element el$1;

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public final Object apply(Attribute a) {
                            BoxedUnit boxedUnit;
                            try {
                                if (a.getValue().contains(this.$outer.youtubeStr$1) || a.getValue().contains(this.$outer.vimdeoStr$1)) {
                                    String string2 = a.getKey();
                                    String string3 = "src";
                                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"This page has a video!: ").append((Object)a.getValue()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                        boxedUnit = this.$outer.goodMovies$1.$plus$eq((Object)this.el$1);
                                        return boxedUnit;
                                    }
                                }
                                boxedUnit = BoxedUnit.UNIT;
                                return boxedUnit;
                            }
                            catch (Exception exception) {
                                ContentExtractor$.MODULE$.info(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Error extracting movies: ").append((Object)exception.toString()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return boxedUnit;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.el$1 = el$1;
                        }
                    });
                }
                {
                    this.goodMovies$1 = goodMovies$1;
                    this.youtubeStr$1 = youtubeStr$1;
                    this.vimdeoStr$1 = vimdeoStr$1;
                }
            });
        }
        catch (Exception exception) {
            ContentExtractor$.MODULE$.warn(exception.toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception}));
        }
        catch (NullPointerException nullPointerException) {
            ContentExtractor$.MODULE$.warn(nullPointerException.toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nullPointerException}));
        }
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"extractVideos:  done looking videos").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return goodMovies.toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTableTagAndNoParagraphsExist(ContentExtractor $this, Element e) {
        Elements subParagraphs = e.getElementsByTag("p");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)subParagraphs).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Element p) {
                if (p.text().length() < 25) {
                    p.remove();
                }
            }
        });
        Elements subParagraphs2 = e.getElementsByTag("p");
        if (subParagraphs2.size() != 0) return false;
        String string2 = e.tagName();
        String string3 = "td";
        if (string2 == null) {
            if (string3 == null) return false;
        } else if (string2.equals(string3)) return false;
        ContentExtractor$.MODULE$.trace("Removing node because it doesn't have any paragraphs", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static Element postExtractionCleanup(ContentExtractor $this, Element targetNode) {
        void var2_2;
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Starting cleanup Node").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Element node = ContentExtractor$class.addSiblings($this, targetNode);
        ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)node.children()).asScala()).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Element e) {
                String string2 = e.tagName();
                String string3 = "p";
                return string2 != null ? !string2.equals(string3) : string3 != null;
            }
        }).foreach((Function1)new Serializable($this, node){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContentExtractor $outer;
            private final Element node$1;

            public final void apply(Element e) {
                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"CLEANUP  NODE: ").append((Object)e.id()).append((Object)" class: ").append((Object)e.attr("class")).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                if (ContentExtractor$class.gander$extractors$ContentExtractor$$isHighLinkDensity(this.$outer, e) || this.$outer.isTableTagAndNoParagraphsExist(e) || !this.$outer.isNodeScoreThreshholdMet(this.node$1, e)) {
                    try {
                        e.remove();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)"Cannot remove node: ").append((Object)illegalArgumentException.toString()).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.node$1 = node$1;
            }
        });
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNodeScoreThreshholdMet(ContentExtractor $this, Element node, Element e) {
        int topNodeScore = ContentExtractor$class.gander$extractors$ContentExtractor$$getScore($this, node);
        int currentNodeScore = ContentExtractor$class.gander$extractors$ContentExtractor$$getScore($this, e);
        float thresholdScore = (float)((double)topNodeScore * 0.08);
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"topNodeScore: ").append((Object)BoxesRunTime.boxToInteger((int)topNodeScore)).append((Object)" currentNodeScore: ").append((Object)BoxesRunTime.boxToInteger((int)currentNodeScore)).append((Object)" threshold: ").append((Object)BoxesRunTime.boxToFloat((float)thresholdScore)).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        if ((float)currentNodeScore < thresholdScore) {
            String string2 = e.tagName();
            String string3 = "td";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Removing node due to low threshold score").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                return false;
            }
        }
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Not removing TD node").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        return true;
    }

    public static Option getSiblingContent(ContentExtractor $this, Element currentSibling, int baselineScoreForSiblingParagraphs) {
        Object object;
        String string2 = currentSibling.tagName();
        String string3 = "p";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && currentSibling.text().length() > 0) {
            object = new Some((Object)currentSibling.outerHtml());
        } else {
            Elements potentialParagraphs = currentSibling.getElementsByTag("p");
            object = potentialParagraphs.first() == null ? None$.MODULE$ : new Some((Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)potentialParagraphs).asScala()).withFilter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Element firstParagraph) {
                    return firstParagraph.text().length() > 0;
                }
            }).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Tuple4<Element, WordStats, Object, Object> apply(Element firstParagraph) {
                    WordStats wordStats = StopWords$.MODULE$.getStopWordCount(firstParagraph.text());
                    int paragraphScore = wordStats.getStopWordCount();
                    double siblingBaseLineScore = 0.3;
                    return new Tuple4((Object)firstParagraph, (Object)wordStats, (Object)BoxesRunTime.boxToInteger((int)paragraphScore), (Object)BoxesRunTime.boxToDouble((double)siblingBaseLineScore));
                }
            }, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable($this, baselineScoreForSiblingParagraphs){
                public static final long serialVersionUID = 0L;
                private final int baselineScoreForSiblingParagraphs$2;

                public final boolean apply(Tuple4<Element, WordStats, Object, Object> x$3) {
                    Tuple4<Element, WordStats, Object, Object> tuple4 = x$3;
                    if (tuple4 != null) {
                        WordStats wordStats = (WordStats)tuple4._2();
                        int paragraphScore = BoxesRunTime.unboxToInt((Object)tuple4._3());
                        double siblingBaseLineScore = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                        if (wordStats != null) {
                            double d = siblingBaseLineScore;
                            int n = paragraphScore;
                            boolean bl = (double)this.baselineScoreForSiblingParagraphs$2 * d < (double)n;
                            return bl;
                        }
                    }
                    throw new MatchError(tuple4);
                }
                {
                    this.baselineScoreForSiblingParagraphs$2 = baselineScoreForSiblingParagraphs$2;
                }
            }).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple4<Element, WordStats, Object, Object> x$4) {
                    Tuple4<Element, WordStats, Object, Object> tuple4 = x$4;
                    if (tuple4 != null) {
                        Element firstParagraph = (Element)tuple4._1();
                        WordStats wordStats = (WordStats)tuple4._2();
                        if (wordStats != null && true) {
                            ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"This node looks like a good sibling, adding it").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                            String string2 = new StringBuilder().append((Object)"<p>").append((Object)firstParagraph.text()).append((Object)"<p>").toString();
                            return string2;
                        }
                    }
                    throw new MatchError(tuple4);
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Seq walkSiblings(ContentExtractor $this, Element node, Function1 work) {
        Element currentSibling = node.previousElementSibling();
        Buffer b = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (currentSibling != null) {
            void var4_4;
            Element element;
            ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"SIBLINGCHECK: ").append((Object)ContentExtractor$class.debugNode($this, element)).toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            var4_4.$plus$eq(work.apply((Object)element));
            element = element == null ? null : element.previousElementSibling();
        }
        return b;
    }

    private static Element addSiblings(ContentExtractor $this, Element topNode) {
        ContentExtractor$.MODULE$.trace(new StringBuilder().append((Object)ContentExtractor$.MODULE$.logPrefix()).append((Object)"Starting to add siblings").toString(), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        int baselineScoreForSiblingParagraphs = ContentExtractor$class.getBaselineScoreForSiblings($this, topNode);
        Seq results = (Seq)((TraversableLike)$this.walkSiblings(topNode, new Serializable($this, baselineScoreForSiblingParagraphs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContentExtractor $outer;
            private final int baselineScoreForSiblingParagraphs$1;

            public final Option<String> apply(Element currentNode) {
                return this.$outer.getSiblingContent(currentNode, this.baselineScoreForSiblingParagraphs$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.baselineScoreForSiblingParagraphs$1 = baselineScoreForSiblingParagraphs$1;
            }
        }).reverse()).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Option<String> itm) {
                return Option$.MODULE$.option2Iterable(itm);
            }
        }, Seq$.MODULE$.canBuildFrom());
        topNode.child(0).before(results.mkString());
        return topNode;
    }

    /*
     * WARNING - void declaration
     */
    private static int getBaselineScoreForSiblings(ContentExtractor $this, Element topNode) {
        void var2_2;
        int base = 100000;
        IntRef numberOfParagraphs = IntRef.create((int)0);
        IntRef scoreOfParagraphs = IntRef.create((int)0);
        Elements nodesToCheck = topNode.getElementsByTag("p");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)nodesToCheck).asScala()).foreach((Function1)new Serializable($this, numberOfParagraphs, scoreOfParagraphs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ContentExtractor $outer;
            private final IntRef numberOfParagraphs$1;
            private final IntRef scoreOfParagraphs$1;

            public final void apply(Element node) {
                String nodeText = node.text();
                WordStats wordStats = StopWords$.MODULE$.getStopWordCount(nodeText);
                boolean highLinkDensity = ContentExtractor$class.gander$extractors$ContentExtractor$$isHighLinkDensity(this.$outer, node);
                if (wordStats.getStopWordCount() > 2 && !highLinkDensity) {
                    ++this.numberOfParagraphs$1.elem;
                    this.scoreOfParagraphs$1.elem += wordStats.getStopWordCount();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numberOfParagraphs$1 = numberOfParagraphs$1;
                this.scoreOfParagraphs$1 = scoreOfParagraphs$1;
            }
        });
        if (numberOfParagraphs.elem > 0) {
            base = scoreOfParagraphs.elem / numberOfParagraphs.elem;
            if (ContentExtractor$.MODULE$.logger().isDebugEnabled()) {
                ContentExtractor$.MODULE$.logger().debug(new StringBuilder().append((Object)"The base score for siblings to beat is: ").append((Object)BoxesRunTime.boxToInteger((int)base)).append((Object)" NumOfParas: ").append((Object)BoxesRunTime.boxToInteger((int)numberOfParagraphs.elem)).append((Object)" scoreOfAll: ").append((Object)BoxesRunTime.boxToInteger((int)scoreOfParagraphs.elem)).toString());
            }
        }
        return (int)var2_2;
    }

    private static String debugNode(ContentExtractor $this, Element e) {
        StringBuilder sb = new StringBuilder();
        sb.append("GravityScore: '");
        sb.append(e.attr("gravityScore"));
        sb.append("' paraNodeCount: '");
        sb.append(e.attr("gravityNodes"));
        sb.append("' nodeId: '");
        sb.append(e.id());
        sb.append("' className: '");
        sb.append(e.attr("class"));
        return sb.toString();
    }

    public static void $init$(ContentExtractor $this) {
        $this.gander$extractors$ContentExtractor$_setter_$MOTLEY_REPLACEMENT_$eq(StringReplacement$.MODULE$.compile("&#65533;", string$.MODULE$.empty()));
        $this.gander$extractors$ContentExtractor$_setter_$ESCAPED_FRAGMENT_REPLACEMENT_$eq(StringReplacement$.MODULE$.compile("#!", "?_escaped_fragment_="));
        $this.gander$extractors$ContentExtractor$_setter_$TITLE_REPLACEMENTS_$eq(ReplaceSequence$.MODULE$.create("&raquo;").append("\u00bb"));
        $this.gander$extractors$ContentExtractor$_setter_$PIPE_SPLITTER_$eq(new StringSplitter("\\|"));
        $this.gander$extractors$ContentExtractor$_setter_$DASH_SPLITTER_$eq(new StringSplitter(" - "));
        $this.gander$extractors$ContentExtractor$_setter_$ARROWS_SPLITTER_$eq(new StringSplitter("\u00bb"));
        $this.gander$extractors$ContentExtractor$_setter_$COLON_SPLITTER_$eq(new StringSplitter(":"));
        $this.gander$extractors$ContentExtractor$_setter_$SPACE_SPLITTER_$eq(new StringSplitter(" "));
        $this.gander$extractors$ContentExtractor$_setter_$NO_STRINGS_$eq(Predef$.MODULE$.Set().empty());
        $this.gander$extractors$ContentExtractor$_setter_$A_REL_TAG_SELECTOR_$eq("a[rel=tag], a[href*=/tag/]");
        $this.gander$extractors$ContentExtractor$_setter_$TOP_NODE_TAGS_$eq(new TagsEvaluator((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p", "td", "pre"})))));
    }
}

