/*
 * Decompiled with CFR 0.152.
 */
package gander.outputformatters;

import gander.outputformatters.OutputFormatter;
import gander.text.StopWords$;
import gander.text.WordStats;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class OutputFormatter$class {
    private static Elements selectElements(OutputFormatter $this, String query, Element topNode) {
        Element element = topNode;
        Elements elements = element == null ? new Elements((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()) : element.select(query);
        return elements;
    }

    public static String getFormattedText(OutputFormatter $this, Element topNode) {
        OutputFormatter$class.removeNodesWithNegativeScores($this, topNode);
        OutputFormatter$class.convertLinksToText($this, topNode);
        OutputFormatter$class.replaceTagsWithText($this, topNode);
        OutputFormatter$class.removeParagraphsWithFewWords($this, topNode);
        return $this.convertToText(topNode);
    }

    public static String convertToText(OutputFormatter $this, Element topNode) {
        Element element = topNode;
        String string2 = element == null ? "" : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)element.children()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Element e) {
                return StringEscapeUtils.unescapeHtml4((String)e.text()).trim();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList().mkString("\n\n");
        return string2;
    }

    private static void convertLinksToText(OutputFormatter $this, Element topNode) {
        if (topNode != null) {
            $this.logger().trace(new StringBuilder().append((Object)$this.gander$outputformatters$OutputFormatter$$logPrefix()).append((Object)"Turning links to text").toString());
            String baseUri = topNode.baseUri();
            Elements links = topNode.getElementsByTag("a");
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)links).asScala()).foreach((Function1)new Serializable($this, baseUri){
                public static final long serialVersionUID = 0L;
                private final String baseUri$1;

                public final void apply(Element item) {
                    if (item.getElementsByTag("img").isEmpty()) {
                        TextNode tn = new TextNode(item.text(), this.baseUri$1);
                        item.replaceWith((Node)tn);
                    }
                }
                {
                    this.baseUri$1 = baseUri$1;
                }
            });
        }
    }

    private static void removeNodesWithNegativeScores(OutputFormatter $this, Element topNode) {
        Elements gravityItems = OutputFormatter$class.selectElements($this, "*[gravityScore]", topNode);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)gravityItems).asScala()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OutputFormatter $outer;

            public final void apply(Element item) {
                int score = OutputFormatter$class.tryInt$1(this.$outer, item.attr("gravityScore"));
                if (score < 1) {
                    item.remove();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static void replaceTagsWithText(OutputFormatter $this, Element topNode) {
        if (topNode != null) {
            String baseUri = topNode.baseUri();
            Elements bolds = topNode.getElementsByTag("b");
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)bolds).asScala()).foreach((Function1)new Serializable($this, baseUri){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OutputFormatter $outer;
                private final String baseUri$2;

                public final void apply(Element item) {
                    TextNode tn = new TextNode(OutputFormatter$class.gander$outputformatters$OutputFormatter$$getTagCleanedText(this.$outer, (Node)item), this.baseUri$2);
                    item.replaceWith((Node)tn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.baseUri$2 = baseUri$2;
                }
            });
            Elements strongs = topNode.getElementsByTag("strong");
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)strongs).asScala()).foreach((Function1)new Serializable($this, baseUri){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OutputFormatter $outer;
                private final String baseUri$2;

                public final void apply(Element item) {
                    TextNode tn = new TextNode(OutputFormatter$class.gander$outputformatters$OutputFormatter$$getTagCleanedText(this.$outer, (Node)item), this.baseUri$2);
                    item.replaceWith((Node)tn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.baseUri$2 = baseUri$2;
                }
            });
            Elements italics = topNode.getElementsByTag("i");
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)italics).asScala()).foreach((Function1)new Serializable($this, baseUri){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OutputFormatter $outer;
                private final String baseUri$2;

                public final void apply(Element item) {
                    TextNode tn = new TextNode(OutputFormatter$class.gander$outputformatters$OutputFormatter$$getTagCleanedText(this.$outer, (Node)item), this.baseUri$2);
                    item.replaceWith((Node)tn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.baseUri$2 = baseUri$2;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String gander$outputformatters$OutputFormatter$$getTagCleanedText(OutputFormatter $this, Node item) {
        void var3_3;
        StringBuilder sb = new StringBuilder();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(item.childNodes()).asScala()).foreach((Function1)new Serializable($this, sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final Object apply(Node x0$1) {
                BoxedUnit boxedUnit;
                Node node = x0$1;
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    boxedUnit = this.sb$1.append(textNode.getWholeText());
                } else if (node instanceof Element) {
                    Element element = (Element)node;
                    boxedUnit = this.sb$1.append(element.outerHtml());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.sb$1 = sb$1;
            }
        });
        String text = $this.gander$outputformatters$OutputFormatter$$tagReplace().replaceAllIn((CharSequence)sb.toString(), "");
        return var3_3;
    }

    private static void removeParagraphsWithFewWords(OutputFormatter $this, Element topNode) {
        if (topNode != null) {
            if ($this.logger().isDebugEnabled()) {
                $this.logger().debug("removeParagraphsWithFewWords starting...");
            }
            Elements allNodes = topNode.getAllElements();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)allNodes).asScala()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OutputFormatter $outer;

                public final void apply(Element el) {
                    try {
                        WordStats stopWords = StopWords$.MODULE$.getStopWordCount(el.text());
                        if (stopWords.getStopWordCount() < 3 && el.getElementsByTag("object").size() == 0 && el.getElementsByTag("embed").size() == 0) {
                            this.$outer.logger().debug(new StringOps(Predef$.MODULE$.augmentString("removeParagraphsWithFewWords - swcnt: %d removing text: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stopWords.getStopWordCount()), el.text()})));
                            el.remove();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.$outer.logger().error(illegalArgumentException.getMessage());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Option$.MODULE$.apply((Object)topNode.getElementsByTag("p").first()).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OutputFormatter $outer;

                public final void apply(Element x0$2) {
                    Element element = x0$2;
                    if (element != null) {
                        BoxedUnit boxedUnit;
                        Element element2 = element;
                        String trimmed = element2.text().trim();
                        if (trimmed.startsWith("(") && trimmed.endsWith(")")) {
                            this.$outer.logger().trace("Removing parenthesis paragraph that is first paragraph");
                            element2.remove();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError((Object)element);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public static final int tryInt$1(OutputFormatter $this, String text) {
        int n;
        try {
            n = Integer.parseInt(text);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public static void $init$(OutputFormatter $this) {
        $this.gander$outputformatters$OutputFormatter$_setter_$gander$outputformatters$OutputFormatter$$logPrefix_$eq("outformat: ");
        $this.gander$outputformatters$OutputFormatter$_setter_$gander$outputformatters$OutputFormatter$$tagReplace_$eq(new StringOps(Predef$.MODULE$.augmentString("<[^>]+>")).r());
    }
}

