/*
 * Decompiled with CFR 0.152.
 */
package gander.utils;

import gander.text.HashUtils$;
import gander.text.StringReplacement;
import gander.text.StringReplacement$;
import gander.utils.Logging;
import gander.utils.Logging$class;
import gander.utils.ParsingCandidate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;

public final class URLHelper$
implements Logging {
    public static final URLHelper$ MODULE$;
    private final StringReplacement ESCAPED_FRAGMENT_REPLACEMENT;
    private final Logger logger;

    static {
        new URLHelper$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void gander$utils$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void trace(String msg, Seq<Object> refs) {
        Logging$class.trace(this, msg, refs);
    }

    @Override
    public void trace(Throwable t, String msg, Seq<Object> refs) {
        Logging$class.trace(this, t, msg, refs);
    }

    @Override
    public void info(String msg, Seq<Object> refs) {
        Logging$class.info(this, msg, refs);
    }

    @Override
    public void info(Throwable t, String msg, Seq<Object> refs) {
        Logging$class.info(this, t, msg, refs);
    }

    @Override
    public void warn(String msg, Seq<Object> refs) {
        Logging$class.warn(this, msg, refs);
    }

    @Override
    public void warn(Throwable t, String msg, Seq<Object> refs) {
        Logging$class.warn(this, t, msg, refs);
    }

    @Override
    public void critical(String msg, Seq<Object> refs) {
        Logging$class.critical(this, msg, refs);
    }

    @Override
    public void critical(Throwable t, String msg, Seq<Object> refs) {
        Logging$class.critical(this, t, msg, refs);
    }

    @Override
    public void debug(String msg, Seq<Object> refs) {
        Logging$class.debug(this, msg, refs);
    }

    @Override
    public void debug(Throwable t, String msg, Seq<Object> refs) {
        Logging$class.debug(this, t, msg, refs);
    }

    private StringReplacement ESCAPED_FRAGMENT_REPLACEMENT() {
        return this.ESCAPED_FRAGMENT_REPLACEMENT;
    }

    public Option<ParsingCandidate> getCleanedUrl(String urlToCrawl) {
        Some some;
        String finalURL = urlToCrawl.contains("#!") ? this.ESCAPED_FRAGMENT_REPLACEMENT().replaceAll(urlToCrawl) : urlToCrawl;
        try {
            URL url = new URL(finalURL);
            String linkhash = HashUtils$.MODULE$.md5(finalURL);
            some = new Some((Object)new ParsingCandidate(finalURL, linkhash, url));
        }
        catch (Exception exception) {
            this.critical("Unable to process URL: {0} due to an unexpected exception:\n\tException Type: {1}\n\tException Message: {2}\n\tException Stack:\n{3}", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{urlToCrawl, exception.getClass().getCanonicalName(), exception.getMessage(), this.getStackTraceString(exception)}));
            some = None$.MODULE$;
        }
        catch (MalformedURLException malformedURLException) {
            this.warn("{0} - is a malformed URL and cannot be processed", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{urlToCrawl}));
            some = None$.MODULE$;
        }
        return some;
    }

    public String getStackTraceString(Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public Option<URL> tryToURL(String url) {
        Some some;
        String finalUrl = url.contains("#!") ? this.ESCAPED_FRAGMENT_REPLACEMENT().replaceAll(url) : url;
        try {
            some = new Some((Object)new URL(finalUrl));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<URI> tryToURI(String url) {
        Some some;
        String finalUrl = url.contains("#!") ? this.ESCAPED_FRAGMENT_REPLACEMENT().replaceAll(url) : url;
        try {
            some = new Some((Object)URI.create(finalUrl));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    private URLHelper$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ESCAPED_FRAGMENT_REPLACEMENT = StringReplacement$.MODULE$.compile("#!", "?_escaped_fragment_=");
    }
}

