/*
 * Copyright 2018 beanit
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package com.beanit.asn1bean.compiler.cli;

public abstract class CliParameter {

  final String name;
  final String description;
  final boolean optional;
  boolean selected;

  CliParameter(CliParameterBuilder builder) {
    name = builder.name;
    description = builder.description;
    optional = builder.optional;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public boolean isOptional() {
    return optional;
  }

  public boolean isSelected() {
    return selected;
  }

  abstract int parse(String[] args, int i) throws CliParseException;

  abstract int appendSynopsis(StringBuilder sb);

  abstract void appendDescription(StringBuilder sb);
}
