/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber;

import com.beanit.asn1bean.util.HexString;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerTag
implements Serializable {
    public static final int UNIVERSAL_CLASS = 0;
    public static final int APPLICATION_CLASS = 64;
    public static final int CONTEXT_CLASS = 128;
    public static final int PRIVATE_CLASS = 192;
    public static final int PRIMITIVE = 0;
    public static final int CONSTRUCTED = 32;
    public static final int BOOLEAN_TAG = 1;
    public static final int INTEGER_TAG = 2;
    public static final int BIT_STRING_TAG = 3;
    public static final int OCTET_STRING_TAG = 4;
    public static final int NULL_TAG = 5;
    public static final int OBJECT_IDENTIFIER_TAG = 6;
    public static final int OBJECT_DESCRIPTOR_TAG = 7;
    public static final int REAL_TAG = 9;
    public static final int ENUMERATED_TAG = 10;
    public static final int UTF8_STRING_TAG = 12;
    public static final int TIME_TAG = 14;
    public static final int SEQUENCE_TAG = 16;
    public static final int SET_TAG = 17;
    public static final int NUMERIC_STRING_TAG = 18;
    public static final int PRINTABLE_STRING_TAG = 19;
    public static final int TELETEX_STRING_TAG = 20;
    public static final int VIDEOTEX_STRING_TAG = 21;
    public static final int IA5_STRING_TAG = 22;
    public static final int UTC_TIME_TAG = 23;
    public static final int GENERALIZED_TIME_TAG = 24;
    public static final int GRAPHIC_STRING_TAG = 25;
    public static final int VISIBLE_STRING_TAG = 26;
    public static final int GENERAL_STRING_TAG = 27;
    public static final int UNIVERSAL_STRING_TAG = 28;
    public static final int BMP_STRING_TAG = 30;
    public static final int DATE_TAG = 31;
    public static final int TIME_OF_DAY_TAG = 32;
    public static final int DATE_TIME_TAG = 33;
    public static final int DURATION_TAG = 34;
    public static final BerTag SEQUENCE = new BerTag(0, 32, 16);
    public static final BerTag SET = new BerTag(0, 32, 17);
    private static final long serialVersionUID = 1L;
    public byte[] tagBytes = null;
    public int tagClass;
    public int primitive;
    public int tagNumber;

    public BerTag(int identifierClass, int primitive, int tagNumber) {
        this.tagClass = identifierClass;
        this.primitive = primitive;
        this.tagNumber = tagNumber;
        this.code();
    }

    public BerTag() {
    }

    private void code() {
        if (this.tagNumber < 31) {
            this.tagBytes = new byte[1];
            this.tagBytes[0] = (byte)(this.tagClass | this.primitive | this.tagNumber);
        } else {
            int tagLength = 1;
            while ((double)this.tagNumber > Math.pow(2.0, 7 * tagLength) - 1.0) {
                ++tagLength;
            }
            this.tagBytes = new byte[1 + tagLength];
            this.tagBytes[0] = (byte)(this.tagClass | this.primitive | 0x1F);
            for (int j = 1; j <= tagLength - 1; ++j) {
                this.tagBytes[j] = (byte)(this.tagNumber >> 7 * (tagLength - j) & 0xFF | 0x80);
            }
            this.tagBytes[tagLength] = (byte)(this.tagNumber & 0x7F);
        }
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.tagBytes == null) {
            this.code();
        }
        for (int i = this.tagBytes.length - 1; i >= 0; --i) {
            reverseOS.write(this.tagBytes[i]);
        }
        return this.tagBytes.length;
    }

    public int encodeForwards(OutputStream os) throws IOException {
        if (this.tagBytes == null) {
            this.code();
        }
        for (int i = 0; i < this.tagBytes.length; ++i) {
            os.write(this.tagBytes[i]);
        }
        return this.tagBytes.length;
    }

    public int decode(InputStream is) throws IOException {
        int nextByte = is.read();
        if (nextByte == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        this.tagClass = nextByte & 0xC0;
        this.primitive = nextByte & 0x20;
        this.tagNumber = nextByte & 0x1F;
        int codeLength = 1;
        if (this.tagNumber == 31) {
            this.tagNumber = 0;
            int numTagBytes = 0;
            do {
                if ((nextByte = is.read()) == -1) {
                    throw new EOFException("Unexpected end of input stream.");
                }
                ++codeLength;
                if (numTagBytes >= 6) {
                    throw new IOException("Tag is too large.");
                }
                this.tagNumber <<= 7;
                this.tagNumber |= nextByte & 0x7F;
                ++numTagBytes;
            } while ((nextByte & 0x80) != 0);
        }
        this.tagBytes = null;
        return codeLength;
    }

    public int decode(InputStream is, OutputStream os) throws IOException {
        int nextByte = is.read();
        if (nextByte == -1) {
            throw new EOFException("Unexpected end of input stream.");
        }
        os.write(nextByte);
        this.tagClass = nextByte & 0xC0;
        this.primitive = nextByte & 0x20;
        this.tagNumber = nextByte & 0x1F;
        int codeLength = 1;
        if (this.tagNumber == 31) {
            this.tagNumber = 0;
            int numTagBytes = 0;
            do {
                if ((nextByte = is.read()) == -1) {
                    throw new EOFException("Unexpected end of input stream.");
                }
                os.write(nextByte);
                ++codeLength;
                if (numTagBytes >= 6) {
                    throw new IOException("Tag is too large.");
                }
                this.tagNumber <<= 7;
                this.tagNumber |= nextByte & 0x7F;
                ++numTagBytes;
            } while ((nextByte & 0x80) != 0);
        }
        this.tagBytes = null;
        return codeLength;
    }

    public int decodeAndCheck(InputStream is) throws IOException {
        if (this.tagBytes == null) {
            this.code();
        }
        for (byte identifierByte : this.tagBytes) {
            int nextByte = is.read();
            if (nextByte == -1) {
                throw new EOFException("Unexpected end of input stream.");
            }
            if (nextByte == (identifierByte & 0xFF)) continue;
            throw new IOException("Identifier does not match, expected: 0x" + HexString.fromByte(identifierByte) + ", received: 0x" + HexString.fromByte((byte)nextByte));
        }
        return this.tagBytes.length;
    }

    public boolean equals(int identifierClass, int primitive, int tagNumber) {
        return this.tagNumber == tagNumber && this.tagClass == identifierClass && this.primitive == primitive;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BerTag)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BerTag berIdentifier = (BerTag)obj;
        return this.tagNumber == berIdentifier.tagNumber && this.tagClass == berIdentifier.tagClass && this.primitive == berIdentifier.primitive;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.tagNumber;
        hash = hash * 31 + this.tagClass;
        hash = hash * 31 + this.primitive;
        return hash;
    }

    public String toString() {
        return "identifier class: " + this.tagClass + ", primitive: " + this.primitive + ", tag number: " + this.tagNumber;
    }
}

