/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.asn1bean.ber.types;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.internal.Util;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.asn1bean.util.HexString;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerOctetString
implements Serializable,
BerType {
    public static final BerTag tag = new BerTag(0, 0, 4);
    private static final long serialVersionUID = 1L;
    public byte[] value;

    public BerOctetString() {
    }

    public BerOctetString(byte[] value) {
        this.value = value;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        reverseOS.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        if (withTag) {
            int nextByte = is.read();
            switch (nextByte) {
                case -1: {
                    throw new EOFException("Unexpected end of input stream.");
                }
                case 4: {
                    return 1 + this.decodePrimitiveOctetString(is);
                }
                case 36: {
                    return 1 + this.decodeConstructedOctetString(is);
                }
            }
            throw new IOException("Octet String identifier does not match, expected: 0x04 or 0x24, received: 0x" + HexString.fromByte((byte)nextByte));
        }
        return this.decodePrimitiveOctetString(is);
    }

    private int decodeConstructedOctetString(InputStream is) throws IOException {
        int vLength;
        BerLength length = new BerLength();
        int lengthLength = length.decode(is);
        this.value = new byte[0];
        if (length.val < 0) {
            BerTag berTag = new BerTag();
            vLength += berTag.decode(is);
            while (!berTag.equals(0, 0, 0)) {
                BerOctetString subOctetString = new BerOctetString();
                vLength += subOctetString.decode(is, false);
                this.value = this.concatenate(this.value, subOctetString.value);
                vLength += berTag.decode(is);
            }
            vLength += BerLength.readEocByte(is);
        } else {
            BerOctetString subOctetString;
            for (vLength = 0; vLength < length.val; vLength += subOctetString.decode(is)) {
                subOctetString = new BerOctetString();
                this.value = this.concatenate(this.value, subOctetString.value);
            }
        }
        return lengthLength + vLength;
    }

    private byte[] concatenate(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    private int decodePrimitiveOctetString(InputStream is) throws IOException {
        int codeLength = 0;
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            Util.readFully(is, this.value);
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        return HexString.fromBytes(this.value);
    }
}

