/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.HexString;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.Integer32;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;

public abstract class BdaBitString
extends BasicDataAttribute {
    final int maxNumBits;
    volatile byte[] value;

    protected BdaBitString(ObjectReference objectReference, Fc fc, String sAddr, int maxNumBits, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.maxNumBits = maxNumBits;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value.length != (this.maxNumBits - 1) / 8 + 1) {
            throw new IllegalArgumentException("value does not have correct length.");
        }
        this.value = value;
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaBitString)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public int getMaxNumBits() {
        return this.maxNumBits;
    }

    @Override
    public void setDefault() {
        this.value = new byte[(this.maxNumBits - 1) / 8 + 1];
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setBitString(new BerBitString(this.value, this.maxNumBits));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getBitString() == null) {
            throw new ServiceError(10, "expected type: bit_string");
        }
        if (data.getBitString().numBits > this.maxNumBits) {
            throw new ServiceError(10, this.objectReference + ": bit_string is bigger than type's size: " + data.getBitString().numBits + ">" + this.maxNumBits);
        }
        this.value = data.getBitString().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setBitString(new Integer32(this.maxNumBits * -1));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + HexString.fromBytes(this.value);
    }

    @Override
    public String getValueString() {
        return HexString.fromBytes(this.value);
    }
}

